/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.common;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import ru.bitel.common.Utils;

public class VersionInfo {
    private Properties properties;

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    private String getProperty(String name) {
        return this.properties != null ? this.properties.getProperty(name, "") : "";
    }

    public String getModuleName() {
        return this.getProperty("name");
    }

    public String getVersion() {
        return this.getProperty("version");
    }

    public String getBuildNumber() {
        return this.getProperty("build.number");
    }

    public String getBuildTime() {
        return this.getProperty("build.time");
    }

    public static String formatVersionString(String ver, String build, String time) {
        return Utils.notBlankString(ver) && Utils.notBlankString(build) && Utils.notBlankString(time) ? String.format("%s.%s / %s", ver, build, time) : "?";
    }

    public String getVersionString() {
        return VersionInfo.formatVersionString(this.getVersion(), this.getBuildNumber(), this.getBuildTime());
    }

    public static final VersionInfo getVersionInfo(String module) {
        VersionInfo result = new VersionInfo();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader != null) {
            InputStream is = classLoader.getResourceAsStream("ru/bitel/bgbilling/properties/" + module + ".properties");
            if (is == null) {
                if ("server".equals(module)) {
                    is = classLoader.getResourceAsStream("modules/kernel/server.properties");
                } else if ("client".equals(module)) {
                    is = classLoader.getResourceAsStream("modules/client/client.properties");
                } else {
                    int i;
                    is = classLoader.getResourceAsStream("modules/" + module + "/" + module + ".properties");
                    if (is == null && (is = classLoader.getResourceAsStream("modules/" + module + "/module/" + module + ".properties")) == null && (i = module.lastIndexOf(46)) != -1) {
                        is = classLoader.getResourceAsStream("modules/plugins." + module.substring(i + 1) + "/" + module + ".properties");
                    }
                }
            }
            if (is != null) {
                try {
                    Properties p = new Properties();
                    p.load(is);
                    result.setProperties(p);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }
}

