/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.rfc2251;

import com.novell.ldap.LDAPException;
import com.novell.ldap.asn1.ASN1Boolean;
import com.novell.ldap.asn1.ASN1Enumerated;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.rfc2251.RfcAttributeDescriptionList;
import com.novell.ldap.rfc2251.RfcFilter;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcRequest;

public class RfcSearchRequest
extends ASN1Sequence
implements RfcRequest {
    public RfcSearchRequest(RfcLDAPDN baseObject, ASN1Enumerated scope, ASN1Enumerated derefAliases, ASN1Integer sizeLimit, ASN1Integer timeLimit, ASN1Boolean typesOnly, RfcFilter filter, RfcAttributeDescriptionList attributes) {
        super(8);
        this.add(baseObject);
        this.add(scope);
        this.add(derefAliases);
        this.add(sizeLimit);
        this.add(timeLimit);
        this.add(typesOnly);
        this.add(filter);
        this.add(attributes);
    }

    RfcSearchRequest(ASN1Object[] origRequest, String base, String filter, boolean request) throws LDAPException {
        super(origRequest, origRequest.length);
        int scope;
        if (base != null) {
            this.set(0, new RfcLDAPDN(base));
        }
        if (request && (scope = ((ASN1Enumerated)origRequest[1]).intValue()) == 1) {
            this.set(1, new ASN1Enumerated(0));
        }
        if (filter != null) {
            this.set(6, new RfcFilter(filter));
        }
    }

    public final ASN1Identifier getIdentifier() {
        return new ASN1Identifier(1, true, 3);
    }

    public final RfcRequest dupRequest(String base, String filter, boolean request) throws LDAPException {
        return new RfcSearchRequest(this.toArray(), base, filter, request);
    }

    public final String getRequestDN() {
        return ((RfcLDAPDN)this.get(0)).stringValue();
    }
}

