/*
 * Decompiled with CFR 0.152.
 */
package com.novell.ldap.rfc2251;

import com.novell.ldap.LDAPException;
import com.novell.ldap.asn1.ASN1Identifier;
import com.novell.ldap.asn1.ASN1Integer;
import com.novell.ldap.asn1.ASN1Object;
import com.novell.ldap.asn1.ASN1Sequence;
import com.novell.ldap.rfc2251.RfcAuthenticationChoice;
import com.novell.ldap.rfc2251.RfcLDAPDN;
import com.novell.ldap.rfc2251.RfcRequest;

public class RfcBindRequest
extends ASN1Sequence
implements RfcRequest {
    private static final ASN1Identifier ID = new ASN1Identifier(1, true, 0);

    public RfcBindRequest(ASN1Integer version, RfcLDAPDN name, RfcAuthenticationChoice auth) {
        super(3);
        this.add(version);
        this.add(name);
        this.add(auth);
    }

    public RfcBindRequest(int version, String dn, String mechanism, byte[] credentials) {
        this(new ASN1Integer(version), new RfcLDAPDN(dn), new RfcAuthenticationChoice(mechanism, credentials));
    }

    RfcBindRequest(ASN1Object[] origRequest, String base) throws LDAPException {
        super(origRequest, origRequest.length);
        if (base != null) {
            this.set(1, new RfcLDAPDN(base));
        }
    }

    public final void setVersion(ASN1Integer version) {
        this.set(0, version);
    }

    public final void setName(RfcLDAPDN name) {
        this.set(1, name);
    }

    public final void setAuthenticationChoice(RfcAuthenticationChoice auth) {
        this.set(2, auth);
    }

    public final ASN1Integer getVersion() {
        return (ASN1Integer)this.get(0);
    }

    public final RfcLDAPDN getName() {
        return (RfcLDAPDN)this.get(1);
    }

    public final RfcAuthenticationChoice getAuthenticationChoice() {
        return (RfcAuthenticationChoice)this.get(2);
    }

    public final ASN1Identifier getIdentifier() {
        return ID;
    }

    public final RfcRequest dupRequest(String base, String filter, boolean request) throws LDAPException {
        return new RfcBindRequest(this.toArray(), base);
    }

    public final String getRequestDN() {
        return ((RfcLDAPDN)this.get(1)).stringValue();
    }
}

