/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.renderers;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import java.util.List;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintImageAreaHyperlink;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.util.SimpleDimension2D;
import net.sf.jasperreports.renderers.AbstractRenderToImageAwareRenderer;
import net.sf.jasperreports.renderers.AreaHyperlinksRenderable;
import net.sf.jasperreports.renderers.BatikFontFamilyResolver;
import net.sf.jasperreports.renderers.BatikUserAgent;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import org.apache.batik.anim.dom.SAXSVGDocumentFactory;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.GVTBuilder;
import org.apache.batik.bridge.UserAgent;
import org.apache.batik.bridge.ViewBox;
import org.apache.batik.dom.svg.SVGDocumentFactory;
import org.apache.batik.ext.awt.image.GraphicsUtil;
import org.apache.batik.gvt.GraphicsNode;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.svg.SVGDocument;

public abstract class AbstractSvgDataToGraphics2DRenderer
extends AbstractRenderToImageAwareRenderer
implements DataRenderable,
Graphics2DRenderable,
DimensionRenderable,
AreaHyperlinksRenderable {
    private static final long serialVersionUID = 10200L;
    private List<JRPrintImageAreaHyperlink> areaHyperlinks;
    private transient SoftReference<GraphicsNode> rootNodeRef;
    private transient Dimension2D documentSize;

    protected AbstractSvgDataToGraphics2DRenderer(List<JRPrintImageAreaHyperlink> areaHyperlinks) {
        this.areaHyperlinks = areaHyperlinks;
    }

    @Override
    public Graphics2D createGraphics(BufferedImage bi) {
        Graphics2D graphics = GraphicsUtil.createGraphics((BufferedImage)bi);
        return graphics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(JasperReportsContext jasperReportsContext, Graphics2D grx, Rectangle2D rectangle) throws JRException {
        GraphicsNode rootNode = this.getRootNode(jasperReportsContext);
        AffineTransform transform = ViewBox.getPreserveAspectRatioTransform((float[])new float[]{0.0f, 0.0f, (float)this.documentSize.getWidth(), (float)this.documentSize.getHeight()}, (short)1, (boolean)true, (float)((float)rectangle.getWidth()), (float)((float)rectangle.getHeight()));
        Graphics2D graphics = (Graphics2D)grx.create();
        try {
            graphics.translate(rectangle.getX(), rectangle.getY());
            graphics.transform(transform);
            GraphicsNode graphicsNode = rootNode;
            synchronized (graphicsNode) {
                rootNode.paint(graphics);
            }
        }
        finally {
            graphics.dispose();
        }
    }

    @Override
    public Dimension2D getDimension(JasperReportsContext jasperReportsContext) {
        try {
            this.getRootNode(jasperReportsContext);
            return this.documentSize;
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected synchronized GraphicsNode getRootNode(JasperReportsContext jasperReportsContext) throws JRException {
        if (this.rootNodeRef == null || this.rootNodeRef.get() == null) {
            BatikFontFamilyResolver fontFamilyResolver = BatikFontFamilyResolver.getInstance(jasperReportsContext);
            BatikUserAgent userAgentForDoc = new BatikUserAgent(fontFamilyResolver, 0.35277778f);
            SAXSVGDocumentFactory documentFactory = new SAXSVGDocumentFactory(userAgentForDoc.getXMLParserClassName(), true);
            documentFactory.setValidating(userAgentForDoc.isXMLParserValidating());
            SVGDocument document = this.getSvgDocument(jasperReportsContext, (SVGDocumentFactory)documentFactory);
            Node svgNode = document.getElementsByTagName("svg").item(0);
            Node svgWidthNode = svgNode.getAttributes().getNamedItem("width");
            Node svgHeightNode = svgNode.getAttributes().getNamedItem("height");
            String strSvgWidth = svgWidthNode == null ? null : svgWidthNode.getNodeValue().trim();
            String strSvgHeight = svgHeightNode == null ? null : svgHeightNode.getNodeValue().trim();
            float pixel2mm = 0.35277778f;
            if (strSvgWidth != null && strSvgWidth.endsWith("mm") || strSvgHeight != null && strSvgHeight.endsWith("mm")) {
                pixel2mm = 0.26458332f;
            }
            BatikUserAgent userAgentForCtx = new BatikUserAgent(fontFamilyResolver, pixel2mm);
            BridgeContext ctx = new BridgeContext((UserAgent)userAgentForCtx);
            ctx.setDynamic(true);
            GVTBuilder builder = new GVTBuilder();
            GraphicsNode rootNode = builder.build(ctx, (Document)document);
            this.rootNodeRef = new SoftReference<GraphicsNode>(rootNode);
            Dimension2D svgSize = ctx.getDocumentSize();
            this.documentSize = new SimpleDimension2D(svgSize.getWidth(), svgSize.getHeight());
        }
        return this.rootNodeRef.get();
    }

    protected abstract SVGDocument getSvgDocument(JasperReportsContext var1, SVGDocumentFactory var2) throws JRException;

    @Override
    public List<JRPrintImageAreaHyperlink> getImageAreaHyperlinks(Rectangle2D renderingArea) throws JRException {
        return this.areaHyperlinks;
    }

    @Override
    public boolean hasImageAreaHyperlinks() {
        return this.areaHyperlinks != null && !this.areaHyperlinks.isEmpty();
    }
}

