<%@ page contentType="text/html; charset=UTF-8"%>
<%@ include file="/WEB-INF/jspf/include/taglibs.jsp"%>
<html>
	<head>
		<link href="${contextPath}/css/jquery-ui.min.css" rel="stylesheet" type="text/css"/>
		<link href="${contextPath}/style.css" rel="stylesheet" type="text/css"/>
		<!-- специальный пустой css файл для пользовательский стилей, не перетирается при обновлениях -->
		<link href="${contextPath}/custom.css" rel="stylesheet" type="text/css"/>
		<script src="${contextPath}/js/jquery-min.js"></script>
		<script src="${contextPath}/js/jquery.form.js"></script>
		<script src="${contextPath}/js/jquery-ui.min.js"></script>
		<script src="${contextPath}/js/common.js"></script>
		<script src="${contextPath}/js/bgbilling.js"></script>
		<script src="${contextPath}/js/jquery.bg.widgets.js"></script>
		<!-- специальный пустой js файл для пользовательский функций, не перетирается при обновлениях -->
		<script src="${contextPath}/js/custom.js"></script>
		<title>BGBilling || <tiles:getAsString name="pageTitle"/></title>
		
		<script>
			function disableButton( button ) {	
				button.disabled = true;	   
			}
		</script>
	</head>
	<body>
		<div id="all">
			<!-- logo  -->
			<div class="header"><div class="logo"></div></div>
			<!-- end logo  -->

			<!-- title  -->
			<div class="pageTitle">
		        	<c:if test="${not empty contract}">Договор № ${contract.title}</c:if>
		        	<c:if test="${not empty pageTitle}">${pageTitle}</c:if>
			</div>
			<!-- end title  -->
	
			<!-- contracts  -->
			<div class="contracts">
				<c:if test="${not empty contract}">
				<c:if test="${not empty subContract}">
					<b>Субдоговор:</b>
					<ul><li style="background: none;"><a href="?action=Super&amp;mid=contract&amp;id=${subContract.id}">${subContract.title}</a></li></ul>
				</c:if>
				<c:if test="${not empty superContract}">
					<b>Супердоговор:</b>
					<ul><li style="background: none;"><a href="?action=Super&mid=contract&id=-1">${superContract.title}</a></li></ul>
				</c:if>
				<c:if test="${not empty subContractList}">
					<b>Субдоговор(ы):</b>
					<c:choose>
					<c:when test="${fn:length(subContractList) <= 5}">
					<ul>
						<c:forEach var="item" items="${subContractList}" varStatus="status">
							<c:set var="background"><c:if test="${status.index == 0}">style="background: none;"</c:if></c:set>
							<li ${background}><a href="?action=Super&mid=contract&id=${item.id}">${item.title}</a></li>
						</c:forEach>
					</ul>
					</c:when>
					<c:otherwise>
					<form action="" method="GET" style="display: inline">
						<input type="hidden" name="action" value="Super"/>
						<input type="hidden" name="module" value="contract"/>
						<input type="hidden" name="mid" value="0"/>
						<select name="id" onChange="this.form.submit();" style="margin: 0pt; margin-left: 5pt;">
					        <option value="-1">-</option>
					        <c:forEach var="item" items="${subContractList}">
					        	<c:set var="selected"><c:if test="${item.id == contract.id}">selected="selected"</c:if></c:set>
				                <option value="${item.id}" ${selected}>${item.title}</option>
					        </c:forEach>
						</select>
                       </form>
					</c:otherwise>
					</c:choose>
				</c:if>
				</c:if>
			</div>
			<!-- end contracts  -->
			
			<!-- slim blue line  -->
			<div class="line"></div>
			<!-- end slim blue line  -->
	
			<!-- menu -->
			<c:if test="${not empty contract}"><%@ include file="../include/menu_main.jsp" %></c:if>
			<!-- end menu -->
	
			<!-- content -->
			<div class="content">
				<noscript>
	        		<div class="errorMessage">ВНИМАНИЕ!!! Для корректной работы с данным сайтом необходимо включить поддержку JavaScript в браузере. Как это сделать смотрите <a href="help/javascript.html">здесь</a>.</div>
	        	</noscript>
        	
	        	<script>
			      <!--
						document.cookie = 'BGBILLING=1';
						var ccc = document.cookie;
						if ( ccc == undefined || ccc.length == 0 || ccc.indexOf( "BGBILLING" ) == -1 ) { document.write( '<div class="errorMessage">ВНИМАНИЕ!!! Для корректной работы с данным сайтом необходимо включить поддержку Cookies в браузере. Как это сделать смотрите <a href="#"	onClick="window.open(\'help/cookies.html\', \'mywin2\', \'toolbar=no,status=no,width=600,height=455\'); return false;">здесь</a>.</div>' ); }
			      	--> 
			    </script>
			
				<c:if test="${not empty contract}">
					<div class="pageTitle" id="pageTitle"><tiles:getAsString name="pageTitle"/></div>
					<br/><c:if test="${not empty errorStatus}"><div class="errorMessage">${errorStatus[1]}</div></c:if>
				</c:if>

				<div id="idDiv${action}">
					<tiles:getAsString name="body" />
				</div>
			</div>
			<!-- end content -->
	
      		<tiles:insertAttribute name="footer" />
      	</div>
    </body>
</html>