#!/bin/bash

cd ${0%${0##*/}}.

. ./setenv.sh

COMMON_PARAMS="-Dnetworkaddress.cache.ttl=3600 -Djava.net.preferIPv4Stack=true"

if [ -z "$BGBILLING_JAVA_VERSION" ]; then
  BGBILLING_JAVA_VERSION="1.8"
fi

if [ "$BGBILLING_JAVA_VERSION" = '1.8' ]; then
    COMMON_PARAMS="$COMMON_PARAMS -Djava.endorsed.dirs=${BGBILLING_SERVER_DIR}/lib/endorsed:${JAVA_HOME}/lib/endorsed"
else
    COMMON_PARAMS="$COMMON_PARAMS --add-modules java.xml.bind,java.xml.ws"
fi

CLASSPATH=${BGBILLING_SERVER_DIR}:${BGBILLING_SERVER_DIR}/lib/ext/bgcommon-boot.jar:${BGBILLING_SERVER_DIR}/lib/ext/*
PARAMS="-Dboot.info=1 -Dapp.name=BGDataLoader -Dlog4j.configuration=data/log4j.xml -Dlog.dir.path=log/ -Dlog.prefix=dataloader"
MEMORY="-Xmx512m"

if [ ! -d "${BGBILLING_SERVER_DIR}/.run" ] ; then
    mkdir ${BGBILLING_SERVER_DIR}/.run
fi

if [ "$1" = "-estart" ]; then
	#starting
	nohup  /bin/nice -5 ${JAVA_HOME}/bin/java ${COMMON_PARAMS} ${PARAMS} ${MEMORY} -cp ${CLASSPATH} ru.bitel.common.bootstrap.Boot bitel.billing.server.DataLoader $1 $2 $3 > ./log/dataloader.out 2>&1 & echo $! > .run/bgdataloader.pid &
else
	if [ "$1" = "debug" ]; then
		#starting in debug mode
		nohup  /bin/nice -5 ${JAVA_HOME}/bin/java ${COMMON_PARAMS} ${PARAMS} ${MEMORY} -cp ${CLASSPATH} -enableassertions -Xdebug -Xnoagent -Xrunjdwp:transport=dt_socket,address=5589,server=y,suspend=n ru.bitel.common.bootstrap.Boot bitel.billing.server.DataLoader -estart $2 $3 > ./log/dataloader.out 2>&1 & echo $! > .run/bgdataloader.pid &
	else
		#execute command
		${JAVA_HOME}/bin/java ${COMMON_PARAMS} -cp ${CLASSPATH} ru.bitel.common.bootstrap.Boot bitel.billing.server.DataLoader $1 $2 $3
	fi
fi

