#!/bin/bash

cd ${0%${0##*/}}.

. ./setenv.sh

KEYSTORE=".bgclient_keystore"
if [ -e .bgclient_keystore_user ]; then
    KEYSTORE=".bgclient_keystore_user"
fi

checkJar()
{
    if [ -e $1 ]; then
        A=`sha1sum $1 | cut -c1-40`
        B=""
        if [ -e webroot/client/${1}.sha ]; then
            B=`cat webroot/client/${1}.sha`
        fi
        if [ "$A" != "$B" ]; then
            ${JAVA_HOME}/bin/jarsigner -tsa http://timestamp.digicert.com -keystore ${KEYSTORE} -storepass "${PASSWORD-123456}" $1 bgbilling
            echo "${A}" > webroot/client/${1}.sha
            mv -f $1 webroot/client/
        else
            rm -f $1
        fi
    fi
}

${JAVA_HOME}/bin/java -cp ./:./lib/app/kernel.jar:./lib/ext/mysql-connector-java.jar ru.bitel.bgbilling.utils.javawebstart.BGClient_JavaWebStart

if [ ! -e webroot/client/JNLP-INF ]; then
     mkdir webroot/client/JNLP-INF
fi

cp -f webroot/client/bgclient.jnlp  webroot/client/JNLP-INF/APPLICATION.JNLP

${JAVA_HOME}/bin/jar -ufv client.jar -C webroot/client JNLP-INF/APPLICATION.JNLP

checkJar client.jar
checkJar client_libs.jar

if [ -e bgclient_javawebstart_user.sh ]; then
    . ./bgclient_javawebstart_user.sh
fi
