/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.util;

import java.util.Date;
import java.util.Random;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.params.DESParameters;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.DecodingException;
import uk.co.westhawk.snmp.stack.EncodingException;
import uk.co.westhawk.snmp.stack.PduException;

public class SnmpUtilities {
    private static final String version_id = "@(#)$Id: SnmpUtilities.java,v 1.25 2006/11/29 16:12:50 birgit Exp $ Copyright Westhawk Ltd";
    static final int ONEMEG = 0x100000;
    static final int SALT_LENGTH = 8;
    private static int salt_count = -1;
    static final char[] HEX_DIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String getSnmpVersionString(int version) {
        String versionString;
        switch (version) {
            case 0: {
                versionString = "SNMPv1";
                break;
            }
            case 1: {
                versionString = "SNMPv2c";
                break;
            }
            case 3: {
                versionString = "SNMPv3";
                break;
            }
            default: {
                versionString = "Unsupported version no " + version;
            }
        }
        return versionString;
    }

    public static byte[] toBytes(String hexStr) {
        int mask = 127;
        byte[] bytes = new byte[]{};
        if (hexStr != null) {
            hexStr = hexStr.toUpperCase();
            int len = hexStr.length();
            bytes = new byte[len / 2];
            int sPos = 0;
            int bPos = 0;
            while (sPos < len) {
                char a = hexStr.charAt(sPos);
                char b = hexStr.charAt(sPos + 1);
                int v1 = Character.digit(a, 16);
                int v2 = Character.digit(b, 16);
                int v3 = v1 * 16 + v2;
                bytes[bPos] = (byte)v3;
                sPos += 2;
                ++bPos;
            }
        }
        return bytes;
    }

    public static byte longToByte(long l) throws IllegalArgumentException {
        byte ret = 0;
        if (l < 0L || l > 255L) {
            throw new IllegalArgumentException("Valid byte values are between 0 and 255.Got " + l);
        }
        ret = (byte)l;
        return ret;
    }

    public static byte[] longToByte(long[] l) throws IllegalArgumentException {
        int len = l.length;
        byte[] ret = new byte[len];
        for (int i = 0; i < len; ++i) {
            ret[i] = SnmpUtilities.longToByte(l[i]);
        }
        return ret;
    }

    public static void dumpBytes(String headerStr, byte[] bytes) {
        StringBuffer buf = new StringBuffer(bytes.length);
        buf.append("\n");
        buf.append(headerStr).append("\n");
        buf.append("bytes.length: ").append(bytes.length).append("\n");
        int len = bytes.length;
        int i = 0;
        for (i = 0; i < len; ++i) {
            buf.append(SnmpUtilities.toHex(bytes[i]) + " ");
            if (0 != (i + 1) % 8) continue;
            buf.append("\n");
        }
        buf.append("\n");
        System.out.println(buf.toString());
    }

    public static String toHexString(byte[] bytes) {
        String str = "";
        if (bytes != null) {
            int len = bytes.length;
            for (int i = 0; i < len; ++i) {
                str = str + SnmpUtilities.toHex(bytes[i]);
            }
        }
        return str;
    }

    public static String toHex(int val) {
        int val1 = val >> 4 & 0xF;
        int val2 = val & 0xF;
        return "" + HEX_DIGIT[val1] + HEX_DIGIT[val2];
    }

    public static boolean areBytesEqual(byte[] array1, byte[] array2) {
        boolean same = true;
        int len1 = array1.length;
        if (len1 == array2.length) {
            for (int i = 0; i < len1 && same; ++i) {
                same = array1[i] == array2[i];
            }
        } else {
            same = false;
        }
        return same;
    }

    public static byte[] getLocalizedKeyMD5(byte[] passwKey, String engineId) {
        byte[] ret = null;
        MD5Digest mdc = new MD5Digest();
        mdc.reset();
        byte[] beid = SnmpUtilities.toBytes(engineId);
        if (beid != null && passwKey != null) {
            mdc.update(passwKey, 0, passwKey.length);
            mdc.update(beid, 0, beid.length);
            mdc.update(passwKey, 0, passwKey.length);
            ret = new byte[mdc.getDigestSize()];
            mdc.doFinal(ret, 0);
        }
        return ret;
    }

    public static byte[] getLocalizedKeySHA1(byte[] passwKey, String engineId) {
        byte[] ret = null;
        SHA1Digest mdc = new SHA1Digest();
        mdc.reset();
        byte[] beid = SnmpUtilities.toBytes(engineId);
        if (beid != null && passwKey != null) {
            mdc.update(passwKey, 0, passwKey.length);
            mdc.update(beid, 0, beid.length);
            mdc.update(passwKey, 0, passwKey.length);
            ret = new byte[mdc.getDigestSize()];
            mdc.doFinal(ret, 0);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] passwordToKeySHA1(String password) {
        byte[] ret = null;
        SHA1Digest sha = new SHA1Digest();
        byte[] passwordBuf = new byte[64];
        int pl = password.length();
        byte[] pass = new byte[pl];
        for (int i = 0; i < pl; ++i) {
            pass[i] = (byte)(0xFF & password.charAt(i));
        }
        int passwordIndex = 0;
        Date then = AsnObject.debug > 1 ? new Date() : null;
        SHA1Digest sHA1Digest = sha;
        synchronized (sHA1Digest) {
            for (int count = 0; count < 0x100000; count += 64) {
                int cp = 0;
                int i = 0;
                while (i < 64) {
                    int len = 64 - cp;
                    int pim = passwordIndex % pl;
                    int pr = pl - pim;
                    if (len > pr) {
                        len = pr;
                    }
                    System.arraycopy(pass, pim, passwordBuf, cp, len);
                    i += len;
                    cp += len;
                    passwordIndex += len;
                }
                sha.update(passwordBuf, 0, passwordBuf.length);
            }
            ret = new byte[sha.getDigestSize()];
            sha.doFinal(ret, 0);
        }
        if (AsnObject.debug > 1) {
            Date now = new Date();
            long diff = now.getTime() - then.getTime();
            System.out.println("(Complex) pass to key takes " + (double)diff / 1000.0);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] passwordToKeyMD5(String password) {
        byte[] ret = null;
        MD5Digest mdc = new MD5Digest();
        byte[] passwordBuf = new byte[64];
        int pl = password.length();
        byte[] pass = new byte[pl];
        for (int i = 0; i < pl; ++i) {
            pass[i] = (byte)(0xFF & password.charAt(i));
        }
        int passwordIndex = 0;
        Date then = AsnObject.debug > 1 ? new Date() : null;
        MD5Digest mD5Digest = mdc;
        synchronized (mD5Digest) {
            for (int count = 0; count < 0x100000; count += 64) {
                int cp = 0;
                int i = 0;
                while (i < 64) {
                    int len = 64 - cp;
                    int pim = passwordIndex % pl;
                    int pr = pl - pim;
                    if (len > pr) {
                        len = pr;
                    }
                    System.arraycopy(pass, pim, passwordBuf, cp, len);
                    i += len;
                    cp += len;
                    passwordIndex += len;
                }
                mdc.update(passwordBuf, 0, passwordBuf.length);
            }
            ret = new byte[mdc.getDigestSize()];
            mdc.doFinal(ret, 0);
        }
        if (AsnObject.debug > 1) {
            Date now = new Date();
            long diff = now.getTime() - then.getTime();
            System.out.println("(Complex) pass to key takes " + (double)diff / 1000.0);
        }
        return ret;
    }

    public static final byte[] getFingerPrintMD5(byte[] key, byte[] message) {
        if (AsnObject.debug > 5 && key.length != 16) {
            System.out.println("MD5 key length wrong");
        }
        return SnmpUtilities.getFingerPrint(key, message, false);
    }

    public static final byte[] getFingerPrintSHA1(byte[] key, byte[] message) {
        if (AsnObject.debug > 5 && key.length != 20) {
            System.out.println("SHA1 key length wrong");
        }
        return SnmpUtilities.getFingerPrint(key, message, true);
    }

    public static final byte[] getSaltDES(int snmpEngineBoots) {
        if (salt_count == -1) {
            Random rand = new Random();
            salt_count = rand.nextInt();
        }
        byte[] salt = new byte[8];
        SnmpUtilities.setBytesFromInt(salt, snmpEngineBoots, 0);
        SnmpUtilities.setBytesFromInt(salt, salt_count, 4);
        ++salt_count;
        return salt;
    }

    public static final byte[] getDESKey(byte[] secretPrivacyKey) throws PduException {
        byte[] desKey = new byte[8];
        if (secretPrivacyKey.length < 16) {
            throw new PduException("SnmpUtilities.getDESKey(): secretPrivacyKey is < 16");
        }
        System.arraycopy(secretPrivacyKey, 0, desKey, 0, 8);
        return desKey;
    }

    public static final byte[] getInitialValue(byte[] secretPrivacyKey, byte[] salt) throws PduException {
        byte[] initV = new byte[8];
        if (secretPrivacyKey.length < 16) {
            throw new PduException("SnmpUtilities.getInitialValue(): secretPrivacyKey is < 16");
        }
        int spk = 8;
        for (int i = 0; i < initV.length; ++i) {
            initV[i] = (byte)(secretPrivacyKey[spk] ^ salt[i]);
            ++spk;
        }
        return initV;
    }

    public static final byte[] encrypt(byte[] plain, byte[] secretPrivacyKey, byte[] salt) throws EncodingException {
        byte[] desKey = null;
        byte[] iv = null;
        try {
            desKey = SnmpUtilities.getDESKey(secretPrivacyKey);
            iv = SnmpUtilities.getInitialValue(secretPrivacyKey, salt);
        }
        catch (PduException exc) {
            throw new EncodingException(exc.getMessage());
        }
        int l = plain.length;
        int div = l / 8;
        int mod = l % 8;
        if (mod > 0) {
            ++div;
        }
        int newL = div * 8;
        byte[] paddedOrig = new byte[newL];
        System.arraycopy(plain, 0, paddedOrig, 0, l);
        for (int i = l; i < newL; ++i) {
            paddedOrig[i] = 0;
        }
        DESEngine des = new DESEngine();
        DESParameters param = new DESParameters(desKey);
        des.init(true, (CipherParameters)param);
        byte[] result = new byte[newL];
        byte[] in = new byte[8];
        byte[] cipherText = iv;
        int posIn = 0;
        int posResult = 0;
        for (int b = 0; b < div; ++b) {
            for (int i = 0; i < 8; ++i) {
                in[i] = (byte)(paddedOrig[posIn] ^ cipherText[i]);
                ++posIn;
            }
            des.processBlock(in, 0, cipherText, 0);
            System.arraycopy(cipherText, 0, result, posResult, cipherText.length);
            posResult += cipherText.length;
        }
        return result;
    }

    public static final byte[] decrypt(byte[] encryptedText, byte[] salt, byte[] secretPrivacyKey) throws DecodingException {
        int l = encryptedText.length;
        int div = l / 8;
        int mod = l % 8;
        if (mod != 0) {
            throw new DecodingException("SnmpUtilities.decrypt(): The encrypted scoped PDU should be a multiple of 8 bytes");
        }
        byte[] desKey = null;
        byte[] iv = null;
        try {
            desKey = SnmpUtilities.getDESKey(secretPrivacyKey);
            iv = SnmpUtilities.getInitialValue(secretPrivacyKey, salt);
        }
        catch (PduException exc) {
            throw new DecodingException(exc.getMessage());
        }
        DESEngine des = new DESEngine();
        DESParameters param = new DESParameters(desKey);
        des.init(false, (CipherParameters)param);
        byte[] plain = new byte[l];
        byte[] in = new byte[8];
        byte[] out = new byte[8];
        byte[] cipherText = iv;
        int posPlain = 0;
        int posEncr = 0;
        for (int b = 0; b < div; ++b) {
            System.arraycopy(encryptedText, posEncr, in, 0, in.length);
            posEncr += in.length;
            des.processBlock(in, 0, out, 0);
            for (int i = 0; i < 8; ++i) {
                plain[posPlain] = (byte)(out[i] ^ cipherText[i]);
                ++posPlain;
            }
            System.arraycopy(in, 0, cipherText, 0, in.length);
        }
        return plain;
    }

    static byte[] getFingerPrint(byte[] key, byte[] message, boolean doSha) {
        int i;
        byte[] k1 = new byte[64];
        byte[] k2 = new byte[64];
        int z1 = 54;
        int z2 = 92;
        int kl = key.length;
        for (i = 0; i < kl; ++i) {
            k1[i] = (byte)(SnmpUtilities.ifb(key[i]) ^ 0x36);
            k2[i] = (byte)(SnmpUtilities.ifb(key[i]) ^ 0x5C);
        }
        while (i < 64) {
            k1[i] = z1;
            k2[i] = z2;
            ++i;
        }
        byte[] interm = null;
        SHA1Digest mdc = doSha ? new SHA1Digest() : new MD5Digest();
        mdc.reset();
        mdc.update(k1, 0, k1.length);
        mdc.update(message, 0, message.length);
        interm = new byte[mdc.getDigestSize()];
        mdc.doFinal(interm, 0);
        byte[] rettmp = null;
        SHA1Digest mdc2 = doSha ? new SHA1Digest() : new MD5Digest();
        mdc2.reset();
        mdc2.update(k2, 0, k2.length);
        mdc2.update(interm, 0, interm.length);
        rettmp = new byte[mdc2.getDigestSize()];
        mdc2.doFinal(rettmp, 0);
        byte[] ret = null;
        if (rettmp != null) {
            ret = new byte[12];
            System.arraycopy(rettmp, 0, ret, 0, 12);
        }
        return ret;
    }

    static final int ifb(byte b) {
        return SnmpUtilities.intFromByteWithoutStupidJavaSignExtension(b);
    }

    static final int intFromByteWithoutStupidJavaSignExtension(byte val) {
        int ret = 0x7F & val;
        if (val < 0) {
            ret += 128;
        }
        return ret;
    }

    static final void setBytesFromInt(byte[] ret, int value, int offs) {
        int v = value;
        int j = offs;
        ret[j++] = (byte)(v >>> 24 & 0xFF);
        ret[j++] = (byte)(v >>> 16 & 0xFF);
        ret[j++] = (byte)(v >>> 8 & 0xFF);
        ret[j++] = (byte)(v >>> 0 & 0xFF);
    }
}

