/*
 * Decompiled with CFR 0.152.
 */
package uk.co.westhawk.snmp.beans;

import java.io.IOException;
import uk.co.westhawk.snmp.event.RequestPduEvent;
import uk.co.westhawk.snmp.event.RequestPduListener;
import uk.co.westhawk.snmp.stack.AsnObject;
import uk.co.westhawk.snmp.stack.AsnUnsInteger;
import uk.co.westhawk.snmp.stack.ListeningContextPool;
import uk.co.westhawk.snmp.stack.Pdu;
import uk.co.westhawk.snmp.stack.PduException;
import uk.co.westhawk.snmp.stack.ReportPdu;
import uk.co.westhawk.snmp.stack.SnmpContextv3;
import uk.co.westhawk.snmp.stack.SnmpContextv3Discovery;
import uk.co.westhawk.snmp.stack.UsmAgent;
import uk.co.westhawk.snmp.util.SnmpUtilities;

public class UsmBeingDiscoveredBean
implements RequestPduListener {
    private static final String version_id = "@(#)$Id: UsmBeingDiscoveredBean.java,v 1.7 2006/03/23 14:54:09 birgit Exp $ Copyright Westhawk Ltd";
    private UsmAgent usmAgent = null;
    private SnmpContextv3 context = null;
    private SnmpContextv3Discovery discEngineIdContextIn;
    private SnmpContextv3Discovery discTimeLineContextIn;
    private SnmpContextv3 discEngineIdContextOut;
    private SnmpContextv3 discTimeLineContextOut;

    public UsmBeingDiscoveredBean(SnmpContextv3 myContext, UsmAgent myUsmAgent) throws IOException {
        this.usmAgent = myUsmAgent;
        this.context = myContext;
        if (AsnObject.debug > 4) {
            System.out.println(this.getClass().getName() + " Constructor:" + "usmAgent=" + this.usmAgent.toString() + "context=" + this.context.toString());
        }
        this.usmAgent.setSnmpContext(this.context);
        this.discEngineIdContextIn = new SnmpContextv3Discovery(this.context.getSendToHostAddress(), this.context.getPort(), this.context.getBindAddress(), this.context.getTypeSocket());
        this.discEngineIdContextIn.setUserName("");
        this.discEngineIdContextIn.setUseAuthentication(false);
        this.discEngineIdContextIn.setUsePrivacy(false);
        this.discEngineIdContextIn.setContextEngineId(SnmpUtilities.toBytes(this.usmAgent.getSnmpEngineId()));
        this.discEngineIdContextIn.setContextName("");
        this.discEngineIdContextIn.setUsmAgent(this.usmAgent);
        this.discTimeLineContextIn = new SnmpContextv3Discovery(this.context.getSendToHostAddress(), this.context.getPort(), this.context.getBindAddress(), this.context.getTypeSocket());
        this.discTimeLineContextIn.setUserName(this.context.getUserName());
        this.discTimeLineContextIn.setUseAuthentication(this.context.isUseAuthentication());
        this.discTimeLineContextIn.setAuthenticationProtocol(this.context.getAuthenticationProtocol());
        this.discTimeLineContextIn.setUserAuthenticationPassword(this.context.getUserAuthenticationPassword());
        this.discTimeLineContextIn.setUsePrivacy(this.context.isUsePrivacy());
        this.discTimeLineContextIn.setUserPrivacyPassword(this.context.getUserPrivacyPassword());
        this.discTimeLineContextIn.setContextEngineId(SnmpUtilities.toBytes(this.usmAgent.getSnmpEngineId()));
        this.discTimeLineContextIn.setContextName("");
        this.discTimeLineContextIn.setUsmAgent(this.usmAgent);
    }

    public void addRequestPduListener(ListeningContextPool lcontext) throws IOException {
        if (AsnObject.debug > 4) {
            System.out.println(this.getClass().getName() + ".addRequestPduListener(" + lcontext.toString() + ")");
        }
        this.discEngineIdContextIn.addRequestPduListener((RequestPduListener)this, lcontext);
        this.discTimeLineContextIn.addRequestPduListener((RequestPduListener)this, lcontext);
    }

    public void removeRequestPduListener(ListeningContextPool lcontext) throws IOException {
        if (AsnObject.debug > 4) {
            System.out.println(this.getClass().getName() + ".removeRequestPduListener(" + lcontext.toString() + ")");
        }
        this.discEngineIdContextIn.removeRequestPduListener((RequestPduListener)this, lcontext);
        this.discTimeLineContextIn.removeRequestPduListener((RequestPduListener)this, lcontext);
    }

    public void requestPduReceived(RequestPduEvent evt) {
        Object src = evt.getSource();
        int port = evt.getHostPort();
        Pdu orgPdu = evt.getPdu();
        if (src == this.discEngineIdContextIn) {
            this.sendEngineIdReport(orgPdu, port);
        } else {
            this.sendTimeLineReport(orgPdu, port);
        }
    }

    protected void sendEngineIdReport(Pdu orgPdu, int port) {
        block6: {
            if (AsnObject.debug > 4) {
                System.out.println(this.getClass().getName() + ".sendEngineIdReport()");
            }
            try {
                if (this.discEngineIdContextOut != null) {
                    this.discEngineIdContextOut.destroy();
                }
                this.discEngineIdContextOut = new SnmpContextv3(this.discEngineIdContextIn.getHost(), port, this.discEngineIdContextIn.getBindAddress(), this.discEngineIdContextIn.getTypeSocket());
                this.discEngineIdContextOut = (SnmpContextv3)this.discEngineIdContextIn.cloneParameters(this.discEngineIdContextOut);
                ReportPdu repPdu = new ReportPdu(this.discEngineIdContextOut, orgPdu);
                repPdu.addOid("1.3.6.1.6.3.15.1.1.4", (AsnObject)new AsnUnsInteger(this.usmAgent.getUsmStatsUnknownEngineIDs()));
                repPdu.send();
            }
            catch (IOException iexc) {
                if (AsnObject.debug > 4) {
                    System.out.println(this.getClass().getName() + ".sendEngineIdReport(): " + "IOException: " + iexc.getMessage());
                }
            }
            catch (PduException pexc) {
                if (AsnObject.debug <= 4) break block6;
                System.out.println(this.getClass().getName() + ".sendEngineIdReport(): " + "PduException: " + pexc.getMessage());
            }
        }
    }

    protected void sendTimeLineReport(Pdu orgPdu, int port) {
        block6: {
            if (AsnObject.debug > 4) {
                System.out.println(this.getClass().getName() + ".sendTimeLineReport()");
            }
            try {
                if (this.discTimeLineContextOut != null) {
                    this.discTimeLineContextOut.destroy();
                }
                this.discTimeLineContextOut = new SnmpContextv3(this.discTimeLineContextIn.getHost(), port, this.discTimeLineContextIn.getBindAddress(), this.discTimeLineContextIn.getTypeSocket());
                this.discTimeLineContextOut = (SnmpContextv3)this.discTimeLineContextIn.cloneParameters(this.discTimeLineContextOut);
                ReportPdu repPdu = new ReportPdu(this.discTimeLineContextOut, orgPdu);
                repPdu.addOid("1.3.6.1.6.3.15.1.1.2", (AsnObject)new AsnUnsInteger(this.usmAgent.getUsmStatsNotInTimeWindows()));
                repPdu.send();
            }
            catch (IOException iexc) {
                if (AsnObject.debug > 4) {
                    System.out.println(this.getClass().getName() + ".sendTimeLineReport(): " + "IOException: " + iexc.getMessage());
                }
            }
            catch (PduException pexc) {
                if (AsnObject.debug <= 4) break block6;
                System.out.println(this.getClass().getName() + ".sendEngineIdReport(): " + "PduException: " + pexc.getMessage());
            }
        }
    }

    public void freeResources() {
        this.discEngineIdContextIn.destroy();
        this.discEngineIdContextIn = null;
        this.discTimeLineContextIn.destroy();
        this.discTimeLineContextIn = null;
        if (this.discEngineIdContextOut != null) {
            this.discEngineIdContextOut.destroy();
            this.discEngineIdContextOut = null;
        }
        if (this.discTimeLineContextOut != null) {
            this.discTimeLineContextOut.destroy();
            this.discTimeLineContextOut = null;
        }
    }
}

