/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import java.net.UnknownHostException;
import junit.framework.TestCase;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.EmptyRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class EmptyRecordTest
extends TestCase {
    public void test_ctor() throws UnknownHostException {
        EmptyRecord ar = new EmptyRecord();
        EmptyRecordTest.assertNull((Object)ar.getName());
        EmptyRecordTest.assertEquals((int)0, (int)ar.getType());
        EmptyRecordTest.assertEquals((int)0, (int)ar.getDClass());
        EmptyRecordTest.assertEquals((long)0L, (long)ar.getTTL());
    }

    public void test_getObject() {
        EmptyRecord ar = new EmptyRecord();
        Record r = ar.getObject();
        EmptyRecordTest.assertTrue((boolean)(r instanceof EmptyRecord));
    }

    public void test_rrFromWire() throws IOException {
        DNSInput i = new DNSInput(new byte[]{1, 2, 3, 4, 5});
        i.jump(3);
        EmptyRecord er = new EmptyRecord();
        er.rrFromWire(i);
        EmptyRecordTest.assertEquals((int)3, (int)i.current());
        EmptyRecordTest.assertNull((Object)er.getName());
        EmptyRecordTest.assertEquals((int)0, (int)er.getType());
        EmptyRecordTest.assertEquals((int)0, (int)er.getDClass());
        EmptyRecordTest.assertEquals((long)0L, (long)er.getTTL());
    }

    public void test_rdataFromString() throws IOException {
        Tokenizer t = new Tokenizer("these are the tokens");
        EmptyRecord er = new EmptyRecord();
        er.rdataFromString(t, null);
        EmptyRecordTest.assertNull((Object)er.getName());
        EmptyRecordTest.assertEquals((int)0, (int)er.getType());
        EmptyRecordTest.assertEquals((int)0, (int)er.getDClass());
        EmptyRecordTest.assertEquals((long)0L, (long)er.getTTL());
        EmptyRecordTest.assertEquals((String)"these", (String)t.getString());
    }

    public void test_rrToString() {
        EmptyRecord er = new EmptyRecord();
        EmptyRecordTest.assertEquals((String)"", (String)er.rrToString());
    }

    public void test_rrToWire() {
        EmptyRecord er = new EmptyRecord();
        DNSOutput out = new DNSOutput();
        er.rrToWire(out, null, true);
        EmptyRecordTest.assertEquals((int)0, (int)out.toByteArray().length);
    }
}

