/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.ip.dynamic;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.Event;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.PoolEventPublisher;
import ru.bitel.bgbilling.modules.inet.api.server.InetUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.TreeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.concurrent.FutureResult;
import ru.bitel.common.inet.IpAddress;
import ru.bitel.common.inet.IpAddressRangeSet2;
import ru.bitel.common.inet.IpRange;
import ru.bitel.common.model.Id;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.util.Matcher;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpCategory;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResource;
import ru.bitel.oss.systems.inventory.resource.common.bean.IpResourceReserve;
import ru.bitel.oss.systems.inventory.resource.common.event.IpResourceModifiedEvent;
import ru.bitel.oss.systems.inventory.resource.common.event.IpResourceSubscribeEvent;
import ru.bitel.oss.systems.inventory.resource.common.event.IpResourceSubscriptionEvent;
import ru.bitel.oss.systems.inventory.resource.common.event.IpResourceUnsubscribeEvent;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpCategoryDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceDynSubscriptionDao;
import ru.bitel.oss.systems.inventory.resource.server.bean.IpResourceSubscriptionDao;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpCategoryRuntime;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceReserveManager;
import ru.bitel.oss.systems.inventory.resource.server.ip.dynamic.IpResourceRuntime;

public class IpResourceRuntimeManager
implements EventListener<Event> {
    private static final Logger logger = Logger.getLogger(IpResourceRuntimeManager.class);
    private final Setup setup;
    private final int mid;
    private final ConcurrentMap<Integer, Future<IpResourceRuntime>> resourceMap = new ConcurrentHashMap<Integer, Future<IpResourceRuntime>>();
    private final ConcurrentMap<Integer, IpCategoryRuntime> categoryMap = new ConcurrentHashMap<Integer, IpCategoryRuntime>();
    private final PoolEventPublisher<IpResourceSubscriptionEvent> subscriptionEP;
    private final ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private volatile IpAddressRangeSet2<IpResourceRange> rangeSet;
    private volatile Map<Integer, IpCategory> ipCategoryMap;
    private final Map<List<Integer>, IpResourceReserveManager> reserveManagerMap = new HashMap<List<Integer>, IpResourceReserveManager>();

    public IpResourceRuntimeManager(boolean realtime, Setup setup, int mid) throws BGException {
        this.setup = setup;
        this.mid = mid;
        EventProcessor ep = EventProcessor.getInstance();
        this.subscriptionEP = ep.newPoolEventPublisher(IpResourceSubscriptionEvent.class, mid, 500, 2000L);
        if (realtime) {
            ep.addListener(this, IpResourceSubscriptionEvent.class, mid, null);
            ep.addListener(this, IpResourceSubscribeEvent.class, mid, null);
            ep.addListener(this, IpResourceUnsubscribeEvent.class, mid, null);
            ep.addListener(this, IpResourceModifiedEvent.class, mid, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean contains(byte[] address, Matcher<IpResourceRange> matcher) {
        IpAddressRangeSet2<IpResourceRange> rangeSet = this.rangeSet;
        if (rangeSet != null) {
            return rangeSet.contains(address, matcher);
        }
        this.readLock.lock();
        try {
            boolean bl;
            Throwable throwable;
            IpResourceDao ipResourceDao;
            ConnectionSet connectionSet;
            block24: {
                block25: {
                    rangeSet = this.rangeSet;
                    if (rangeSet != null) {
                        boolean bl2 = rangeSet.contains(address, matcher);
                        return bl2;
                    }
                    connectionSet = ConnectionSet.newInstance(this.setup, true);
                    ipResourceDao = new IpResourceDao(connectionSet.getConnection(), this.mid);
                    throwable = null;
                    rangeSet = IpAddressRangeSet2.newInstance(IpResourceRange.class, 1);
                    List<IpResource> resourceList = ipResourceDao.list();
                    ArrayList<IpResourceRange> rangeList = new ArrayList<IpResourceRange>(resourceList.size());
                    GregorianCalendar utilCalendar = new GregorianCalendar();
                    for (IpResource resource : resourceList) {
                        rangeList.add(new IpResourceRange(resource, utilCalendar));
                    }
                    rangeSet.addAll(rangeList);
                    this.rangeSet = rangeSet;
                    bl = rangeSet.contains(address, matcher);
                    if (ipResourceDao == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        ipResourceDao.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block24;
                }
                ipResourceDao.close();
            }
            connectionSet.recycle();
            return bl;
            catch (Throwable throwable3) {
                try {
                    try {
                        try {
                            throwable = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            if (ipResourceDao != null) {
                                if (throwable != null) {
                                    try {
                                        ipResourceDao.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable.addSuppressed(throwable5);
                                    }
                                } else {
                                    ipResourceDao.close();
                                }
                            }
                            throw throwable4;
                        }
                    }
                    catch (Exception ex) {
                        logger.error((Object)ex.getMessage(), (Throwable)ex);
                        connectionSet.recycle();
                    }
                }
                catch (Throwable throwable6) {
                    connectionSet.recycle();
                    throw throwable6;
                }
            }
        }
        finally {
            this.readLock.unlock();
        }
        return true;
    }

    public IpResourceRuntime getResource(Integer id) throws BGException {
        return this.getResource(null, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IpResourceRuntime getResource(ConnectionSet connectionSetExternal, Integer id) throws BGException {
        FutureResult<IpResourceRuntime> result;
        this.readLock.lock();
        try {
            result = (FutureResult<IpResourceRuntime>)this.resourceMap.get(id);
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        finally {
            this.readLock.unlock();
        }
        if (result != null) {
            try {
                return (IpResourceRuntime)result.get(3L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                throw new BGException(e);
            }
        }
        FutureResult<IpResourceRuntime> newResult = new FutureResult<IpResourceRuntime>();
        this.writeLock.lock();
        try {
            result = this.resourceMap.putIfAbsent(id, newResult);
            if (result == null) {
                result = newResult;
            }
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        finally {
            this.writeLock.unlock();
        }
        if (result != newResult) {
            try {
                return (IpResourceRuntime)result.get(3L, TimeUnit.MINUTES);
            }
            catch (Exception e) {
                throw new BGException(e);
            }
        }
        this.readLock.lock();
        try {
            ConnectionSet connectionSet = connectionSetExternal != null ? connectionSetExternal : ConnectionSet.newInstance(this.setup, true);
            try {
                IpResourceRuntime newRuntime = null;
                Connection con = connectionSet.getConnection();
                try (IpResourceDao ipResourceDao = new IpResourceDao(con, this.mid);
                     IpResourceSubscriptionDao ipResourceSubscriptionDao = new IpResourceSubscriptionDao(con, this.mid);){
                    IpResource resource = (IpResource)ipResourceDao.get(id);
                    if (resource != null) {
                        newRuntime = new IpResourceRuntime(resource, new IpResourceDynSubscriptionDao(con, this.mid).listRuntime(id), ipResourceSubscriptionDao.listRuntime(id, new Date(), null));
                    } else {
                        logger.error((Object)("IpResource not found with id=" + id));
                    }
                }
                finally {
                    newResult.set(newRuntime);
                }
            }
            finally {
                if (connectionSet != connectionSetExternal) {
                    connectionSet.recycle();
                }
            }
            IpResourceRuntime ipResourceRuntime = (IpResourceRuntime)result.get();
            return ipResourceRuntime;
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IpCategoryRuntime getCategory(Integer id) throws BGException {
        IpCategoryRuntime result = (IpCategoryRuntime)this.categoryMap.get(id);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("IpCategoryRuntime (from categoryMap): " + result + "; id => " + id));
        }
        if (result == null) {
            ConnectionSet connectionSet = ConnectionSet.newInstance(this.setup, true);
            try {
                IpCategoryRuntime newResult = this.loadCategory(connectionSet, id);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("IpCategoryRuntime (from database): " + result + "; id => " + id));
                }
                if (newResult == null) {
                    IpCategoryRuntime ipCategoryRuntime = null;
                    return ipCategoryRuntime;
                }
                result = this.categoryMap.putIfAbsent(id, newResult);
                if (result == null) {
                    result = newResult;
                }
                connectionSet.commit();
            }
            finally {
                connectionSet.recycle();
            }
        }
        return result;
    }

    private IpCategoryRuntime getCategory(ConnectionSet connectionSet, Integer id) throws BGException {
        IpCategoryRuntime result = (IpCategoryRuntime)this.categoryMap.get(id);
        if (result == null) {
            IpCategoryRuntime newResult = this.loadCategory(connectionSet, id);
            if (newResult == null) {
                return null;
            }
            result = this.categoryMap.putIfAbsent(id, newResult);
            if (result == null) {
                result = newResult;
            }
            connectionSet.commit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Integer, IpCategory> getIpCategoryRoot() throws BGException {
        Map<Integer, IpCategory> result = this.ipCategoryMap;
        if (result != null) {
            return result;
        }
        ConnectionSet connectionSet = ConnectionSet.newInstance(this.setup, true);
        try (IpCategoryDao ipCategoryDao = new IpCategoryDao(connectionSet.getConnection(), this.mid);){
            List<IpCategory> ipCategoryList = ipCategoryDao.list();
            IpCategory root = new IpCategory();
            root.setId(0);
            root.setTitle("\u041a\u0430\u0442\u0435\u0433\u043e\u0440\u0438\u0438 IP \u0440\u0435\u0441\u0443\u0440\u0441\u043e\u0432");
            TreeUtils.tree(ipCategoryList, root);
            result = Id.newMap(ipCategoryList);
        }
        finally {
            connectionSet.recycle();
        }
        this.ipCategoryMap = result;
        return result;
    }

    private IpCategoryRuntime loadCategory(ConnectionSet connectionSet, int id) throws BGException {
        IpCategory category = this.getIpCategoryRoot().get(id);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loadCategory(...): category = " + category));
        }
        if (category == null) {
            return null;
        }
        ArrayList<IpCategoryRuntime> children = new ArrayList<IpCategoryRuntime>();
        if (category.getChildren() != null) {
            for (IpCategory child : category.getChildren()) {
                IpCategoryRuntime childCategory = this.getCategory(connectionSet, child.getId());
                if (childCategory == null) continue;
                children.add(childCategory);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loadCategory(...): children = " + children + "; size = " + children.size()));
        }
        List<IpResource> resourceList = null;
        IpResourceDao ipResourceDao = new IpResourceDao(connectionSet.getConnection(), this.mid);
        Object object = null;
        try {
            resourceList = ipResourceDao.list(id);
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (ipResourceDao != null) {
                if (object != null) {
                    try {
                        ipResourceDao.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    ipResourceDao.close();
                }
            }
        }
        ArrayList<IpResourceRuntime> resources = new ArrayList<IpResourceRuntime>();
        for (IpResource res : resourceList) {
            IpResourceRuntime resource = this.getResource(connectionSet, res.getId());
            if (resource == null) continue;
            resources.add(resource);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("loadCategory(...): resources = " + resources + "; size = " + resources.size()));
        }
        return new IpCategoryRuntime(id, children.toArray(new IpCategoryRuntime[children.size()]), resources.toArray(new IpResourceRuntime[resources.size()]));
    }

    public int reserve(List<IpResourceReserve> list, Set<Integer> categories, long millis, long timeout, int max) throws BGException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("reserve from categories=" + categories + "; timeout=" + timeout + "; max=" + max));
        }
        for (Integer id : categories) {
            IpCategoryRuntime category = this.getCategory(id);
            if (category == null || (max = category.reserve(list, millis, timeout, max)) > 0) continue;
            return max;
        }
        return max;
    }

    public IpResourceReserve reserve(Set<Integer> categories, long timeout) throws BGException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("reserve from categories=" + categories + " with timeout=" + timeout));
        }
        for (Integer id : categories) {
            IpCategoryRuntime category = this.getCategory(id);
            if (category == null) continue;
            IpResourceReserve result = category.reserve(timeout);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("category=" + category + "; ipResourceReserve=" + result));
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public int getIpResourceId(Set<Integer> categoryIds, byte[] address, long millis) throws BGException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getIpResourceId from categoryIds=" + categoryIds + "; address=" + address + "; millis=" + millis));
        }
        for (Integer id : categoryIds) {
            int result;
            IpCategoryRuntime category = this.getCategory(id);
            if (category == null || (result = category.getIpResourceId(address, millis)) <= 0) continue;
            return result;
        }
        return -1;
    }

    public void subscribe(Connection con, int contractId, String contractTitle, int ipResourceId, byte[] address, Date timeFrom, long connectionId) throws BGException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Subscribing " + IpAddress.toString(address) + " to contractId=" + contractId));
        }
        long subscriptionId = new IpResourceDynSubscriptionDao(con, this.mid).occupie(ipResourceId, connectionId, address, timeFrom, -1, contractId, contractTitle);
        this.subscriptionEP.publishAfterCommit(new IpResourceSubscriptionEvent(1, this.mid, -1, contractId, contractTitle, ipResourceId, subscriptionId, address, null, timeFrom, null, true));
    }

    public void unsubscribe(Connection con, int contractId, int ipResourceId, byte[] address, Date timeTo, long connectionId) throws BGException {
        long subscriptionId = new IpResourceDynSubscriptionDao(con, this.mid).free(ipResourceId, connectionId, address, timeTo, -1, contractId);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Unsubscribing subscriptionId=" + subscriptionId + "; address=" + IpAddress.toString(address) + " from contractId=" + contractId));
        }
        this.subscriptionEP.publishAfterCommit(new IpResourceSubscriptionEvent(2, this.mid, -1, contractId, null, ipResourceId, subscriptionId, address, null, null, timeTo, true));
    }

    @Override
    public void notify(Event e, EventListenerContext ctx) throws BGException {
        if (e instanceof IpResourceSubscribeEvent) {
            IpResourceSubscribeEvent ev = (IpResourceSubscribeEvent)e;
            byte[] address = ev.getAddress();
            int ipResourceId = this.getIpResourceId(ev.getCategorieIds(), address, ev.getTimeFrom().getTime());
            if (ipResourceId > 0) {
                long subscriptionId = new IpResourceDynSubscriptionDao(ctx.getConnection(), this.mid).occupie(ipResourceId, ev.getConnectionId(), address, ev.getTimeFrom(), ev.getSubscriberType(), ev.getContractId(), ev.getSubscriberTitle());
                this.subscriptionEP.publish(new IpResourceSubscriptionEvent(1, this.mid, ev.getSubscriberType(), ev.getContractId(), ev.getSubscriberTitle(), ipResourceId, subscriptionId, address, null, ev.getTimeFrom(), null, true));
            } else {
                logger.error((Object)("IpResource not found with categories=" + ev.getCategorieIds() + " and ip=" + new IpAddress(address)));
            }
        } else if (e instanceof IpResourceUnsubscribeEvent) {
            IpResourceUnsubscribeEvent ev = (IpResourceUnsubscribeEvent)e;
            byte[] address = ev.getAddress();
            long subscriptionId = new IpResourceDynSubscriptionDao(ctx.getConnection(), this.mid).free(ev.getIpResourceId(), ev.getConnectionId(), address, ev.getTimeTo(), ev.getSubscriberType(), ev.getContractId());
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("notify Unsubscribing subscriptionId=" + subscriptionId + "; address=" + IpAddress.toString(address) + " from contractId=" + ev.getContractId()));
            }
            this.subscriptionEP.publish(new IpResourceSubscriptionEvent(2, this.mid, ev.getSubscriberType(), ev.getContractId(), null, ev.getIpResourceId(), subscriptionId, address, null, null, ev.getTimeTo(), true));
        } else if (e instanceof IpResourceSubscriptionEvent) {
            IpResourceSubscriptionEvent ev = (IpResourceSubscriptionEvent)e;
            switch (ev.getType()) {
                case 1: {
                    this.readLock.lock();
                    try {
                        IpResourceRuntime resource;
                        ConcurrentMap<Integer, Future<IpResourceRuntime>> resourceMap = this.resourceMap;
                        Future future = (Future)resourceMap.get(ev.getIpResourceId());
                        if (future != null && (resource = (IpResourceRuntime)future.get()) != null) {
                            resource.occipie(ev.getSubscriptionId(), ev.getAddressFrom(), ev.getAddressTo(), ev.isDynamic());
                        }
                        break;
                    }
                    catch (Exception ex) {
                        throw new BGException(ex);
                    }
                    finally {
                        this.readLock.unlock();
                    }
                }
                case 2: {
                    this.readLock.lock();
                    try {
                        IpResourceRuntime resource;
                        ConcurrentMap<Integer, Future<IpResourceRuntime>> resourceMap = this.resourceMap;
                        Future future = (Future)resourceMap.get(ev.getIpResourceId());
                        if (future != null && (resource = (IpResourceRuntime)future.get()) != null) {
                            resource.free(ev.getSubscriptionId(), ev.getAddressFrom(), ev.getAddressTo(), ev.isDynamic());
                        }
                        break;
                    }
                    catch (Exception ex) {
                        throw new BGException(ex);
                    }
                    finally {
                        this.readLock.unlock();
                    }
                }
            }
        } else if (e instanceof IpResourceModifiedEvent) {
            this.reload(((IpResourceModifiedEvent)e).getIpResourceCategoryId(), ((IpResourceModifiedEvent)e).getIpResourceId());
        }
    }

    private void reload(int categoryId, int ipResourceId) {
        this.writeLock.lock();
        try {
            this.categoryMap.remove(categoryId);
            this.resourceMap.remove(ipResourceId);
            this.rangeSet = null;
            this.ipCategoryMap = null;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public void reloadResource(int ipResourceId) {
        Future future = (Future)this.resourceMap.get(ipResourceId);
        if (future != null && future.isDone()) {
            try {
                IpResourceRuntime resource = (IpResourceRuntime)future.get();
                if (resource != null) {
                    this.reload(resource.categoryId, ipResourceId);
                }
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    public void reload(final LinkedHashSet<Integer> ipResourceCategoryIds) {
        new Thread("ip-resource-reload"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Set set = IpResourceRuntimeManager.this.resourceMap.values().stream().filter(a2 -> a2.isDone()).map(a2 -> {
                    try {
                        return (IpResourceRuntime)a2.get();
                    }
                    catch (InterruptedException | ExecutionException e) {
                        logger.error((Object)e.getMessage(), (Throwable)e);
                        return null;
                    }
                }).filter(a2 -> ipResourceCategoryIds.contains(a2.categoryId)).collect(Collectors.toSet());
                IpResourceRuntimeManager.this.writeLock.lock();
                try {
                    for (IpResourceRuntime r : set) {
                        IpResourceRuntimeManager.this.reload(r.categoryId, r.id);
                    }
                }
                finally {
                    IpResourceRuntimeManager.this.writeLock.unlock();
                }
            }
        }.start();
    }

    protected IpResourceReserveManager newReserveManager(LinkedHashSet<Integer> categories) {
        return new IpResourceReserveManager(this.setup, this.mid, categories, this);
    }

    public IpResourceReserveManager getReserveManager(LinkedHashSet<Integer> categories, String name) {
        return this.getReserveManager(categories, name, new IpResourceReserveManager.IpResourceReserveManagerConfig());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IpResourceReserveManager getReserveManager(LinkedHashSet<Integer> categories, String name, IpResourceReserveManager.IpResourceReserveManagerConfig config) {
        this.readLock.lock();
        try {
            ArrayList<Integer> list = new ArrayList<Integer>(categories);
            IpResourceReserveManager result = this.reserveManagerMap.get(list);
            if (result == null) {
                result = this.newReserveManager(categories);
                this.reserveManagerMap.put(list, result);
            }
            result.names.add(name);
            result.setConfig(config);
            IpResourceReserveManager ipResourceReserveManager = result;
            return ipResourceReserveManager;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public long getSize(Set<Integer> categories) throws BGException {
        long result = 0L;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getSize(...): categories => " + categories));
        }
        for (Integer id : categories) {
            IpCategoryRuntime category = this.getCategory(id);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getSize(...): category => " + category + "; id => " + id));
            }
            if (category == null) continue;
            long size = category.getSize();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getSize(...): category.getSize() => " + size));
            }
            if (size != Long.MIN_VALUE) {
                result += size;
                continue;
            }
            return Long.MIN_VALUE;
        }
        return result;
    }

    public long getOccupiedCount(Set<Integer> categories) throws BGException {
        long result = 0L;
        for (Integer id : categories) {
            IpCategoryRuntime category = this.getCategory(id);
            if (category == null) continue;
            result += category.getOccupiedCount();
        }
        return result;
    }

    public long getReservedCount(Set<Integer> categories) throws BGException {
        long result = 0L;
        for (Integer id : categories) {
            IpCategoryRuntime category = this.getCategory(id);
            if (category == null) continue;
            result += category.getReservedCount();
        }
        return result;
    }

    public long getOccupiedAndReservedCount(Set<Integer> categories) throws BGException {
        long result = 0L;
        for (Integer id : categories) {
            IpCategoryRuntime category = this.getCategory(id);
            if (category == null) continue;
            result += category.getOccupiedCount() + category.getReservedCount();
        }
        return result;
    }

    public void initPools(ParameterMap config) {
        ArrayList<IpResourceReserveManager> list;
        this.writeLock.lock();
        try {
            list = new ArrayList<IpResourceReserveManager>(this.reserveManagerMap.values());
        }
        finally {
            this.writeLock.unlock();
        }
        for (IpResourceReserveManager reserveManager : list) {
            reserveManager.pauseBatchReserve();
        }
    }

    public String status() {
        ArrayList<IpResourceReserveManager> list;
        StringBuilder sb = new StringBuilder();
        this.writeLock.lock();
        try {
            list = new ArrayList<IpResourceReserveManager>(this.reserveManagerMap.values());
        }
        finally {
            this.writeLock.unlock();
        }
        try {
            if (list.size() < 50) {
                for (IpResourceReserveManager reserveManager : list) {
                    sb.append("IP pool [" + Utils.toString(reserveManager.names) + "] ipCategoryIds: " + reserveManager.getIpResourceCategoryIds() + ", size: " + reserveManager.getSize() + ", occupied: " + reserveManager.getOccupiedCount() + ", reserved: " + reserveManager.getReservedCount() + ", localReserved: " + reserveManager.getLocalReservedCount() + ", fetchSize: " + reserveManager.getFetchSize());
                    sb.append('\n');
                }
                if (sb.length() > 0) {
                    sb.setLength(sb.length() - 1);
                }
            }
        }
        catch (Exception ex) {
            logger.error((Object)ex.getMessage(), (Throwable)ex);
        }
        return sb.toString();
    }

    ConcurrentMap<Integer, IpCategoryRuntime> getLoadedCategoryMap() {
        return this.categoryMap;
    }

    public static final class IpResourceRange
    extends IpRange {
        public final long dateFrom;
        public final long dateTo;

        public IpResourceRange(IpResource resource, Calendar utilCalendar) {
            super(resource.getAddressFrom(), resource.getAddressTo());
            this.dateFrom = InetUtils.dateFrom((Date)resource.getDateFrom(), (Calendar)utilCalendar);
            this.dateTo = InetUtils.dateTo((Date)resource.getDateTo(), (Calendar)utilCalendar);
        }
    }
}

