/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.systems.inventory.resource.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.Result;
import ru.bitel.oss.systems.inventory.resource.common.bean.DevicePortSubscription;

public class DevicePortSubscriptionDao
extends AbstractDao<DevicePortSubscription> {
    private static final Object mutex = new Object();

    public DevicePortSubscriptionDao(Connection con, int mid) {
        super(con, 0, "inv_device_port_subscription_" + mid);
    }

    @Override
    protected DevicePortSubscription getFromRS(ResultSet rs) throws SQLException, BGException {
        DevicePortSubscription result = new DevicePortSubscription();
        result.setId(rs.getInt("id"));
        result.setDeviceId(rs.getInt("deviceId"));
        result.setPortId(rs.getInt("port"));
        result.setDateFrom(rs.getDate("dateFrom"));
        result.setDateTo(rs.getDate("dateTo"));
        result.setSubscriberId(rs.getInt("subscriberId"));
        result.setSubscriberTitle(rs.getString("subscriberTitle"));
        return result;
    }

    @Override
    protected void updateImpl(DevicePortSubscription b2) throws BGException, SQLException {
        PreparedStatement ps;
        if (b2.getId() <= 0) {
            ps = this.con.prepareStatement("INSERT INTO " + this.tableName + " (deviceId, port, dateFrom, dateTo,  subscriberId, subscriberTitle) VALUES (?,?,?,?,?,? )", 1);
        } else {
            ps = this.con.prepareStatement("UPDATE " + this.tableName + " SET deviceId=?, port=?, dateFrom=?, dateTo=?, subscriberId=?, subscriberTitle=? WHERE id=?");
            ps.setInt(7, b2.getId());
        }
        ps.setInt(1, b2.getDeviceId());
        ps.setInt(2, b2.getPortId());
        ps.setDate(3, TimeUtils.convertDateToSqlDate(b2.getDateFrom()));
        ps.setDate(4, TimeUtils.convertDateToSqlDate(b2.getDateTo()));
        ps.setInt(5, b2.getSubscriberId());
        ps.setString(6, b2.getSubscriberTitle());
        ps.executeUpdate();
        if (b2.getId() <= 0) {
            b2.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    public List<DevicePortSubscription> list(int deviceId, int port, Date dateFrom, Date dateTo) throws BGException {
        return this.list("deviceId=? AND (?=-1 OR port=?) AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?)", "port", deviceId, port, port, dateTo, dateTo, dateFrom, dateFrom);
    }

    public Result<DevicePortSubscription> list(int deviceId, int port, Date dateFrom, Date dateTo, Page page) throws BGException {
        return this.list(page, "deviceId=? AND (?=-1 OR port=?) AND (dateFrom IS NULL OR ? IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR ? IS NULL OR dateTo>=?)", "port", deviceId, port, port, dateTo, dateTo, dateFrom, dateFrom);
    }

    public int deleteBySubscriberId(int subscriberId) throws BGException {
        return this.delete("subscriberId=?", subscriberId);
    }

    public DevicePortSubscription get(int deviceId, int port, Date now) throws BGException {
        return (DevicePortSubscription)this.get("deviceId=? AND port=? AND (dateFrom IS NULL OR dateFrom<=?) AND (dateTo IS NULL OR dateTo>=?)", deviceId, port, now, now);
    }
}

