/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.oss.kernel.entity.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttr;
import ru.bitel.oss.kernel.entity.common.bean.EntityAttrInt;
import ru.bitel.oss.kernel.entity.server.bean.AbstractEntityAttrDao;
import ru.bitel.oss.kernel.entity.server.bean.EntityAttrDefaultDao;

class EntityAttrIntDao
extends EntityAttrDefaultDao<EntityAttrInt> {
    public EntityAttrIntDao(Connection con, AbstractEntityAttrDao<?> entityAttrDao, String intTable) {
        super(con, entityAttrDao, intTable);
    }

    @Override
    public EntityAttrInt get(int entityId, int attrSpecId) throws SQLException {
        PreparedStatement ps = this.getSelectPS(entityId, attrSpecId);
        ResultSet rs = ps.executeQuery();
        EntityAttrInt result = rs.next() ? new EntityAttrInt(entityId, attrSpecId, rs.getInt(1)) : null;
        rs.close();
        return result;
    }

    @Override
    public void insert(int entityId, EntityAttr a2) throws SQLException {
        PreparedStatement ps = this.getInsertPS(entityId, a2.getEntitySpecAttrId());
        ps.setInt(3, ((EntityAttrInt)a2).getValue());
        ps.executeUpdate();
    }

    @Override
    public boolean updateImpl(int entityId, EntityAttrInt attr) throws SQLException {
        PreparedStatement ps = this.getUpdatePS(entityId, attr.getEntitySpecAttrId());
        ps.setInt(1, attr.getValue());
        if (ps.executeUpdate() == 0) {
            ps = this.getInsertPS(entityId, attr.getEntitySpecAttrId());
            ps.setInt(3, attr.getValue());
            ps.executeUpdate();
            return true;
        }
        ps = this.entityAttrDao.getSelectOldValuePS();
        ResultSet rs = ps.executeQuery();
        int oldValue = rs.next() ? rs.getInt(1) : 0;
        rs.close();
        return attr.getValue() != oldValue;
    }

    @Override
    protected void insertHistory(int cid, EntityAttrInt attr) throws SQLException {
        PreparedStatement ps = this.getInsertHistiryPS();
        ps.setInt(1, cid);
        ps.setInt(2, attr.getEntitySpecAttrId());
        ps.setInt(3, attr != null ? Integer.valueOf(attr.getValue()) : null);
        ps.setTimestamp(4, new Timestamp(System.currentTimeMillis()));
        ps.setInt(5, this.entityAttrDao.userId);
        ps.executeUpdate();
    }
}

