/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.util;

import java.util.AbstractQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public class DeduplicateDelayQueue<E extends Delayed>
extends AbstractQueue<E>
implements Queue<E> {
    private final DelayQueue<E> queue = new DelayQueue();
    private final ConcurrentHashMap<E, E> map = new ConcurrentHashMap();

    public void put(E e) {
        if (this.map.merge(e, e, (a2, b2) -> a2.compareTo(b2) >= 0 ? a2 : b2) == e) {
            this.queue.put(e);
        }
    }

    @Override
    public boolean offer(E e) {
        this.put(e);
        return true;
    }

    public boolean offer(E e, long timeout, TimeUnit unit) {
        this.put(e);
        return true;
    }

    @Override
    public E poll() {
        Object result;
        while ((result = this.queue.poll()) != null) {
            if (this.map.computeIfPresent(result, (k, v) -> k == v ? null : v) != null) continue;
            return (E)result;
        }
        return null;
    }

    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object result;
        long nanosTimeout = unit.toNanos(timeout);
        long deadline = System.nanoTime() + nanosTimeout;
        while ((result = this.queue.poll(nanosTimeout, TimeUnit.NANOSECONDS)) != null) {
            if (this.map.computeIfPresent(result, (k, v) -> k == v ? null : v) == null) {
                return (E)result;
            }
            nanosTimeout = deadline - System.nanoTime();
        }
        return null;
    }

    public E take() throws InterruptedException {
        Object result;
        while ((result = this.queue.take()) != null) {
            if (this.map.computeIfPresent(result, (k, v) -> k == v ? null : v) != null) continue;
            return (E)result;
        }
        return null;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    public int drainTo(Collection<? super E> c) {
        List<Object> list = new ArrayList();
        this.queue.drainTo(list);
        list = list.stream().filter(a2 -> this.map.computeIfPresent(a2, (k, v) -> k == v ? null : v) == null).collect(Collectors.toList());
        c.addAll(list);
        return list.size();
    }

    public int drainTo(Collection<? super E> c, int maxElements) {
        int n;
        ArrayList list = new ArrayList(maxElements);
        int count = maxElements;
        while ((n = this.queue.drainTo(list, count)) != 0) {
            List filtered = list.stream().filter(a2 -> this.map.computeIfPresent(a2, (k, v) -> k == v ? null : v) == null).collect(Collectors.toList());
            c.addAll(filtered);
            list.clear();
            if ((count -= filtered.size()) > 0) continue;
        }
        return maxElements - count;
    }

    @Override
    public E peek() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        throw new UnsupportedOperationException();
    }

    public static void main(String[] args) throws InterruptedException {
        DeduplicateDelayQueue<Task> queue = new DeduplicateDelayQueue<Task>();
        long millis = System.currentTimeMillis();
        queue.offer(new Task(4, millis + 1000L));
        queue.offer(new Task(1, millis + 5000L));
        queue.offer(new Task(1, millis + 10000L));
        queue.offer(new Task(3, millis + 6000L));
        queue.offer(new Task(1, millis + 15000L));
        queue.offer(new Task(3, millis + 7000L));
        queue.offer(new Task(2, millis + 8000L));
        queue.offer(new Task(2, millis + 1000L));
        queue.offer(new Task(2, millis + 2000L));
        queue.offer(new Task(2, millis + 8000L));
        queue.offer(new Task(2, millis + 7000L));
        queue.offer(new Task(4, millis + 2000L));
        queue.offer(new Task(4, millis + 7000L));
        queue.offer(new Task(5, millis + 7010L));
        queue.offer(new Task(6, millis + 7020L));
        queue.offer(new Task(7, millis + 7030L));
        queue.offer(new Task(8, millis + 7040L));
        queue.offer(new Task(9, millis + 8000L));
        queue.offer(new Task(4, millis + 3000L));
        System.out.println("poll");
        Task t = (Task)queue.poll(2L, TimeUnit.SECONDS);
        if (t != null) {
            System.out.println(t.contractId + " " + (System.currentTimeMillis() - millis));
        }
        Thread.sleep(4000L);
        System.out.println("poll");
        t = (Task)queue.poll(2L, TimeUnit.SECONDS);
        if (t != null) {
            System.out.println(t.contractId + " " + (System.currentTimeMillis() - millis));
        }
        Thread.sleep(4000L);
        queue.offer(new Task(2, millis + 20000L));
        ArrayList list = new ArrayList();
        queue.drainTo(list, 3);
        System.out.println(list + " " + (System.currentTimeMillis() - millis));
        while (true) {
            System.out.println("poll");
            t = (Task)queue.poll(2L, TimeUnit.SECONDS);
            if (t == null) continue;
            System.out.println(t.contractId + " " + (System.currentTimeMillis() - millis));
        }
    }

    private static final class Task
    implements Delayed {
        final int contractId;
        final long time;

        public Task(int contractId, long time) {
            this.contractId = contractId;
            this.time = time;
        }

        @Override
        public int compareTo(Delayed o) {
            Task t = (Task)o;
            return Long.compare(this.time, t.time);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return unit.convert(this.time - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.contractId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Task other = (Task)obj;
            return this.contractId == other.contractId;
        }

        public String toString() {
            return "Task [contractId=" + this.contractId + "]";
        }
    }
}

