/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.server.jdbc;

import java.io.PrintWriter;
import java.sql.Connection;
import javax.sql.ConnectionPoolDataSource;
import org.apache.commons.dbcp.cpdsadapter.DriverAdapterCPDS;
import org.apache.log4j.Category;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.logging.LoggingPrintWriter;

public class DataSourceFactory {
    private static final int MAX_IDLE_DEFAULT = 20;
    private static final int MAX_ACTIVE_DEFAULT = 300;

    public static ConnectionPoolDataSource newConnectionPoolDataSource(String url, String user, String pswd, ParameterMap params) throws BGException {
        try {
            DriverAdapterCPDS adapter = new DriverAdapterCPDS();
            adapter.setUrl(url);
            adapter.setUser(user);
            adapter.setPassword(pswd);
            adapter.setDriver(params.get("driver", null));
            adapter.setMaxActive(params.getInt("maxActive", 300));
            adapter.setMaxIdle(params.getInt("maxIdle", 20));
            Logger cat = Logger.getLogger(Connection.class);
            if (cat.isDebugEnabled()) {
                adapter.setLogWriter((PrintWriter)new LoggingPrintWriter(System.out, (Category)cat, (Priority)Level.DEBUG));
            }
            return adapter;
        }
        catch (ClassNotFoundException e) {
            throw new BGException("Driver not found: " + params.get("driver", null), e);
        }
    }
}

