/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.utils.apps.update;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.net.ftp.FTPClient;

public class ServerUpdate {
    private final String clientDir = "client.jars" + File.separator + "update" + File.separator;
    private final String kernelDir = "lib" + File.separator + "app" + File.separator;

    public static void main(String[] args) {
        System.out.println("Start ServerUpdate");
        ServerUpdate serverUpdate = new ServerUpdate();
        if (serverUpdate.checkJars()) {
            serverUpdate.downloadJars();
        }
    }

    private boolean checkJars() {
        File clientJarFile = new File(this.clientDir + "client.jar");
        File kernelJarFile = new File(this.kernelDir + "kernel.jar");
        return !clientJarFile.exists() || !kernelJarFile.exists();
    }

    private void downloadJars() {
        Properties properties = new Properties();
        try {
            properties.load(new FileInputStream("data" + File.separator + "data.properties"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        FTPClient ftp = new FTPClient();
        String updateUrl = properties.getProperty("server.update.url", "ftp://ftp.bgbilling.ru/pub/bgbilling");
        System.out.println("Update URL: " + updateUrl);
        String version = properties.getProperty("server.version");
        if (version == null) {
            System.err.println("\u0423\u043a\u0430\u0436\u0438\u0442\u0435 \u0432 \u0444\u0430\u0439\u043b\u0435 data/data.properties \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 server.version=8.0");
            System.exit(1);
        }
        System.out.println("Version: " + version);
        URI uri = URI.create(updateUrl.concat("/").concat(version));
        if (uri.getPort() > 0) {
            ftp.setDefaultPort(uri.getPort());
        }
        try {
            ftp.connect(uri.getHost());
            if (properties.getProperty("server.update.ftp.mode", "passive").equals("passive")) {
                ftp.enterLocalPassiveMode();
                System.out.println("Set passive mode...");
            } else {
                ftp.enterLocalActiveMode();
                System.out.println("Set active mode...");
            }
            ftp.login("anonymous", "");
            ftp.setFileType(2);
            System.out.println("Changing dir to " + uri.getPath());
            if (!ftp.changeWorkingDirectory(uri.getPath())) {
                throw new Exception("not change to " + uri.getPath());
            }
            for (String file : ftp.listNames()) {
                if (!file.matches("^update_[\\d\\.]+.zip$")) continue;
                String tmpFileName = "tmp" + File.separator + file;
                System.out.print("Downloading " + file);
                try (FileOutputStream fileOutputStream = new FileOutputStream(tmpFileName);){
                    ftp.retrieveFile(file, (OutputStream)fileOutputStream);
                }
                System.out.println(" OK");
                File tmpFile = new File(tmpFileName);
                ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(tmpFile));
                ZipEntry zipEntry = null;
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    if (zipEntry.getName().equals("client.zip")) {
                        this.putFile(zipInputStream, this.clientDir);
                        continue;
                    }
                    if (!zipEntry.getName().equals("server.zip")) continue;
                    this.putFile(zipInputStream, this.kernelDir);
                }
                zipInputStream.close();
                tmpFile.deleteOnExit();
            }
        }
        catch (Exception e) {
            System.err.println("ERROR connect");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void putFile(InputStream inputStream, String dirName) throws Exception {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        ZipEntry zipEntry = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            System.out.println("Put " + zipEntry.getName() + "  in " + dirName);
            File file = new File(dirName + zipEntry.getName());
            file.getParentFile().mkdirs();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(this.readByBlock(zipInputStream));
            fileOutputStream.flush();
            fileOutputStream.close();
        }
    }

    private byte[] readByBlock(InputStream input) throws IOException {
        BufferedInputStream bf = new BufferedInputStream(input);
        Vector<byte[]> blocks = new Vector<byte[]>(5, 5);
        Vector<Integer> blocksLength = new Vector<Integer>(5, 5);
        int BLOCK_LENGTH = 1024;
        int readByte = 0;
        int bytesTotal = 0;
        do {
            byte[] data;
            if ((readByte = bf.read(data = new byte[1024], 0, 1024)) <= 0) continue;
            bytesTotal += readByte;
            blocks.addElement(data);
            blocksLength.addElement(readByte);
        } while (readByte != -1);
        int joffset = 0;
        byte[] allData = new byte[bytesTotal];
        for (int i = 0; i < blocks.size(); ++i) {
            readByte = (Integer)blocksLength.elementAt(i);
            System.arraycopy(blocks.elementAt(i), 0, allData, joffset, readByte);
            joffset += readByte;
        }
        return allData;
    }
}

