/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.wifi;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.wifi.KeyComparator;
import ru.bitel.bgbilling.kernel.wifi.SetupData;
import ru.bitel.bgbilling.kernel.wifi.WiFiAgent;
import ru.bitel.common.ParameterMap;

public class GlobalConfig {
    private static Logger log = Logger.getLogger(GlobalConfig.class);
    private SetupData setup = null;
    private List<Map<String, String>> authAttrs = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> realms = new ArrayList<Map<String, String>>();
    private List<Map<String, String>> activateParams = new ArrayList<Map<String, String>>();
    private String serverLogin = null;
    private String serverPasswd = null;
    private String serverHttpUrl = null;
    private String serverHttpsUrl = null;
    private String statHttpUrl = null;
    private String statHttpsUrl = null;
    private String passwordUrl = null;
    private String portalHttpUrl = null;
    private String portalHttpsUrl = null;
    private String cardLink = null;
    boolean useRealm = false;
    private boolean showStatistics = false;
    private boolean remindPassword = true;
    private boolean activate = false;
    private boolean activateWithForward = false;
    private boolean useHttps = false;
    private int httpPort = 0;
    private int httpsPort = 0;
    private int mid = 0;
    private static GlobalConfig cfg = null;
    private String loginScript = null;
    private String logoutScript = null;
    private String initScript = null;
    private String ipCountScript = null;
    private int agentPort = 0;
    private boolean dhcp = false;
    private int adminPort = 0;
    private String accountHost = null;
    private String authHost = null;
    private int accountPort = 0;
    private int authPort = 0;
    private byte[] secret = null;
    private String nasId = null;
    private static String arpCommand = null;
    private boolean useIpTables = true;
    boolean clearChain = false;
    private boolean sendRadiusUpdates = false;
    private int radiusUpdateTimeout = 60;
    private boolean allowLinking = false;
    private boolean useSSI = false;
    private boolean useHttpsClientAuth = true;

    public static GlobalConfig getGlobalConfig() {
        return cfg;
    }

    public static void initGlobalConfig(String propertyName) {
        cfg = new GlobalConfig(propertyName);
    }

    private GlobalConfig(String propertyName) {
        this.setup = new SetupData(propertyName);
        this.initRealms();
        this.initSAuthAttributeList();
        this.initActivateParameters();
        this.mid = this.setup.getInt("billing.server.moduleId", 0);
        this.serverLogin = this.setup.get("billing.server.login", null);
        this.serverPasswd = this.setup.get("billing.server.passwd", null);
        this.serverHttpUrl = this.setup.get("billing.server.http.url", null);
        this.serverHttpsUrl = this.setup.get("billing.server.https.url", null);
        this.portalHttpUrl = this.setup.get("portal.http.url", null);
        this.portalHttpsUrl = this.setup.get("portal.https.url", null);
        this.remindPassword = this.setup.getInt("billing.server.password.remind", 0) > 0;
        this.httpPort = this.setup.getInt("portal.http.port", 9090);
        this.httpsPort = this.setup.getInt("portal.https.port", 0);
        this.cardLink = this.setup.get("portal.card.link", "");
        this.useRealm = this.setup.getInt("portal.use.realm", 0) == 1;
        this.useHttps = this.setup.getInt("wifi.agent.server.https", 0) > 0;
        this.showStatistics = this.setup.getInt("billing.server.show.statistics", 0) > 0;
        this.statHttpUrl = this.serverHttpUrl + "/webexecuter";
        this.statHttpsUrl = this.serverHttpsUrl + "/webexecuter";
        this.agentPort = this.setup.getInt("wifi.agent.port", 5555);
        this.dhcp = this.setup.getInt("dhcp", 0) > 0;
        this.adminPort = this.setup.getInt("wifi.agent.port.admin", 5556);
        this.authHost = this.setup.get("radius.auth.host", null);
        this.accountHost = this.setup.get("radius.account.host", null);
        this.authPort = this.setup.getInt("radius.auth.port", 1815);
        this.accountPort = this.setup.getInt("radius.account.port", 1816);
        this.secret = this.setup.get("radius.secret", "").getBytes();
        this.nasId = this.setup.get("radius.nasId", null);
        arpCommand = this.setup.get("wifi.agent.arp.command", "/sbin/arp");
        this.useIpTables = this.setup.getInt("wifi.agent.not.use.iptables", 0) != 1;
        this.sendRadiusUpdates = this.setup.getInt("radius.update.send", 1) == 1;
        this.radiusUpdateTimeout = this.setup.getInt("radius.update.timeout", this.radiusUpdateTimeout);
        this.useHttpsClientAuth = this.setup.getBoolean("portal.https.client.auth", true);
        this.activate = this.setup.getBoolean("portal.activate", false);
        this.activateWithForward = this.setup.getBoolean("portal.activate.with.forward", false);
        try {
            URL url = WiFiAgent.class.getResource("/init.sh");
            if (url == null) {
                log.error((Object)(WiFiAgent.class.getResource("/").getPath() + "init.sh not found..."));
            } else {
                String path = url.getPath();
                path = path.substring(0, path.indexOf("init.sh"));
                this.loginScript = path + "login.sh";
                this.logoutScript = path + "logout.sh";
                this.initScript = path + "init.sh";
                this.ipCountScript = path + "ip_counts.sh";
            }
        }
        catch (Exception e) {
            log.error((Object)"", (Throwable)e);
        }
        this.allowLinking = this.setup.getInt("portal.allow.linking", 0) == 1;
        this.useSSI = this.setup.getInt("portal.use.ssi", 0) == 1;
        this.clearChain = this.setup.getInt("wifi.agent.iptables.clear", 0) == 1;
    }

    public String getAccountHost() {
        return this.accountHost;
    }

    public int getAccountPort() {
        return this.accountPort;
    }

    public String getAuthHost() {
        return this.authHost;
    }

    public int getAuthPort() {
        return this.authPort;
    }

    public String getNasId() {
        return this.nasId;
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public String getInitScript() {
        return this.initScript;
    }

    public String getLoginScript() {
        return this.loginScript;
    }

    public String getLogoutScript() {
        return this.logoutScript;
    }

    public String getCardLink() {
        return this.cardLink;
    }

    public int getHttpPort() {
        return this.httpPort;
    }

    public int getHttpsPort() {
        return this.httpsPort;
    }

    public int getMid() {
        return this.mid;
    }

    public String getPasswordUrl() {
        return this.passwordUrl;
    }

    public String getPortalHttpsUrl() {
        return this.portalHttpsUrl;
    }

    public String getPortalHttpUrl() {
        return this.portalHttpUrl;
    }

    public boolean isRemindPassword() {
        return this.remindPassword;
    }

    public String getServerHttpsUrl() {
        return this.serverHttpsUrl;
    }

    public String getServerHttpUrl() {
        return this.serverHttpUrl;
    }

    public String getServerLogin() {
        return this.serverLogin;
    }

    public String getServerPasswd() {
        return this.serverPasswd;
    }

    public boolean isShowStatistics() {
        return this.showStatistics;
    }

    public String getStatHttpsUrl() {
        return this.statHttpsUrl;
    }

    public String getStatHttpUrl() {
        return this.statHttpUrl;
    }

    public boolean isUseHttps() {
        return this.useHttps;
    }

    public boolean isUseRealm() {
        return this.useRealm;
    }

    public List<Map<String, String>> getAuthAttrs() {
        return this.authAttrs;
    }

    public List<Map<String, String>> getRealms() {
        return this.realms;
    }

    public SetupData getSetup() {
        return this.setup;
    }

    public String getOption(String key) {
        return this.setup.get(key);
    }

    private void initSAuthAttributeList() {
        ParameterMap values = this.setup.sub("wifi.agent.radius.atrubute.");
        HashMap result = new HashMap();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String longKey = entry.getKey();
            String key = longKey.substring(0, longKey.indexOf("."));
            String suffix = longKey.substring(longKey.indexOf(".") + 1);
            HashMap<String, String> value = (HashMap<String, String>)result.get(key);
            if (value == null) {
                value = new HashMap<String, String>();
                result.put(key, value);
                value.put("key", key);
            }
            if (suffix.startsWith("vendor")) {
                value.put("vendorCode", entry.getValue());
                continue;
            }
            if (suffix.startsWith("attr")) {
                value.put("attrCode", entry.getValue());
                continue;
            }
            if (!suffix.startsWith("type")) continue;
            value.put("type", entry.getValue());
        }
        this.authAttrs.addAll(result.values());
        Collections.sort(this.authAttrs, new KeyComparator());
    }

    public Map<String, String> getConnectorOptions(String prefix) {
        ParameterMap values = this.setup.sub(prefix);
        HashMap<String, String> connectorOptions = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            connectorOptions.put(entry.getKey(), entry.getValue());
        }
        return connectorOptions;
    }

    private void initRealms() {
        Map<String, Map<String, String>> result = this.readParams("portal.tarif.");
        this.realms.addAll(result.values());
        Collections.sort(this.realms, new KeyComparator());
    }

    protected Map<String, Map<String, String>> readParams(String prefix) {
        ParameterMap values = this.setup.sub(prefix);
        HashMap<String, Map<String, String>> result = new HashMap<String, Map<String, String>>();
        for (Map.Entry<String, String> entry : values.entrySet()) {
            String longKey = entry.getKey();
            String key = longKey.substring(0, longKey.indexOf("."));
            String suffix = longKey.substring(longKey.indexOf(".") + 1);
            HashMap<String, String> valueMap = (HashMap<String, String>)result.get(key);
            if (valueMap == null) {
                valueMap = new HashMap<String, String>();
                result.put(key, valueMap);
                valueMap.put("key", key);
            }
            valueMap.put(suffix, entry.getValue());
        }
        return result;
    }

    private void initActivateParameters() {
        Map<String, Map<String, String>> result = this.readParams("portal.activate.parameter.");
        this.activateParams.addAll(result.values());
        Collections.sort(this.activateParams, new KeyComparator());
    }

    public int getAdminPort() {
        return this.adminPort;
    }

    public int getAgentPort() {
        return this.agentPort;
    }

    public boolean isDhcp() {
        return this.dhcp;
    }

    public String getArpCommand() {
        return arpCommand;
    }

    public boolean isAllowLinking() {
        return this.allowLinking;
    }

    public boolean isUseSSI() {
        return this.useSSI;
    }

    public boolean isUseIpTables() {
        return this.useIpTables;
    }

    public boolean isClearChain() {
        return this.clearChain;
    }

    public String getIpCountScript() {
        return this.ipCountScript;
    }

    public boolean isSendRadiusUpdates() {
        return this.sendRadiusUpdates;
    }

    public int getRadiusUpdateTimeout() {
        return this.radiusUpdateTimeout;
    }

    public boolean isUseHttpsClientAuth() {
        return this.useHttpsClientAuth;
    }

    public String getHeaderNameRemoteAddress() {
        return this.setup.get("portal.http.header.name.remote.addr");
    }

    public boolean isActivate() {
        return this.activate;
    }

    public boolean isActivateWithForward() {
        return this.activateWithForward;
    }

    public List<Map<String, String>> getActivateParams() {
        return this.activateParams;
    }
}

