/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.tariff.server.range;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.tariff.server.range.RangeManager;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRange;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeEntry;
import ru.bitel.bgbilling.kernel.tariff.server.range.TrafficRangeKey;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;

public abstract class RangeRecalculateManager
implements AutoCloseable {
    private static final Logger logger = Logger.getLogger(RangeRecalculateManager.class);
    protected int moduleId;
    protected Connection con;
    protected Date dateFrom;
    protected Date dateTo;
    private PreparedStatement insertRangeTraffsDetailPS;
    private PreparedStatement updateRangeTraffsDetailPS;
    private PreparedStatement insertRangeTraffsPS;
    private PreparedStatement updateRangeTraffsPS;
    private Set<Integer> affectedDaysForContract = new HashSet<Integer>();
    private Set<Integer> affectedContracts = new HashSet<Integer>();
    protected RangeManager manager;
    protected String trafficRangeTableName;
    protected String trafficRangeDetailTableName;

    public RangeRecalculateManager(Connection con, Date dateFrom, Date dateTo, int moduleId, RangeManager manager) throws SQLException {
        this.con = con;
        this.dateFrom = dateFrom;
        this.dateTo = dateTo;
        this.moduleId = moduleId;
        this.manager = manager;
        this.initTableNames(dateFrom, moduleId);
        this.init();
    }

    protected abstract void initTableNames(Date var1, int var2);

    private void init() throws SQLException {
        this.updateRangeTraffsPS = this.con.prepareStatement("UPDATE " + this.trafficRangeTableName + " SET amount = ?, maxAmount = ?,  counter = counter + 1 WHERE contractId = ? AND treeNodeId = ? AND rangeKey = ?  AND yy =? AND mm=? AND (@counter:=counter) IS NOT NULL");
        this.insertRangeTraffsPS = this.con.prepareStatement("INSERT INTO " + this.trafficRangeTableName + " SET contractId=?, treeNodeId=?, rangeKey=?, amount=?, yy=?, mm=?, counter=?, maxAmount=?");
    }

    public void flushDay(int contractId, int day) throws SQLException {
        if (this.insertRangeTraffsDetailPS == null) {
            this.insertRangeTraffsDetailPS = this.con.prepareStatement("INSERT INTO " + this.trafficRangeDetailTableName + " ( contractId, treeNodeId, rangeKey, day, amount  )  VALUES (?,?,?,?,?)");
        }
        if (this.updateRangeTraffsDetailPS == null) {
            this.updateRangeTraffsDetailPS = this.con.prepareStatement("UPDATE " + this.trafficRangeDetailTableName + " SET  amount=? WHERE  contractId = ? AND treeNodeId = ? AND rangeKey = ? AND day = ?");
        }
        this.affectedDaysForContract.add(day);
        TrafficRangeEntry trafficRangeEntry = this.manager.getRangedTrafficEntry(contractId);
        HashSet<Long> affectedTreenodes = new HashSet<Long>();
        HashSet<Long> affectedKeys = new HashSet<Long>();
        if (trafficRangeEntry != null) {
            TrafficRange value;
            TrafficRangeKey key;
            HashMap<TrafficRangeKey, TrafficRange> rangeTrafsMap = new HashMap<TrafficRangeKey, TrafficRange>();
            block3: for (Map.Entry<TrafficRangeKey, TrafficRange> entry : trafficRangeEntry.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                long delta = value.delta;
                if (delta == 0L) continue;
                switch (TrafficRangeKey.getMode(key.getKey())) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        continue block3;
                    }
                }
                this.addDeltaToMap(rangeTrafsMap, key, value);
                value.delta = 0L;
                trafficRangeEntry.delta = false;
            }
            for (Map.Entry<TrafficRangeKey, TrafficRange> entry : rangeTrafsMap.entrySet()) {
                key = entry.getKey();
                value = entry.getValue();
                if (value.amount == 0L) continue;
                affectedTreenodes.add(key.getTreeNodeId());
                affectedKeys.add(key.getKey());
                int idx = 1;
                this.updateRangeTraffsDetailPS.setLong(idx++, value.amount);
                this.updateRangeTraffsDetailPS.setInt(idx++, contractId);
                this.updateRangeTraffsDetailPS.setLong(idx++, key.getTreeNodeId());
                this.updateRangeTraffsDetailPS.setLong(idx++, key.getKey());
                this.updateRangeTraffsDetailPS.setInt(idx++, day);
                if (this.updateRangeTraffsDetailPS.executeUpdate() != 0) continue;
                idx = 1;
                this.insertRangeTraffsDetailPS.setInt(idx++, contractId);
                this.insertRangeTraffsDetailPS.setLong(idx++, key.getTreeNodeId());
                this.insertRangeTraffsDetailPS.setLong(idx++, key.getKey());
                this.insertRangeTraffsDetailPS.setInt(idx++, day);
                this.insertRangeTraffsDetailPS.setLong(idx++, value.amount);
                this.insertRangeTraffsDetailPS.executeUpdate();
            }
        }
        if (affectedTreenodes.size() == 0) {
            affectedTreenodes.add(-1L);
        }
        if (affectedKeys.size() == 0) {
            affectedKeys.add(-1L);
        }
        PreparedStatement deleteInvalidRangeTraffsDetailForContractAndDayPS = this.con.prepareStatement(" DELETE FROM " + this.trafficRangeDetailTableName + " WHERE contractId = ?  AND day = ? AND  ( treenodeId not in (" + Utils.toString(affectedTreenodes) + ") OR rangeKey not in (" + Utils.toString(affectedKeys) + ") ) ");
        int idx = 1;
        deleteInvalidRangeTraffsDetailForContractAndDayPS.setInt(idx++, contractId);
        deleteInvalidRangeTraffsDetailForContractAndDayPS.setInt(idx++, day);
        deleteInvalidRangeTraffsDetailForContractAndDayPS.executeUpdate();
        deleteInvalidRangeTraffsDetailForContractAndDayPS.close();
    }

    public void flushContract(int contractId) throws SQLException, BGException {
        HashSet<Long> affectedKeys = new HashSet<Long>();
        HashSet<Long> affectedNodes = new HashSet<Long>();
        TrafficRangeEntry trafficRangeEntry = this.manager.getRangedTrafficEntry(contractId);
        if (trafficRangeEntry != null) {
            block3: for (Map.Entry<TrafficRangeKey, TrafficRange> entry : trafficRangeEntry.entrySet()) {
                TrafficRangeKey key = entry.getKey();
                TrafficRange value = entry.getValue();
                if (value.amount == 0L) continue;
                switch (TrafficRangeKey.getMode(key.getKey())) {
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        continue block3;
                    }
                }
                affectedKeys.add(key.getKey());
                affectedNodes.add(key.getTreeNodeId());
                this.updateRangeTraffic(contractId, key, value);
            }
        }
        if (affectedNodes.size() == 0) {
            affectedNodes.add(-1L);
        }
        if (affectedKeys.size() == 0) {
            affectedKeys.add(-1L);
        }
        this.deleteInvalidRangeTraffs(contractId, affectedKeys, affectedNodes);
        this.deleteRangeTraffsDetailForInvalidDays(contractId);
        this.affectedContracts.add(contractId);
        if (this.affectedDaysForContract != null) {
            this.affectedDaysForContract.clear();
        }
    }

    protected void deleteInvalidRangeTraffs(int contractId, Set<Long> affectedKeys, Set<Long> affectedNodes) throws SQLException {
        if (affectedKeys.size() == 0) {
            affectedKeys.add(-1L);
        }
        if (affectedNodes.size() == 0) {
            affectedNodes.add(-1L);
        }
        int yy = TimeUtils.convertDateToCalendar(this.dateFrom).get(1);
        int mm = TimeUtils.convertDateToCalendar(this.dateFrom).get(2) + 1;
        int idx = 1;
        PreparedStatement deleteInvalidRangeTraffsForContractPS = this.con.prepareStatement("DELETE FROM " + this.trafficRangeTableName + " WHERE contractId=?  AND yy = ? AND mm = ?  AND ( treeNodeId NOT IN (" + Utils.toString(affectedNodes) + ")  OR rangeKey not IN(" + Utils.toString(affectedKeys) + ") )");
        deleteInvalidRangeTraffsForContractPS.setInt(idx++, contractId);
        deleteInvalidRangeTraffsForContractPS.setInt(idx++, yy);
        deleteInvalidRangeTraffsForContractPS.setInt(idx++, mm);
        deleteInvalidRangeTraffsForContractPS.executeUpdate();
        deleteInvalidRangeTraffsForContractPS.close();
    }

    protected void deleteRangeTraffsDetailForInvalidDays(int contractId) throws SQLException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("this.affectedDaysForContract = " + this.affectedDaysForContract));
        }
        Set<Integer> affectedDaysForContract = this.affectedDaysForContract != null && this.affectedDaysForContract.size() > 0 ? this.affectedDaysForContract : Collections.singleton(-1);
        PreparedStatement deleteInvalidRangeTraffsDetailForContract = this.con.prepareStatement(" DELETE FROM " + this.trafficRangeDetailTableName + " WHERE contractId = ?  AND day NOT IN(" + Utils.toString(affectedDaysForContract) + " )  AND day >= ? AND day <= ? ");
        Calendar calFrom = TimeUtils.convertDateToCalendar(this.dateFrom);
        Calendar calTo = TimeUtils.convertDateToCalendar(this.dateTo);
        int dayFrom = calFrom.get(5);
        int dayTo = TimeUtils.monthsDelta(this.dateFrom, this.dateTo) == 0 ? calTo.get(5) - 1 : calFrom.getActualMaximum(5);
        int idx = 1;
        deleteInvalidRangeTraffsDetailForContract.setInt(idx++, contractId);
        deleteInvalidRangeTraffsDetailForContract.setInt(idx++, dayFrom);
        deleteInvalidRangeTraffsDetailForContract.setInt(idx++, dayTo);
        deleteInvalidRangeTraffsDetailForContract.executeUpdate();
        deleteInvalidRangeTraffsDetailForContract.close();
    }

    protected void updateRangeTraffic(int contractId, TrafficRangeKey key, TrafficRange value) throws SQLException {
        int yy = TimeUtils.convertDateToCalendar(this.dateFrom).get(1);
        int mm = TimeUtils.convertDateToCalendar(this.dateFrom).get(2) + 1;
        int idx = 1;
        this.updateRangeTraffsPS.setLong(idx++, value.amount);
        this.updateRangeTraffsPS.setLong(idx++, value.maxAmount);
        this.updateRangeTraffsPS.setInt(idx++, contractId);
        this.updateRangeTraffsPS.setLong(idx++, key.getTreeNodeId());
        this.updateRangeTraffsPS.setLong(idx++, key.getKey());
        this.updateRangeTraffsPS.setLong(idx++, yy);
        this.updateRangeTraffsPS.setLong(idx++, mm);
        if (this.updateRangeTraffsPS.executeUpdate() == 0) {
            idx = 1;
            this.insertRangeTraffsPS.setInt(idx++, contractId);
            this.insertRangeTraffsPS.setLong(idx++, key.getTreeNodeId());
            this.insertRangeTraffsPS.setLong(idx++, key.getKey());
            this.insertRangeTraffsPS.setLong(idx++, value.amount);
            this.insertRangeTraffsPS.setInt(idx++, yy);
            this.insertRangeTraffsPS.setInt(idx++, mm);
            this.insertRangeTraffsPS.setInt(idx++, 1);
            this.insertRangeTraffsPS.setLong(idx++, value.maxAmount);
            this.insertRangeTraffsPS.executeUpdate();
        }
    }

    private TrafficRange addDeltaToMap(Map<TrafficRangeKey, TrafficRange> rangeTrafsMap, TrafficRangeKey key, TrafficRange value) {
        TrafficRange cachedValue = rangeTrafsMap.get(key);
        if (cachedValue == null) {
            cachedValue = new TrafficRange(0, value.delta, value.maxAmount);
            rangeTrafsMap.put(key, cachedValue);
        } else {
            cachedValue.amount += value.delta;
        }
        return cachedValue;
    }

    @Override
    public void close() throws SQLException {
        if (this.updateRangeTraffsPS != null) {
            this.updateRangeTraffsPS.close();
        }
        if (this.insertRangeTraffsPS != null) {
            this.insertRangeTraffsPS.close();
        }
        if (this.insertRangeTraffsDetailPS != null) {
            this.insertRangeTraffsDetailPS.close();
        }
        if (this.updateRangeTraffsDetailPS != null) {
            this.updateRangeTraffsDetailPS.close();
        }
    }

    public void setAffectedDaysForContract(Set<Integer> affectedDaysForContract) {
        this.affectedDaysForContract = affectedDaysForContract;
    }
}

