/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.event;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.event.Event;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.MessageHandler;
import ru.bitel.common.worker.Commitable;
import ru.bitel.common.worker.CommitableHandler;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.WorkerThreadFactory;

public abstract class PoolEventPublisher<E extends Event>
implements Runnable {
    private static final Logger logger = Logger.getLogger(PoolEventPublisher.class);
    private final Class<E> clazz;
    private final EventProcessor eventProcessor;
    private final BlockingQueue<E> queue;
    final int moduleId;
    final int pluginId;
    final ScheduledFuture<?> future;
    private static final ScheduledExecutorService EXECUTOR_SERVICE = Executors.newScheduledThreadPool(2, new WorkerThreadFactory("evpool-pblsh", null, null));
    protected MessageHandler messageHandler;

    PoolEventPublisher(EventProcessor eventProcessor, Class<E> clazz, int moduleId, int pluginId) {
        this(eventProcessor, clazz, moduleId, pluginId, 500, 1000L);
    }

    PoolEventPublisher(EventProcessor eventProcessor, Class<E> clazz, int moduleId, int pluginId, int capacity, long delay) {
        this.clazz = clazz;
        this.moduleId = moduleId;
        this.pluginId = pluginId;
        this.eventProcessor = eventProcessor;
        this.queue = new ArrayBlockingQueue(capacity);
        this.future = EXECUTOR_SERVICE.scheduleWithFixedDelay(new WeakWorker(this), delay, delay, TimeUnit.MILLISECONDS);
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.messageHandler = messageHandler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(E e) throws BGException {
        assert (!this.future.isCancelled());
        if (!this.queue.offer(e)) {
            ArrayList<E> list;
            PoolEventPublisher poolEventPublisher = this;
            synchronized (poolEventPublisher) {
                if (this.queue.offer(e)) {
                    return;
                }
                list = new ArrayList<E>();
                this.queue.drainTo(list);
                list.add(e);
            }
            this.publish(this.eventProcessor, this.clazz, list);
        }
    }

    @Override
    public void run() {
        ArrayList list = new ArrayList();
        this.queue.drainTo(list);
        if (list.size() > 0) {
            try {
                assert (this.check(list));
                this.publish(this.eventProcessor, this.clazz, list);
            }
            catch (BGException e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean check(List<E> list) {
        for (Event e : list) {
            if (e.getModuleId() == this.moduleId && e.getPluginId() == this.pluginId) continue;
            return false;
        }
        return true;
    }

    protected abstract void publish(EventProcessor var1, Class<E> var2, List<E> var3) throws BGException;

    public void close() {
        this.run();
        this.future.cancel(false);
    }

    protected void finalize() throws Throwable {
        if (!this.future.isCancelled()) {
            this.close();
        }
        super.finalize();
    }

    public void publishAfterCommit(CommitableHandler context, E e) {
        context.addCommitable(new Commitable((Event)e){
            final /* synthetic */ Event val$e;
            {
                this.val$e = event;
            }

            @Override
            public final void commit() throws Exception {
                PoolEventPublisher.this.publish(this.val$e);
            }
        });
    }

    public void publishAfterCommit(E e) {
        ThreadContext.get(CommitableHandler.class).addCommitable(new Commitable((Event)e){
            final /* synthetic */ Event val$e;
            {
                this.val$e = event;
            }

            @Override
            public final void commit() throws Exception {
                PoolEventPublisher.this.publish(this.val$e);
            }
        });
    }

    static class WeakWorker<E extends Event>
    implements Runnable {
        private WeakReference<PoolEventPublisher<E>> ref;

        WeakWorker(PoolEventPublisher<E> ep) {
            this.ref = new WeakReference<PoolEventPublisher<E>>(ep);
        }

        @Override
        public void run() {
            PoolEventPublisher ep = (PoolEventPublisher)this.ref.get();
            if (ep != null) {
                ep.run();
            }
        }
    }
}

