/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.status.server.service;

import bitel.billing.server.contract.bean.ContractStatus;
import bitel.billing.server.contract.bean.ContractStatusManager;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.MonitorStatusResult;
import ru.bitel.bgbilling.kernel.contract.status.common.bean.Status;
import ru.bitel.bgbilling.kernel.contract.status.common.service.ContractStatusMonitorService;
import ru.bitel.bgbilling.kernel.contract.status.server.ServerStatusUtil;
import ru.bitel.bgbilling.kernel.contract.status.server.StatusCache;
import ru.bitel.bgbilling.kernel.contract.status.server.bean.ContractStatusMonitorDao;
import ru.bitel.bgbilling.server.util.ClosedDateChecker;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.MapHolder;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.contract.status.common.service.ContractStatusMonitorService")
public class ContractStatusMonitorServiceImpl
extends AbstractService
implements ContractStatusMonitorService {
    protected static Calendar balanceDumpTime;

    @Override
    public void createBalanceDump() throws BGException {
        ContractStatusMonitorDao dao = new ContractStatusMonitorDao(this.getConnection());
        balanceDumpTime = dao.createBalanceDump();
        dao.close();
    }

    @Override
    public SearchResult<MonitorStatusResult> contractSearch(int mode, int statusPeriod, String statusPeriodUnit, Set<Integer> group, Set<Integer> notGroup, String status, String saldoFrom, String saldoTo, String sort, int subContract, Page page, int saldoAccountMonths, BigDecimal saldoAcconuntsMore, Set<Integer> serviceAccountMaxServices, float serviceMaxVal, int balanceLimit, int balancePrevLimit) throws BGException {
        if (balanceDumpTime == null) {
            throw new BGMessageException("\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0434\u0435\u043b\u0430\u0442\u044c \u0441\u0440\u0435\u0437 \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u0432!");
        }
        if (TimeUtils.daysDelta(balanceDumpTime, new GregorianCalendar()) >= 1) {
            throw new BGMessageException("\u0421\u0440\u0435\u0437 \u0431\u0430\u043b\u0430\u043d\u0441\u043e\u0432 \u0443\u0441\u0442\u0430\u0440\u0435\u043b, \u0441\u0434\u0435\u043b\u0430\u0439\u0442\u0435 \u0435\u0433\u043e \u043f\u043e\u0432\u0442\u043e\u0440\u043d\u043e");
        }
        int saldoShowMode = this.getSetup().getInt("contract.status.monitor.saldo.show.mode", 1);
        long g = Utils.enumToMask(Utils.toString(group));
        long ng = Utils.enumToMask(Utils.toString(notGroup));
        ContractStatusMonitorDao dao = new ContractStatusMonitorDao(this.getConnection());
        SearchResult<MonitorStatusResult> result = dao.contractSearch(saldoShowMode, saldoAccountMonths, serviceMaxVal, Utils.toString(serviceAccountMaxServices), status, mode, subContract, balanceLimit, balancePrevLimit, statusPeriod, statusPeriodUnit, g, ng, saldoFrom, saldoTo, saldoAcconuntsMore, sort, page);
        dao.close();
        return result;
    }

    @Override
    public List<Status> getStatusList(boolean onlyManual) throws BGException {
        List<Status> statusList = null;
        statusList = onlyManual ? StatusCache.getInstance().getManualStatusList() : StatusCache.getInstance().getStatusList();
        return statusList;
    }

    @Override
    public MapHolder<String, String> changeContractStatus(int[] cids, int statusId, Date dateFrom, Date dateTo, String comment, boolean confirmChecked) throws BGException {
        if (cids.length <= 0 || statusId < 0 || dateFrom == null) {
            throw new BGIllegalArgumentException();
        }
        if (dateTo != null && !TimeUtils.dateBeforeOrEq(dateFrom, dateTo)) {
            throw new BGMessageException("\u0423\u043a\u0430\u0437\u0430\u043d \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u0439 \u043f\u0435\u0440\u0438\u043e\u0434");
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (cids.length == 1 && !ServerStatusUtil.checkStatusChange(cids[0], statusId, dateFrom, dateTo, comment, confirmChecked, result)) {
            return new MapHolder<String, String>(result);
        }
        Calendar closedDate = null;
        closedDate = ClosedDateChecker.getClosePeriodDateIfChecking("ActionContractStatusChange", 0, this.userId);
        if (closedDate != null) {
            ClosedDateChecker.checkDatesForUpdate(closedDate, null, null, dateFrom, dateTo);
        }
        ContractStatusManager statusManager = new ContractStatusManager(this.getConnection());
        for (int i = 0; i < cids.length; ++i) {
            ContractStatus status = new ContractStatus();
            status.setComment(comment);
            status.setContractId(cids[i]);
            status.setDateFrom(dateFrom);
            status.setDateTo(dateTo);
            status.setStatus(statusId);
            statusManager.changeStatus(status.clone(), this.userId);
        }
        result.put("status", "ok");
        return new MapHolder<String, String>(result);
    }
}

