/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.label.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelItem;
import ru.bitel.bgbilling.kernel.contract.label.common.bean.ContractLabelType;
import ru.bitel.bgbilling.server.util.ServerUtils;

public class ContractLabelManager {
    protected static final String TABLE_CONTRACT_LABEL = "contract_label";
    protected static final String TABLE_CONTRACT_LABEL_LINK = "contract_label_link";
    private Connection con;

    public ContractLabelManager(Connection con) {
        this.con = con;
    }

    public List<ContractLabelItem> getContractLabelItemList(boolean calcCount) throws BGException {
        ArrayList<ContractLabelItem> result = new ArrayList<ContractLabelItem>();
        try {
            HashMap<Integer, ContractLabelItem> map = new HashMap<Integer, ContractLabelItem>();
            ContractLabelItem contractLabelItem = new ContractLabelItem();
            contractLabelItem.setId(1);
            contractLabelItem.setParentId(0);
            contractLabelItem.setTitle("\u0413\u0440\u0443\u043f\u043f\u044b \u0434\u043e\u0433\u043e\u0432\u043e\u0440\u043e\u0432");
            contractLabelItem.setContractLabelType(ContractLabelType.GROUP);
            result.add(contractLabelItem);
            Statement st = this.con.createStatement();
            StringBuilder query = new StringBuilder("SELECT * FROM ").append(TABLE_CONTRACT_LABEL).append(" ORDER BY title");
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                contractLabelItem = this.getContractLabelItemFromRS(rs);
                if (contractLabelItem.getId() == 100) {
                    contractLabelItem.setParentId(0);
                    contractLabelItem.setContractLabelType(ContractLabelType.LABEL);
                }
                map.put(contractLabelItem.getId(), contractLabelItem);
                result.add(contractLabelItem);
            }
            rs.close();
            if (calcCount) {
                query.setLength(0);
                query.append("SELECT label_id, count(*) FROM ").append(TABLE_CONTRACT_LABEL_LINK).append(" GROUP BY label_id");
                rs = st.executeQuery(query.toString());
                while (rs.next()) {
                    contractLabelItem = (ContractLabelItem)map.get(rs.getInt(1));
                    if (contractLabelItem == null) continue;
                    contractLabelItem.setContractLinkCount(rs.getInt(2));
                }
                rs.close();
            }
            st.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public Set<Integer> getContractLabelIds(int contractPlanId) throws BGException {
        HashSet<Integer> result = new HashSet<Integer>();
        try {
            StringBuilder query = new StringBuilder("SELECT label_id FROM ").append(TABLE_CONTRACT_LABEL_LINK).append(" WHERE contract_id=").append(contractPlanId);
            Statement st = this.con.createStatement();
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                result.add(rs.getInt(1));
            }
            rs.close();
            st.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
        return result;
    }

    public void setContractLabelIds(int contractId, Set<Integer> labelIds) throws BGException {
        try {
            StringBuilder query = new StringBuilder("DELETE FROM ").append(TABLE_CONTRACT_LABEL_LINK).append(" WHERE contract_id=").append(contractId);
            Statement st = this.con.createStatement();
            st.executeUpdate(query.toString());
            st.close();
            query.setLength(0);
            query.append("INSERT INTO ").append(TABLE_CONTRACT_LABEL_LINK).append(" SET contract_id=").append(contractId).append(", label_id=?");
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            for (Integer id : labelIds) {
                ps.setInt(1, id);
                ps.executeUpdate();
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    public void updateContractLabelTreeItem(ContractLabelItem contractLabelItem) throws BGException {
        try {
            if (contractLabelItem == null) {
                throw new NullPointerException("contractLabelItem is null!");
            }
            StringBuilder query = new StringBuilder();
            if (contractLabelItem.getId() > 0) {
                query.append("UPDATE ");
                query.append(TABLE_CONTRACT_LABEL);
                query.append(" SET parent_id=?, title=? WHERE id=?");
            } else {
                query.append("INSERT INTO ");
                query.append(TABLE_CONTRACT_LABEL);
                query.append(" SET parent_id=?, title=?");
            }
            PreparedStatement ps = this.con.prepareStatement(query.toString());
            ps.setInt(1, contractLabelItem.getParentId());
            ps.setString(2, contractLabelItem.getTitle());
            if (contractLabelItem.getId() > 0) {
                ps.setInt(3, contractLabelItem.getId());
            }
            ps.executeUpdate();
            if (contractLabelItem.getId() < 0) {
                contractLabelItem.setId(ServerUtils.lastInsertId(this.con));
            }
            ps.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    public void removeContractLabelItem(int contractLabelItemId) throws BGException {
        try {
            Statement st = this.con.createStatement();
            StringBuilder query = new StringBuilder("DELETE FROM ").append(TABLE_CONTRACT_LABEL_LINK).append(" WHERE label_id=").append(contractLabelItemId);
            st.executeUpdate(query.toString());
            query.setLength(0);
            query.append("DELETE FROM ").append(TABLE_CONTRACT_LABEL).append(" WHERE id=").append(contractLabelItemId);
            st.executeUpdate(query.toString());
            st.close();
        }
        catch (Exception ex) {
            throw new BGException(ex);
        }
    }

    private ContractLabelItem getContractLabelItemFromRS(ResultSet rs) throws SQLException {
        ContractLabelItem contractLabelItem = new ContractLabelItem();
        contractLabelItem.setId(rs.getInt("id"));
        contractLabelItem.setParentId(rs.getInt("parent_id"));
        contractLabelItem.setTitle(rs.getString("title"));
        contractLabelItem.setContractLabelType(ContractLabelType.LABEL_ITEM);
        return contractLabelItem;
    }

    public ContractLabelItem getTree() throws BGException {
        ContractLabelItem contractLabelItem = new ContractLabelItem();
        contractLabelItem.setTitle("\u041c\u0435\u0442\u043a\u0438");
        contractLabelItem.setId(1);
        contractLabelItem.setParentId(0);
        contractLabelItem.setSelected(true);
        contractLabelItem.setContractLabelType(ContractLabelType.GROUP);
        ArrayList<ContractLabelItem> contracts = new ArrayList<ContractLabelItem>();
        try {
            Statement st = this.con.createStatement();
            StringBuilder query = new StringBuilder("SELECT * FROM ").append(TABLE_CONTRACT_LABEL);
            ResultSet rs = st.executeQuery(query.toString());
            while (rs.next()) {
                ContractLabelItem contractLabelItemFromDb = this.getContractLabelItemFromRS(rs);
                contracts.add(contractLabelItemFromDb);
            }
            rs.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        this.addChild(contractLabelItem.getId(), contractLabelItem, contracts);
        return contractLabelItem;
    }

    protected void addChild(int up, ContractLabelItem rootItem, List<ContractLabelItem> list) {
        for (ContractLabelItem listItem : list) {
            if (up != listItem.getParentId()) continue;
            rootItem.addChild(listItem);
            this.addChild(listItem.getId(), listItem, list);
        }
    }
}

