/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.balance.server.bean;

import bitel.billing.server.contract.bean.ContractUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.ws.Holder;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Charge;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;
import ru.bitel.common.model.Period;

public class ChargeDao
extends AbstractIdDao<Charge> {
    public ChargeDao(Connection con) {
        super(con, -1, "contract_charge");
    }

    public List<Charge> getChargeList(int contractId, int chargeTypeId, Period period, int members, Holder<BigDecimal> holderTotalSum) throws BGException {
        return this.getList(contractId, chargeTypeId, period, members, false, holderTotalSum);
    }

    public List<Charge> getPaybackList(int contractId, int paybackTypeId, Period period, int members, Holder<BigDecimal> totalSum) throws BGException {
        return this.getList(contractId, paybackTypeId, period, members, true, totalSum);
    }

    public int deleteCharges(int contractId) throws BGException {
        return this.delete("cid=?", contractId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Charge> getList(int contractId, int type, Period period, int members, Boolean isPayback, Holder<BigDecimal> totalSum) throws BGException {
        Date dateFrom = null;
        Date dateTo = null;
        if (period != null) {
            dateFrom = period.getDateFrom();
            dateTo = period.getDateTo();
        }
        try (PreparedStatement ps = this.getPS(contractId, dateFrom, dateTo, type, members, isPayback, true);){
            List<Charge> result;
            if (ps == null) {
                if (totalSum != null) {
                    totalSum.value = BigDecimal.ZERO;
                }
                ArrayList<Charge> arrayList = new ArrayList<Charge>();
                return arrayList;
            }
            if (totalSum != null) {
                ResultSet rs = ps.executeQuery();
                result = new ArrayList();
                Double sumL = 0.0;
                while (true) {
                    if (!rs.next()) {
                        totalSum.value = new BigDecimal(sumL);
                        return result;
                    }
                    sumL = sumL + rs.getDouble("summa");
                    result.add(this.getFromRS(rs));
                }
            }
            result = this.getListFromRS(ps.executeQuery());
            return result;
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BigDecimal getSum(int contractId, Date dateFrom, Date dateTo, int typeId, int members, Boolean isPayback) throws BGException {
        BigDecimal result = BigDecimal.ZERO;
        try (PreparedStatement ps = this.getPS(contractId, dateFrom, dateTo, typeId, members, isPayback, false);){
            if (ps == null) {
                BigDecimal bigDecimal = result;
                return bigDecimal;
            }
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return result;
            result = rs.getBigDecimal("sum");
            return result;
        }
        catch (Exception e) {
            throw new BGException(e);
        }
    }

    private PreparedStatement getPS(int contractId, Date dateFrom, Date dateTo, int typeId, int members, Boolean isPayback, boolean isList) throws Exception {
        String cids = ContractUtils.getCidsStringForQuery(contractId, members, this.con);
        if (cids == null) {
            return null;
        }
        StringBuilder query = new StringBuilder("SELECT " + (isList ? "*" : "IF( SUM(summa) IS NOT NULL, SUM(summa), 0 ) as sum") + " FROM " + this.tableName + " c WHERE c.cid IN(" + cids + ")");
        if (typeId > 0) {
            query.append(" AND c.pt=?");
        }
        if (dateFrom != null) {
            query.append(" AND c.dt >= ?");
        }
        if (dateTo != null) {
            query.append(" AND c.dt <= ?");
        }
        if (isPayback != null) {
            query.append(" AND payback = ?");
        }
        PreparedStatement ps = this.con.prepareStatement(query.toString());
        int index = 1;
        if (typeId > 0) {
            ps.setInt(index++, typeId);
        }
        if (dateFrom != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(dateFrom));
        }
        if (dateTo != null) {
            ps.setDate(index++, TimeUtils.convertDateToSqlDate(dateTo));
        }
        if (isPayback != null) {
            ps.setBoolean(index, isPayback);
        }
        return ps;
    }

    @Override
    protected void updateImpl(Charge charge) throws BGException, SQLException {
        if (charge == null) {
            throw new BGException("Charge is null!");
        }
        int index = 1;
        PreparedStatement ps = null;
        ps = charge.getId() <= 0 ? this.con.prepareStatement("INSERT INTO contract_charge SET dt=?, cid=?, pt=?, uid=?, summa=?, comment=?, payback=?", 1) : this.con.prepareStatement("UPDATE contract_charge SET dt=?, cid=?, pt=?, uid=?, summa=?, comment=? WHERE id=?");
        ps.setDate(index++, TimeUtils.convertDateToSqlDate(charge.getDate()));
        ps.setInt(index++, charge.getContractId());
        ps.setInt(index++, charge.getTypeId());
        ps.setInt(index++, charge.getUserId());
        ps.setBigDecimal(index++, charge.getSum());
        ps.setString(index++, charge.getComment());
        if (charge.getId() > 0) {
            ps.setInt(index++, charge.getId());
        } else {
            ps.setBoolean(index, charge.isPayback());
        }
        ps.executeUpdate();
        if (charge.getId() <= 0) {
            charge.setId(ServerUtils.lastInsertId(ps));
        }
        ps.close();
    }

    @Override
    protected Charge getFromRS(ResultSet rs) throws SQLException, BGException {
        Charge result = new Charge();
        result.setId(rs.getInt("id"));
        result.setContractId(rs.getInt("cid"));
        result.setComment(rs.getString("comment"));
        result.setDate(rs.getDate("dt"));
        result.setTypeId(rs.getInt("pt"));
        result.setSum(rs.getBigDecimal("summa"));
        result.setUserId(rs.getInt("uid"));
        result.setTimeChange(rs.getTimestamp("lm"));
        result.setPayback(rs.getBoolean("payback"));
        return result;
    }
}

