/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.ContractPasswordLogItem;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractDao;
import ru.bitel.common.model.Page;
import ru.bitel.common.model.SearchResult;

public class ContractPasswordLogDao
extends AbstractDao<ContractPasswordLogItem> {
    private static final String TABLE_LOG_CONTRACT_PSWD = "log_contract_pswd";

    public ContractPasswordLogDao(Connection con) {
        super(con, 0, TABLE_LOG_CONTRACT_PSWD);
    }

    public void addContractPasswordLogItem(ContractPasswordLogItem item) throws BGException {
        if (item != null) {
            try {
                PreparedStatement ps = this.con.prepareStatement("INSERT INTO ".concat(this.tableName).concat(" SET ").concat("dt=?, uid=?, cid=?"));
                ps.setTimestamp(1, TimeUtils.convertDateToTimestamp(item.getDatetime()));
                ps.setInt(2, item.getUserId());
                ps.setInt(3, item.getContractId());
                ps.executeUpdate();
                ps.close();
            }
            catch (SQLException e) {
                throw new BGException(e);
            }
        }
    }

    public void searchContractPasswordLogItemByContractId(SearchResult<ContractPasswordLogItem> searchResult, int contractId, List<String> sortFields) throws BGException {
        if (searchResult != null) {
            Page page = searchResult.getPage();
            List<ContractPasswordLogItem> list = searchResult.getList();
            try {
                StringBuilder query = new StringBuilder("SELECT ").append("SQL_CALC_FOUND_ROWS ").append("log.*, user.name AS userName").append(" FROM ").append(this.tableName).append(" AS log ").append("LEFT JOIN ").append("user").append(" ON user.id=log.uid ").append(" WHERE ").append("cid=").append(contractId).append(this.getSQLOrder(sortFields, new String[]{"dt", "userName"})).append(page.sqlLimit());
                Statement st = this.con.createStatement();
                ResultSet rs = st.executeQuery(query.toString());
                while (rs.next()) {
                    list.add(this.getFromRS(rs));
                }
                rs.close();
                st.close();
                page.setRecordCount(ServerUtils.foundRows(this.con));
            }
            catch (SQLException e) {
                throw new BGException(e);
            }
        }
    }

    @Override
    protected ContractPasswordLogItem getFromRS(ResultSet rs) throws SQLException {
        ContractPasswordLogItem item = new ContractPasswordLogItem();
        item.setDatetime(rs.getTimestamp("dt"));
        item.setContractId(rs.getInt("cid"));
        item.setUserId(rs.getInt("uid"));
        return item;
    }

    @Override
    protected void updateImpl(ContractPasswordLogItem b2) throws BGException, SQLException {
    }
}

