/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.contract.api.server.bean;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.limit.common.bean.ContractLimitMovement;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.dao.AbstractIdDao;

public class ContractLimitMovementDao
extends AbstractIdDao<ContractLimitMovement> {
    public ContractLimitMovementDao(Connection con) {
        super(con, 0, "contract_limit_manage");
    }

    @Override
    protected ContractLimitMovement getFromRS(ResultSet rs) throws SQLException, BGException {
        ContractLimitMovement result = new ContractLimitMovement();
        result.setId(rs.getInt("id"));
        result.setAmount(rs.getBigDecimal("summ"));
        result.setDateFrom(TimeUtils.convertSqlDateToDate(rs.getDate("date1")));
        result.setDateTo(TimeUtils.convertSqlDateToDate(rs.getDate("date2")));
        result.setStatus(rs.getInt("status"));
        return result;
    }

    public List<ContractLimitMovement> list(int contractId, Date dateFrom, Date dateTo) throws BGException {
        java.sql.Date sqlDateFrom = TimeUtils.convertDateToSqlDate(dateFrom);
        java.sql.Date sqlDateTo = TimeUtils.convertDateToSqlDate(dateTo);
        return super.list("cid=? AND (? OR date1 IS NULL OR date1<=?) AND (? OR date2 IS NULL OR date2>=?)", "date1", contractId, sqlDateTo == null, sqlDateTo, sqlDateFrom == null, sqlDateFrom);
    }

    @Override
    protected void updateImpl(ContractLimitMovement b2) throws BGException, SQLException {
        throw new UnsupportedOperationException();
    }
}

