/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.container.managed;

import javax.naming.Context;
import ru.bitel.bgbilling.kernel.base.server.DefaultContext;
import ru.bitel.bgbilling.kernel.container.resource.ResourceManager;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.sql.ConnectionSet;

public abstract class ContainerContext
extends DefaultContext {
    private final Context environment;
    private Context namingContext;
    private final int moduleId;
    private final int userId;
    protected final Setup setup;
    private ParameterMap moduleSetup;
    ResourceManager resourceManager;

    public ContainerContext(Context environment, Context namingContext, Setup setup, ParameterMap moduleSetup, ConnectionSet connectionSet, int moduleId, int userId, ResourceManager resourceManager) {
        super(connectionSet);
        this.environment = environment;
        this.namingContext = namingContext;
        this.moduleId = moduleId;
        this.userId = userId;
        this.setup = setup;
        this.moduleSetup = moduleSetup;
        this.resourceManager = resourceManager;
    }

    public Context getNamingContext() {
        if (this.namingContext == null) {
            if (this.moduleId > 0) {
                try {
                    this.namingContext = (Context)Setup.getEnvironment().lookup(String.valueOf(this.moduleId));
                }
                catch (Exception e) {
                    this.namingContext = this.environment;
                }
            } else {
                this.namingContext = this.environment;
            }
        }
        return this.namingContext;
    }

    public ParameterMap getModuleSetup() {
        if (this.moduleSetup == null && this.moduleId > 0) {
            this.moduleSetup = this.setup.getModuleSetup(this.moduleId);
        }
        return this.moduleSetup;
    }

    public Context getEnvironment() {
        return this.environment;
    }

    public int getModuleId() {
        return this.moduleId;
    }

    public int getUserId() {
        return this.userId;
    }

    public Setup getSetup() {
        return this.setup;
    }
}

