/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.config.server.service;

import java.util.Iterator;
import java.util.List;
import javax.jws.WebService;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.bgsecure.common.bean.UserInfo;
import ru.bitel.bgbilling.kernel.config.common.bean.ConfigData;
import ru.bitel.bgbilling.kernel.config.common.service.ConfigService;
import ru.bitel.bgbilling.kernel.config.server.bean.ConfigDAO;
import ru.bitel.bgbilling.kernel.container.service.server.AbstractService;
import ru.bitel.bgbilling.kernel.directory.api.common.bean.Directory;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ModuleConfigModifiedEvent;

@WebService(endpointInterface="ru.bitel.bgbilling.kernel.config.common.service.ConfigService")
public class ConfigServiceImpl
extends AbstractService
implements ConfigService {
    @Override
    public void setActiveModuleConfig(int moduleId, int configId) throws BGException {
        try (ConfigDAO configDAO = new ConfigDAO(this.getConnection());){
            configDAO.setActiveModuleConfig(moduleId, configId);
        }
        EventProcessor.getInstance().publishAfterCommit(new ModuleConfigModifiedEvent(moduleId, this.userId));
    }

    @Override
    public ConfigData getActiveModuleConfig(int moduleId) throws BGException {
        try (ConfigDAO configDAO = new ConfigDAO(this.getConnection());){
            ConfigData configData = configDAO.getActiveConfig(moduleId);
            return configData;
        }
    }

    @Override
    public ConfigData getModuleConfig(int configId) throws BGException {
        try (ConfigDAO configDAO = new ConfigDAO(this.getConnection());){
            ConfigData configData = (ConfigData)configDAO.get(configId);
            return configData;
        }
    }

    @Override
    public void deleteModuleConfig(int moduleId, int configId) throws BGException {
        try (ConfigDAO configDAO = new ConfigDAO(this.getConnection());){
            configDAO.delete(configId);
        }
        EventProcessor.getInstance().publishAfterCommit(new ModuleConfigModifiedEvent(moduleId, this.userId));
    }

    @Override
    public int updateModuleConfig(int moduleId, ConfigData configData) throws BGException {
        try (ConfigDAO configDAO = new ConfigDAO(this.getConnection());){
            configData.setUserId(this.userId);
            configDAO.update(configData);
        }
        EventProcessor.getInstance().publishAfterCommit(new ModuleConfigModifiedEvent(moduleId, this.userId));
        return configData.getId();
    }

    @Override
    public List<ConfigData> getModuleConfigList(int moduleId) throws BGException {
        List<ConfigData> configDataList;
        try (ConfigDAO configDAO = new ConfigDAO(this.getConnection());){
            configDataList = configDAO.list(moduleId, false);
            Directory<UserInfo> directory = this.context.getDirectory(UserInfo.class, 0);
            Iterator<ConfigData> iterator = configDataList.iterator();
            while (iterator.hasNext()) {
                ConfigData configData;
                UserInfo userInfo = directory.get((configData = iterator.next()).getUserId());
                configData.setUserName(userInfo == null ? "??? [id=" + configData.getUserId() + "]" : userInfo.getName());
            }
        }
        return configDataList;
    }
}

