/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.base.phone.server.bean;

import bitel.billing.server.tariff.voice.bean.DestManager;
import bitel.billing.server.tariff.voice.bean.TableManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.AbstractGeographicCode;
import ru.bitel.bgbilling.kernel.base.phone.common.bean.GeographicCode;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class GeographicCodeManager {
    private final Connection con;
    private final int mid;
    private final String tableName;
    private final String destTableName;
    private static final Pattern patternPrefixes = Pattern.compile("^(\\d+)(?:(?:\\s*\\(([\\d,\\s-]+)\\))|(?:\\s+([\\d,\\s-]+)))$");
    private static final Pattern patternPrefixes2 = Pattern.compile("^(?:([\\d-]+)\\s*,\\s*\\d+.*)|(?:([\\d-]+))$");
    private static final Pattern patternPrefixes3 = Pattern.compile("^(\\d+)|(\\d+\\s+\\d+.*)$");

    public GeographicCodeManager(Connection con, int mid) {
        this.con = con;
        this.mid = mid;
        String prefix = TableManager.getPrefix(con, mid);
        this.tableName = prefix + "geographic_code_" + mid;
        this.destTableName = prefix + "dest_" + mid;
    }

    public List<GeographicCode> list() throws BGException {
        try {
            ArrayList<GeographicCode> result = new ArrayList<GeographicCode>();
            PreparedStatement ps = this.con.prepareStatement("SELECT code, dest_id, start_level, end_level, dest.title FROM " + this.tableName + " as gc LEFT JOIN " + this.destTableName + " as dest ON dest.id=gc.dest_id ORDER BY code");
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                GeographicCode code = new GeographicCode();
                code.setCode(rs.getString(1));
                code.setDestinationId(rs.getInt(2));
                code.setStartLevel(rs.getInt(3));
                code.setEndLevel(rs.getInt(4));
                code.setDestination(rs.getString(5));
                result.add(code);
            }
            ps.close();
            return result;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public GeographicCode getTree(boolean destinationTitle) throws BGException {
        if (destinationTitle) {
            return this.getTree();
        }
        try {
            GeographicCode root = new GeographicCode();
            root.setCode("");
            root.setLevel(0);
            PreparedStatement ps = this.con.prepareStatement("SELECT gc.code, gc.dest_id, gc.start_level, gc.end_level FROM " + this.tableName + " as gc ORDER BY code");
            GeographicCode[] path = new GeographicCode[20];
            String lastCode = root.getCode();
            int level = 0;
            path[level] = root;
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String currCode = rs.getString(1);
                GeographicCode code = new GeographicCode();
                code.setCode(currCode);
                code.setDestinationId(rs.getInt(2));
                code.setStartLevel(rs.getInt(3));
                code.setEndLevel(rs.getInt(4));
                if (!currCode.startsWith(lastCode)) {
                    while (--level >= 0 && !currCode.startsWith(path[level].getCode())) {
                    }
                }
                GeographicCode parent = path[level];
                parent.addChild(code);
                path[++level] = code;
                code.setLevel(level);
                lastCode = currCode;
            }
            rs.close();
            ps.close();
            return root;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public GeographicCode getTree() throws BGException {
        try {
            GeographicCode root = new GeographicCode();
            root.setCode("");
            root.setLevel(0);
            PreparedStatement ps = this.con.prepareStatement("SELECT gc.code, gc.dest_id, gc.start_level, gc.end_level, dest.title FROM " + this.tableName + " as gc LEFT JOIN " + this.destTableName + " as dest ON dest.id=gc.dest_id ORDER BY code");
            GeographicCode[] path = new GeographicCode[20];
            String lastCode = root.getCode();
            int level = 0;
            path[level] = root;
            ResultSet rs = ps.executeQuery();
            while (rs.next()) {
                String currCode = rs.getString(1);
                GeographicCode code = new GeographicCode();
                code.setCode(currCode);
                code.setDestinationId(rs.getInt(2));
                code.setStartLevel(rs.getInt(3));
                code.setEndLevel(rs.getInt(4));
                code.setDestination(rs.getString(5));
                if (!currCode.startsWith(lastCode)) {
                    while (--level >= 0 && !currCode.startsWith(path[level].getCode())) {
                    }
                }
                GeographicCode parent = path[level];
                parent.addChild(code);
                path[++level] = code;
                code.setLevel(level);
                lastCode = currCode;
            }
            rs.close();
            ps.close();
            return root;
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void update(GeographicCode code) throws BGException {
        try {
            String query = "UPDATE " + this.tableName + " SET dest_id=?, start_level=?, end_level=? WHERE code=?";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setInt(1, code.getDestinationId());
            ps.setInt(2, code.getStartLevel());
            ps.setInt(3, code.getEndLevel());
            ps.setString(4, code.getCode());
            if (ps.executeUpdate() == 0) {
                ps.close();
                query = "INSERT INTO " + this.tableName + " (code, dest_id, start_level, end_level) VALUES (?, ?, ?, ?)";
                ps = this.con.prepareStatement(query);
                ps.setString(1, code.getCode());
                ps.setInt(2, code.getDestinationId());
                ps.setInt(3, code.getStartLevel());
                ps.setInt(4, code.getEndLevel());
                ps.executeUpdate();
                ps.close();
            }
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.mid);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public int delete(String code) throws BGException {
        try {
            PreparedStatement ps = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE code=?");
            ps.setString(1, code);
            return ps.executeUpdate();
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    public void importFromFile(String data, String prfx, boolean addNew, boolean updateExist) throws BGException {
        this.importFromFile(data, prfx, addNew, updateExist, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importFromFile(String data, String prfx, boolean addNew, boolean updateExist, boolean compact) throws BGException {
        try {
            if (Utils.isBlankString(prfx)) {
                prfx = "";
            }
            DestManager du = new DestManager(this.con, this.mid);
            du.load();
            PreparedStatement psInsert = this.con.prepareStatement("INSERT INTO " + this.tableName + " (code, dest_id, start_level, end_level) VALUES (?, ?, ?, ?)");
            PreparedStatement psUpdate = this.con.prepareStatement("UPDATE " + this.tableName + " SET dest_id=?, start_level=?, end_level=? WHERE code=?");
            Statement stmt = this.con.createStatement();
            stmt.execute("LOCK TABLES " + this.tableName + "  WRITE," + this.destTableName + " WRITE");
            try {
                ArrayList<GeographicCode> result = new ArrayList<GeographicCode>();
                Pattern p = Pattern.compile("^.+((\\[\\d+\\])|(\\{\\d+\\}))$");
                String last = null;
                AbstractGeographicCode parent = null;
                StringTokenizer st = new StringTokenizer(data, "\n");
                while (st.hasMoreTokens()) {
                    String line = st.nextToken();
                    String[] code_dest = line.split("\\s*\t\\s*");
                    String code = code_dest[0];
                    int destCode = 0;
                    String destTitle = null;
                    int startLevel = 0;
                    int endLevel = 0;
                    if (code_dest.length > 1) {
                        destTitle = code_dest[1].trim();
                    }
                    if (code_dest.length > 2) {
                        startLevel = Utils.parseInt(code_dest[2].trim());
                    }
                    if (code_dest.length > 3) {
                        endLevel = Utils.parseInt(code_dest[3].trim());
                    }
                    if (compact && Utils.notBlankString(destTitle)) {
                        List<String> rangedPrefixes = GeographicCodeManager.parsePrefixes(code, true);
                        for (String rangedPrefix : rangedPrefixes) {
                            rangedPrefix = prfx + rangedPrefix;
                            AbstractGeographicCode current = new AbstractGeographicCode();
                            current.setCode(rangedPrefix);
                            if (last != null && destTitle.startsWith(last) && p.matcher(destTitle).matches() && parent != null && current.getPrefix().startsWith(parent.getPrefix())) continue;
                            destCode = du.getCode(destTitle);
                            parent = current;
                            List<String> prefixes = GeographicCodeManager.parsePrefixes(rangedPrefix, false);
                            for (String prefix : prefixes) {
                                GeographicCodeManager.append(result, prefix, destCode, startLevel, endLevel);
                            }
                        }
                        if (last != null && destTitle.startsWith(last) && p.matcher(destTitle).matches()) continue;
                        last = destTitle;
                        continue;
                    }
                    if (Utils.notBlankString(destTitle)) {
                        destCode = du.getCode(destTitle);
                    }
                    for (String prefix : GeographicCodeManager.parsePrefixes(code, false)) {
                        GeographicCodeManager.append(result, prfx + prefix, destCode, startLevel, endLevel);
                    }
                }
                for (GeographicCode code : result) {
                    boolean needInsert = true;
                    if (updateExist) {
                        psUpdate.setInt(1, code.getDestinationId());
                        psUpdate.setInt(2, code.getStartLevel());
                        psUpdate.setInt(3, code.getEndLevel());
                        psUpdate.setString(4, code.getCode());
                        boolean bl = needInsert = psUpdate.executeUpdate() == 0;
                    }
                    if (!addNew || !needInsert) continue;
                    psInsert.setString(1, code.getCode());
                    psInsert.setInt(2, code.getDestinationId());
                    psInsert.setInt(3, code.getStartLevel());
                    psInsert.setInt(4, code.getEndLevel());
                    try {
                        psInsert.executeUpdate();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                stmt.execute("UNLOCK TABLES");
            }
            ServerUtils.changeLastModificationTime(this.con, "zone_map_" + this.mid);
        }
        catch (SQLException e) {
            throw new BGException(e);
        }
    }

    private static final void append(List<GeographicCode> result, String prefix, int destCode, int startLevel, int endLevel) {
        if (Utils.parseLong(prefix) <= 0L) {
            return;
        }
        GeographicCode geoCode = new GeographicCode();
        geoCode.setCode(prefix);
        geoCode.setDestinationId(destCode);
        geoCode.setStartLevel(startLevel);
        geoCode.setEndLevel(endLevel);
        result.add(geoCode);
    }

    public static List<String> parsePrefixes(String string, boolean withRanges) throws BGMessageException {
        String[] prefixes = string.trim().split("\\s*;\\s*");
        ArrayList<String> result = new ArrayList<String>(4);
        for (String prefix : prefixes) {
            String[] subParams;
            Matcher m = patternPrefixes.matcher(prefix);
            if (m.matches()) {
                subParams = new String[]{m.group(1), m.group(2) != null ? m.group(2) : m.group(3)};
            } else if (patternPrefixes2.matcher(prefix).matches()) {
                subParams = new String[]{"", prefix};
            } else if (patternPrefixes3.matcher(prefix).matches()) {
                subParams = prefix.split("\\s+");
            } else {
                throw new BGMessageException("\u041d\u0435 \u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0441\u0442\u0440\u043e\u043a\u0438: " + string);
            }
            if (subParams.length > 1) {
                String[] suffix;
                for (String suf : suffix = subParams[1].split("\\s*,\\s*")) {
                    String[] suf1 = suf.split("\\s*-\\s*");
                    if (suf1.length > 1) {
                        int i1 = Utils.parseInt(suf1[0], -1);
                        int i2 = Utils.parseInt(suf1[1], -1);
                        if (suf1[0].length() != suf1[1].length() || i1 < 0 || i2 < 0 || i1 > i2) {
                            throw new BGMessageException("\u041d\u0435 \u0432\u0435\u0440\u043d\u044b\u0439 \u0444\u043e\u0440\u043c\u0430\u0442 \u0441\u0442\u0440\u043e\u043a\u0438: " + string);
                        }
                        int dim = i2 - i1;
                        if (withRanges && dim > 4) {
                            int n;
                            for (n = suf1[0].length() - (int)Math.ceil(Math.log10(dim)); n > 0 && !suf1[0].regionMatches(0, suf1[1], 0, n); --n) {
                            }
                            if (n <= 0) {
                                result.add(subParams[0] + "(" + suf1[0] + "-" + suf1[1] + ")");
                                continue;
                            }
                            result.add(subParams[0] + suf1[0].substring(0, n) + "(" + suf1[0].substring(n) + "-" + suf1[1].substring(n) + ")");
                            continue;
                        }
                        DecimalFormat fmt = new DecimalFormat(Utils.multiLetter("0", suf1[0].length()));
                        for (int i = i1; i <= i2; ++i) {
                            result.add(subParams[0] + fmt.format(i));
                        }
                        continue;
                    }
                    result.add(subParams[0] + suf);
                }
                continue;
            }
            result.add(subParams[0]);
        }
        return result;
    }
}

