/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.application.server;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.lang.ref.SoftReference;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.bootstrap.Shutdown;

public class CommandPortListener
extends Thread
implements CommandListener {
    private static final Logger log = Logger.getLogger(CommandPortListener.class);
    private List<SoftReference<CommandListener>> listeners = Collections.synchronizedList(new ArrayList());
    private String host;
    private int port = 0;
    private ServerSocket server;

    public CommandPortListener(String host, int port) throws IOException {
        this.host = host;
        this.port = port;
        this.addListener(this);
        this.initSocket();
        this.start();
    }

    public void addListener(CommandListener commandListener) {
        if (this.listeners.contains(commandListener)) {
            log.error((Object)("Listener " + commandListener + " already addeded!"));
            return;
        }
        this.listeners.add(new SoftReference<CommandListener>(commandListener));
    }

    public void removeListener(CommandListener l) {
        try {
            Iterator<SoftReference<CommandListener>> iter = this.listeners.iterator();
            while (iter.hasNext()) {
                SoftReference<CommandListener> ref = iter.next();
                if (ref == null || ref.get() == null) {
                    iter.remove();
                    continue;
                }
                CommandListener listener = ref.get();
                if (listener == null || !listener.equals(l)) continue;
                iter.remove();
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void initSocket() throws IOException {
        try {
            this.server = this.host == null || this.host.trim().length() == 0 ? new ServerSocket(this.port) : new ServerSocket(this.port, 50, InetAddress.getByName(this.host));
        }
        catch (BindException ex1) {
            System.err.println("Admin port " + this.port + " is busy! [" + ex1.getMessage() + "]");
            throw ex1;
        }
        catch (IOException ex2) {
            System.err.println("Admin port " + this.port + " is busy! [" + ex2.getMessage() + "]");
            throw ex2;
        }
    }

    @Override
    public void run() {
        System.out.println("Starting CommandPortListener on port " + this.port);
        while (true) {
            try {
                while (true) {
                    Socket socket = this.server.accept();
                    new AdminPortThread(socket);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void sendCommand(String host, int port, String[] args) {
        InetAddress inetAddress;
        StringBuffer command = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].contains(" ")) {
                command.append("\"").append(args[i]).append("\"").append(" ");
                continue;
            }
            command.append(args[i]).append(" ");
        }
        try {
            inetAddress = InetAddress.getByName(host);
        }
        catch (UnknownHostException ex) {
            System.err.println("Error: " + ex.getLocalizedMessage());
            ex.printStackTrace();
            return;
        }
        try (Socket socket = new Socket(inetAddress, port);){
            socket.setSoTimeout(Utils.parseInt(System.getProperty("socket.timeout"), 30000));
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            out.println(command.toString().trim());
            out.println();
            String line = null;
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            while ((line = in.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (SocketTimeoutException ex) {
            System.err.println("Error: " + host + ":" + port + " unavailable");
        }
        catch (Exception ex) {
            System.err.println("Error: " + ex.getLocalizedMessage());
            ex.printStackTrace();
        }
    }

    @Override
    public String getCommandsHelp() {
        return "help - show Help\n";
    }

    @Override
    public String executeCommand(String command, String param) {
        StringBuilder result = new StringBuilder();
        if ("help".equals(command)) {
            result.append("Help:\n");
            for (SoftReference<CommandListener> ref : this.listeners) {
                String commansHelp;
                CommandListener l = ref.get();
                if (l == null || (commansHelp = l.getCommandsHelp()) == null) continue;
                result.append(commansHelp);
            }
        }
        return result.toString();
    }

    private final class AdminPortThread
    extends Thread {
        private final Socket socket;
        private final BufferedReader br;
        private final PrintWriter out;

        public AdminPortThread(Socket socket) throws Exception {
            this.socket = socket;
            this.br = ServerUtils.getSocketIn(socket);
            this.out = ServerUtils.getSocketOut(socket);
            this.setDaemon(true);
            this.start();
        }

        private void doCommand(String line) {
            String command = line;
            String params = "";
            int pos = line.indexOf(" ");
            if (pos > 0) {
                command = line.substring(0, pos);
                params = line.substring(pos + 1, line.length());
            }
            if (Utils.isBlankString(command)) {
                command = "help";
            }
            boolean commandExecuted = false;
            for (SoftReference ref : CommandPortListener.this.listeners) {
                String result;
                CommandListener l = (CommandListener)ref.get();
                if (l == null || !Utils.notBlankString(result = l.executeCommand(command, params))) continue;
                commandExecuted = true;
                this.out.println(result);
            }
            if (!commandExecuted) {
                this.out.println("Command '" + command + "' not found.");
            }
        }

        @Override
        public void run() {
            try {
                StringBuilder buf = new StringBuilder();
                String line = null;
                while ((line = this.br.readLine()) != null && !Utils.isBlankString(line)) {
                    buf.append(line);
                }
                String command = buf.toString();
                if (command.equals("stop")) {
                    Shutdown.addOnShutdown(new Shutdown.OnShutdown(){

                        @Override
                        public void onShutdown() {
                            try {
                                AdminPortThread.this.out.println("Stopped.");
                                AdminPortThread.this.out.flush();
                                AdminPortThread.this.socket.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                } else {
                    this.doCommand(command);
                }
                if (command.equals("stop")) {
                    System.exit(0);
                    return;
                }
                this.socket.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

