/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.application.server;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.tariff.TariffTreesCache;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.log4j.Logger;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.application.server.CommandListener;
import ru.bitel.bgbilling.kernel.application.server.CommandPortListener;
import ru.bitel.bgbilling.kernel.application.server.ExtendedLifecycle;
import ru.bitel.bgbilling.kernel.application.server.Lifecycle;
import ru.bitel.bgbilling.kernel.application.server.MethodProperties;
import ru.bitel.bgbilling.kernel.application.server.event.ApplicationRunningEvent;
import ru.bitel.bgbilling.kernel.application.server.event.CheckApplicationRunEvent;
import ru.bitel.bgbilling.kernel.container.managed.ServerContext;
import ru.bitel.bgbilling.kernel.event.EventListener;
import ru.bitel.bgbilling.kernel.event.EventListenerContext;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.script.server.bean.GlobalScriptInvoker;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.SetupParam;
import ru.bitel.common.Utils;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.bootstrap.Shutdown;
import ru.bitel.common.jmx.AnnotatedMBean;
import ru.bitel.common.jmx.MBeanAttribute;
import ru.bitel.common.logging.NestedContext;
import ru.bitel.common.server.benchmark.DiskBenchmark;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.common.worker.ThreadContext;
import ru.bitel.common.worker.ThreadContextFactory;
import ru.bitel.common.worker.WorkerThreadFactory;

public class Application
implements CommandListener {
    public static AtomicInteger shutdownHookCount = new AtomicInteger();
    private static Application instance;
    private static final Logger log;
    private final CommandPortListener commandPortListener;
    private final ScriptEngine scriptEngine;
    private final Context env;
    private final Setup setup;
    private final List<Object[]> lifecycleList = new ArrayList<Object[]>();
    private Date startTime = new Date();
    private Set<Object> annotatedMBeans = new HashSet<Object>();

    public static Application getInstance() {
        return instance;
    }

    public Application(String fileName, CommandPortListener commandPortListener) throws Throwable {
        this.commandPortListener = commandPortListener;
        ScriptEngineManager mgr = new ScriptEngineManager();
        ScriptEngine scriptEngine = mgr.getEngineByName("JavaScript");
        if (scriptEngine == null) {
            scriptEngine = mgr.getEngineByName("beanshell");
        }
        this.scriptEngine = scriptEngine;
        List<String> scriptEngineNames = scriptEngine.getFactory().getNames();
        if (scriptEngineNames.contains("nashorn") || scriptEngineNames.contains("graal.js")) {
            scriptEngine.eval("load( \"nashorn:mozilla_compat.js\" );");
        }
        Setup.setSetup(new Setup(fileName));
        instance = this;
        this.setup = Setup.getSetup();
        final int appId = SetupParam.getApplicationId(this.setup);
        if (appId <= 0) {
            throw new BGException("Parameter app.id not defined in application XML!");
        }
        EventProcessor.getInstance().addListener(new EventListener<ApplicationRunningEvent>(){

            @Override
            public void notify(ApplicationRunningEvent e, EventListenerContext ctx) {
                if (appId == e.getApplicationId()) {
                    log.error((Object)("Already running application with app.id=" + appId + "!!!"));
                    new Thread(){

                        @Override
                        public void run() {
                            System.exit(1);
                        }
                    }.start();
                }
            }
        }, ApplicationRunningEvent.class);
        EventProcessor.getInstance().publish(new CheckApplicationRunEvent(appId));
        EventProcessor.getInstance().addListener(new EventListener<CheckApplicationRunEvent>(){

            @Override
            public void notify(CheckApplicationRunEvent e, EventListenerContext ctx) {
                if (appId == e.getApplicationId()) {
                    try {
                        EventProcessor.getInstance().publish(new ApplicationRunningEvent(appId));
                    }
                    catch (Throwable ex) {
                        log.error((Object)ex.getMessage(), ex);
                    }
                }
            }
        }, CheckApplicationRunEvent.class);
        AlarmSender.initSender(this.setup);
        this.env = Setup.getEnvironment();
        Document document = XMLUtils.parseDocument(new InputSource(new FileInputStream(fileName + ".xml")), true);
        this.application(document.getDocumentElement());
        commandPortListener.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void application(Element element) throws Throwable {
        String context = null;
        if ("application".equals(element.getNodeName())) {
            Shutdown.addShutdownHook(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        String ctx;
                        Lifecycle lifecycle;
                        ArrayList lifecycleList = new ArrayList(Application.this.lifecycleList);
                        Collections.reverse(lifecycleList);
                        for (Object[] o : lifecycleList) {
                            lifecycle = (Lifecycle)o[0];
                            ctx = (String)o[1];
                            if (ctx != null && ctx.trim().length() > 0) {
                                try {
                                    NestedContext.push(ctx);
                                    log.info((Object)("Stopping " + lifecycle));
                                    lifecycle.stop();
                                    continue;
                                }
                                finally {
                                    NestedContext.pop();
                                    continue;
                                }
                            }
                            log.info((Object)("Stopping " + lifecycle));
                            lifecycle.stop();
                        }
                        for (Object[] o : lifecycleList) {
                            if (!(o[0] instanceof ExtendedLifecycle)) continue;
                            lifecycle = (ExtendedLifecycle)o[0];
                            ctx = (String)o[1];
                            if (ctx != null && ctx.trim().length() > 0) {
                                try {
                                    NestedContext.push(ctx);
                                    log.info((Object)("Destroying " + lifecycle));
                                    lifecycle.destroy();
                                    continue;
                                }
                                finally {
                                    NestedContext.pop();
                                    continue;
                                }
                            }
                            log.info((Object)("Destroying " + lifecycle));
                            lifecycle.destroy();
                        }
                    }
                    catch (Throwable e) {
                        log.error((Object)e.getMessage(), e);
                    }
                }
            });
            this.env.bind("application", (Object)this);
            this.scriptEngine.put("setup", this.setup);
            context = element.getAttribute("context");
            if (context != null && context.length() > 0) {
                NestedContext.push(context);
            }
            this.processChildren(element, context);
            if (this.lifecycleList.size() > 0) {
                ServerContext serverContext = new ServerContext(this.setup, ConnectionSet.newInstance(this.setup, true), SetupParam.getModuleId(this.setup), 0);
                Object parent = ThreadContext.get();
                serverContext.init();
                ThreadContext.set(serverContext);
                try {
                    String ctx;
                    Lifecycle lifecycle;
                    for (Object[] o : this.lifecycleList) {
                        if (!(o[0] instanceof ExtendedLifecycle)) continue;
                        lifecycle = (ExtendedLifecycle)o[0];
                        ctx = (String)o[1];
                        if (ctx != null && ctx.trim().length() > 0) {
                            try {
                                NestedContext.push(ctx);
                                log.info((Object)("Init " + lifecycle));
                                lifecycle.init();
                                log.info((Object)("Inited " + lifecycle));
                                this.findMBeans(lifecycle, true);
                                continue;
                            }
                            finally {
                                NestedContext.pop();
                                continue;
                            }
                        }
                        log.info((Object)("Init " + lifecycle));
                        lifecycle.init();
                        log.info((Object)("Inited " + lifecycle));
                    }
                    try {
                        serverContext.getConnectionSet().commit();
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    try {
                        serverContext.commit();
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    for (Object[] o : this.lifecycleList) {
                        lifecycle = (Lifecycle)o[0];
                        ctx = (String)o[1];
                        if (ctx != null && ctx.trim().length() > 0) {
                            try {
                                NestedContext.push(ctx);
                                log.info((Object)("Starting " + lifecycle));
                                lifecycle.start();
                                log.info((Object)("Started " + lifecycle));
                                this.findMBeans(lifecycle, true);
                                continue;
                            }
                            finally {
                                NestedContext.pop();
                                continue;
                            }
                        }
                        log.info((Object)("Starting " + lifecycle));
                        lifecycle.start();
                        log.info((Object)("Started " + lifecycle));
                    }
                    try {
                        serverContext.getConnectionSet().commit();
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                    try {
                        serverContext.commit();
                    }
                    catch (Exception ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
                finally {
                    serverContext.destroy();
                    ThreadContext.set(parent);
                }
            }
            this.annotatedMBeans.clear();
        }
    }

    private void process(Element element, String context) throws Throwable {
        block11: {
            try {
                String threadContextFactoryName;
                if ("context".equals(element.getNodeName())) {
                    context = element.getAttribute("name");
                    NestedContext.push(context);
                    try {
                        this.processChildren(element, context);
                        break block11;
                    }
                    finally {
                        NestedContext.pop();
                    }
                }
                if ("bean".equals(element.getNodeName())) {
                    this.processBean(element);
                    break block11;
                }
                if (!"scheduledExecutorService".equals(element.getNodeName())) break block11;
                String name = element.getAttribute("name");
                String nestedContext = element.getAttribute("context");
                int corePoolSize = Utils.parseInt(element.getAttribute("corePoolSize"), 1);
                if (nestedContext != null && nestedContext.length() > 0) {
                    context = nestedContext;
                }
                if (Utils.isBlankString(threadContextFactoryName = element.getAttribute("threadContextFactory"))) {
                    threadContextFactoryName = "threadContextFactory";
                }
                ThreadContextFactory threadContextFactory = null;
                try {
                    threadContextFactory = (ThreadContextFactory)this.env.lookup(threadContextFactoryName);
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                ScheduledExecutorService threadPool = Executors.newScheduledThreadPool(corePoolSize, new WorkerThreadFactory(name, context, threadContextFactory));
                this.scriptEngine.put(name, threadPool);
            }
            catch (Throwable e) {
                System.err.println("Error on node " + element.getAttribute("name"));
                throw e;
            }
        }
    }

    private void findMBeans(Object o, boolean deep) {
        try {
            for (Field f : o.getClass().getDeclaredFields()) {
                boolean a2 = f.isAccessible();
                if (!a2) {
                    f.setAccessible(true);
                }
                Object o1 = f.get(o);
                f.setAccessible(a2);
                if (o1 == null || o1.getClass().isPrimitive()) continue;
                if (!this.annotatedMBeans.contains(o1)) {
                    this.annotatedMBeans.add(o1);
                    AnnotatedMBean.register(o1);
                }
                if (!deep) continue;
                this.findMBeans(o1, false);
            }
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    private void processBean(Element element) throws Throwable {
        ArrayList old;
        String text;
        ArrayList<Object> params;
        Annotation constructorProperties;
        Object o;
        String factoryMethod;
        Element constructorEl;
        Class<?> clazz = null;
        String className = element.getAttribute("class");
        if (Utils.isBlankString(className)) {
            className = String.class.getCanonicalName();
        }
        clazz = Class.forName(className);
        if (this.scriptEngine.getFactory().getNames().contains("javascript")) {
            this.scriptEngine.eval("importPackage(Packages." + clazz.getPackage().getName() + ");");
            if (clazz.getSuperclass() != null && !Object.class.equals(clazz.getSuperclass())) {
                this.scriptEngine.eval("importPackage(Packages." + clazz.getSuperclass().getPackage().getName() + ");");
            }
        } else {
            this.scriptEngine.eval("import " + clazz.getPackage().getName() + ".*;");
            if (clazz.getSuperclass() != null && !Object.class.equals(clazz.getSuperclass())) {
                this.scriptEngine.eval("import " + clazz.getSuperclass().getPackage().getName() + ".*;");
            }
        }
        String name = element.getAttribute("name");
        Object bean = null;
        String stringValue = element.getAttribute("value");
        if (stringValue != null && stringValue.trim().length() > 0) {
            bean = stringValue;
        }
        Map<String, Object> properties = this.params((constructorEl = XMLUtils.selectElement(element, "constructor")) != null ? constructorEl : element);
        if (constructorEl != null && (factoryMethod = constructorEl.getAttribute("factoryMethod")) != null && (factoryMethod = factoryMethod.trim()).length() > 0) {
            Method constructor;
            int n;
            ArrayList params2 = new ArrayList();
            Method[] methodArray = clazz.getMethods();
            int n2 = methodArray.length;
            for (n = 0; n < n2; ++n) {
                constructor = methodArray[n];
                MethodProperties constructorProperties2 = constructor.getAnnotation(MethodProperties.class);
                if (constructorProperties2 == null) continue;
                for (String p : constructorProperties2.value()) {
                    o = properties.get(p);
                    if (o == null) {
                        try {
                            o = this.env.lookup(p);
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                    }
                    params2.add(o);
                }
                if (constructor.getParameterTypes().length != params2.size() || !this.checkConstructor(constructor.getParameterTypes(), params2)) continue;
                bean = constructor.invoke(null, params2.toArray());
            }
            if (bean == null) {
                params2.clear();
                methodArray = clazz.getMethods();
                n2 = methodArray.length;
                for (n = 0; n < n2; ++n) {
                    constructor = methodArray[n];
                    if (!Modifier.isStatic(constructor.getModifiers()) || constructor.getParameterTypes().length != params2.size() || !this.checkConstructor(constructor.getParameterTypes(), params2)) continue;
                    bean = constructor.invoke(null, params2.toArray());
                }
            }
        }
        for (Constructor<?> constructor : clazz.getConstructors()) {
            constructorProperties = constructor.getAnnotation(ConstructorProperties.class);
            if (constructorProperties == null) continue;
            params = new ArrayList<Object>();
            for (String p : constructorProperties.value()) {
                o = properties.get(p);
                if (o == null) {
                    try {
                        o = this.env.lookup(p);
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                }
                params.add(o);
            }
            if (constructor.getParameterTypes().length != params.size() || !this.checkConstructor(constructor.getParameterTypes(), params)) continue;
            bean = constructor.newInstance(params.toArray());
        }
        if (bean == null) {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                constructorProperties = constructor.getAnnotation(MethodProperties.class);
                if (constructorProperties == null) continue;
                params = new ArrayList();
                for (String p : constructorProperties.value()) {
                    o = properties.get(p);
                    if (o == null) {
                        try {
                            o = this.env.lookup(p);
                        }
                        catch (NamingException namingException) {
                            // empty catch block
                        }
                    }
                    params.add(o);
                }
                if (constructor.getParameterTypes().length != params.size() || !this.checkConstructor(constructor.getParameterTypes(), params)) continue;
                bean = constructor.newInstance(params.toArray());
            }
        }
        if ((text = XMLUtils.selectText(element, "text()")) != null) {
            text = text.trim();
        }
        if (bean == null && constructorEl != null || text != null && text.length() > 0) {
            ArrayList<Object> params3 = new ArrayList<Object>();
            if (constructorEl != null) {
                Map<String, Object> paramMap = this.params(constructorEl);
                for (Object o2 : paramMap.values()) {
                    params3.add(o2);
                }
            } else if (text.startsWith("setup#")) {
                text = text.substring(6);
                text = "setup.get( \"" + text + "\", null )";
                params3.add(this.scriptEngine.eval(text));
            } else {
                params3.add(this.scriptEngine.eval(text));
            }
            for (Constructor<?> constructor : clazz.getConstructors()) {
                if (constructor.getParameterTypes().length != params3.size() || !this.checkConstructor(constructor.getParameterTypes(), params3)) continue;
                bean = constructor.newInstance(params3.toArray());
            }
        }
        if (bean == null) {
            bean = clazz.newInstance();
        }
        if (bean != null) {
            for (Element invoke : XMLUtils.selectElements(element, "invoke")) {
                String method = invoke.getAttribute("method");
                if (method == null || method.length() <= 0) continue;
                this.scriptEngine.put("bean", bean);
                this.scriptEngine.eval("bean." + method + "();");
                this.scriptEngine.put("bean", null);
            }
            if (bean instanceof CommandListener && this.commandPortListener != null) {
                this.commandPortListener.addListener((CommandListener)bean);
            }
            if (bean instanceof Lifecycle) {
                String context = NestedContext.get();
                this.lifecycleList.add(new Object[]{(Lifecycle)bean, context});
            } else {
                this.findMBeans(bean, true);
            }
        }
        if ((old = this.scriptEngine.get(name)) != null) {
            if (!(old instanceof List)) {
                ArrayList params4 = new ArrayList();
                params4.add(old);
                old = params4;
                this.env.unbind(name);
                this.scriptEngine.put(name, old);
                this.env.bind(name, old);
            }
            ((List)old).add(bean);
        } else {
            this.scriptEngine.put(name, bean);
            this.env.bind(name, bean);
        }
        if (!this.annotatedMBeans.contains(bean)) {
            this.annotatedMBeans.add(bean);
            AnnotatedMBean.register(bean);
        }
    }

    private boolean checkConstructor(Class<?>[] parameterTypes, List<Object> params) {
        int i;
        int size = parameterTypes.length;
        for (i = 0; i < size && i < params.size(); ++i) {
            if (params.get(i) == null || parameterTypes[i].isAssignableFrom(params.get(i).getClass()) || params.get(i) instanceof Number && (Integer.TYPE.equals(parameterTypes[i]) || Long.TYPE.equals(parameterTypes[i])) || params.get(i) instanceof Boolean && Boolean.TYPE.equals(parameterTypes[i]) || params.get(i).getClass().equals(String.class)) continue;
            System.err.println("Incorrect parameter: " + i);
            return false;
        }
        size = parameterTypes.length;
        for (i = 0; i < size; ++i) {
            if (params.get(i) != null && (!(params.get(i) instanceof String) && !(params.get(i) instanceof Number) || parameterTypes[i].isAssignableFrom(params.get(i).getClass()))) continue;
            params.set(i, Utils.convert(params.get(i), parameterTypes[i]));
        }
        return true;
    }

    private Map<String, Object> params(Element element) throws ScriptException, XPathExpressionException, DOMException {
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        if (element != null) {
            for (Element param : XMLUtils.selectElements(element, "param")) {
                String beanName = param.getAttribute("name");
                String value = param.getAttribute("value");
                String text = param.getTextContent().trim();
                if (value != null && value.length() > 0) {
                    params.put(beanName, value);
                    continue;
                }
                if (text.startsWith("setup#")) {
                    text = text.substring(6);
                    text = "setup.get( \"" + text + "\", null )";
                    params.put(beanName, this.scriptEngine.eval(text));
                    continue;
                }
                params.put(beanName, this.scriptEngine.eval(text));
            }
        }
        return params;
    }

    private void processChildren(Element element, String context) throws Throwable {
        NodeList children = element.getChildNodes();
        int size = children.getLength();
        for (int i = 0; i < size; ++i) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) continue;
            this.process((Element)node, context);
        }
    }

    public CommandPortListener getCommandPortListener() {
        return this.commandPortListener;
    }

    public static void exit() {
        System.exit(0);
    }

    public static void main(String[] args) throws FileNotFoundException, XPathExpressionException, IllegalArgumentException, ScriptException, InstantiationException, IllegalAccessException, InvocationTargetException, NamingException {
        int adminPort;
        if (args.length == 0) {
            System.err.println("Error: null arguments. Exit...");
            System.exit(-1);
        }
        if ((adminPort = Utils.parseInt(System.getProperty("admin.port"), -1)) <= 0) {
            System.err.println("Error: incorrect admin.port. Exit...");
            System.exit(-2);
        }
        try {
            String name = args[0];
            if (args.length > 1) {
                String[] cmd = Arrays.copyOfRange(args, 1, args.length);
                CommandPortListener.sendCommand("127.0.0.1", adminPort, cmd);
            } else {
                new Application(name, new CommandPortListener(null, adminPort));
            }
        }
        catch (Throwable e) {
            try {
                log.fatal((Object)("Fatal error, exit: " + e.getMessage()));
                log.fatal((Object)e.getMessage(), e);
                log.fatal((Object)"Shutdown with error");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            e.printStackTrace();
            System.exit(-1);
        }
    }

    @Override
    @MBeanAttribute
    public String getCommandsHelp() {
        return "status - show Application status\ngc - call garbage collector\n";
    }

    @Override
    public String executeCommand(String cmd, String param) {
        StringBuilder result = new StringBuilder();
        if ("status".equals(cmd)) {
            result.append("\n");
            result.append(ServerUtils.uptimeStatus(this.startTime));
            result.append("\n");
            result.append(Utils.memoryStatus());
            result.append("\n");
            result.append("Trees in cache: ");
            result.append(TariffTreesCache.getCache().getCacheStatus());
            result.append("\n");
            result.append(this.setup.getPoolStatus());
        } else if ("gc".equals(cmd)) {
            log.info((Object)"GC called");
            System.gc();
            result.append("GC called");
        }
        return result.toString();
    }

    public static String executeCommonCommand(String command) {
        String params = "";
        int pos = command.indexOf(" ");
        if (pos > 0) {
            params = command.substring(pos + 1, command.length());
            command = command.substring(0, pos);
        }
        return Application.executeCommonCommand(command, params);
    }

    public static String executeCommonCommand(String cmd, final String param) {
        if ("diskBenchmark".equals(cmd)) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        PrintStream ps = new PrintStream((OutputStream)out, true, "UTF-8");
                        DiskBenchmark.execute(param.split("\\s*"), ps);
                        ps.flush();
                        String result = out.toString("UTF-8");
                        log.info((Object)("Disk benchmark:\n" + result));
                    }
                    catch (UnsupportedEncodingException ex) {
                        log.error((Object)ex.getMessage(), (Throwable)ex);
                    }
                }
            }).start();
            return "Disk benchmark started. Look result in log.";
        }
        if ("diskBenchmarkSync".equals(cmd)) {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintStream ps = new PrintStream((OutputStream)out, true, "UTF-8");
                DiskBenchmark.execute(param.split("\\s*"), ps);
                ps.flush();
                String result = out.toString("UTF-8");
                log.info((Object)("Disk benchmark:\n" + result));
                return result;
            }
            catch (UnsupportedEncodingException ex) {
                log.error((Object)ex.getMessage(), (Throwable)ex);
            }
        } else {
            if ("mbeanGet".equals(cmd)) {
                String[] params = param.split("\\s+");
                try {
                    return AnnotatedMBean.mbeanGet(params[0], params[1]);
                }
                catch (Exception e) {
                    return Application.exceptionToString(e);
                }
            }
            if ("mbeanSet".equals(cmd)) {
                String[] params = param.split("\\s+");
                try {
                    return AnnotatedMBean.mbeanSet(params[0], params[1], params[2]);
                }
                catch (Exception e) {
                    return Application.exceptionToString(e);
                }
            }
            if ("mbeanQuery".equals(cmd)) {
                try {
                    return AnnotatedMBean.mbeanQuery(param);
                }
                catch (Exception e) {
                    return Application.exceptionToString(e);
                }
            }
            if ("mbeanInvoke".equals(cmd)) {
                String[] params = param.split("\\s+");
                try {
                    return AnnotatedMBean.mbeanInvoke(params[0], params[1]);
                }
                catch (Exception e) {
                    return Application.exceptionToString(e);
                }
            }
            if ("stackTrace".equals(cmd)) {
                try {
                    StringBuilder sb = new StringBuilder();
                    AlarmSender.dumpStack(sb);
                    String result = sb.toString();
                    log.info((Object)"stackTrace");
                    log.info((Object)result);
                    return result;
                }
                catch (Exception e) {
                    return Application.exceptionToString(e);
                }
            }
            if ("sysvar".equals(cmd)) {
                return Utils.getSystemVariables();
            }
            if ("javavar".equals(cmd)) {
                return Utils.getJavaProperties();
            }
            if ("dynClassRun".equals(cmd)) {
                try {
                    GlobalScriptInvoker.invoke(param);
                }
                catch (Exception e) {
                    return Application.exceptionToString(e);
                }
                return "Ok";
            }
        }
        return null;
    }

    private static String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    static {
        log = Logger.getLogger(Application.class);
    }
}

