/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.kernel.admin.server.errorlog;

import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Set;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.DefaultAlarmTask;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class DatabaseCheckTask
extends DefaultAlarmTask {
    private long lastSlaveCheck = 0L;
    private static final long SLAVE_CHECK_INTERVAL = 10000L;

    @Override
    public void doTask() {
        long now = System.currentTimeMillis();
        if (now - this.lastSlaveCheck > 10000L) {
            this.checkForWarnings();
            this.checkForDisable();
            this.lastSlaveCheck = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForWarnings() {
        int secondForAlarm = this.setup.getInt("slave.alarm.second.behind.master", -1);
        if (secondForAlarm >= 0) {
            Set<String> slaveBaseIds = this.setup.getSlaveBaseId();
            for (String slaveId : slaveBaseIds) {
                Connection conSlave = this.setup.getSlaveConnectionFromPool(slaveId);
                if (conSlave == null) continue;
                try {
                    String query = "SHOW SLAVE STATUS";
                    PreparedStatement ps = conSlave.prepareStatement(query);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        long time;
                        String key;
                        if (!this.checkSecondsNull(slaveId, rs, false)) continue;
                        int secondBehind = rs.getInt("Seconds_Behind_Master");
                        if (Setup.getSetup().isReplicationNotBehindMaster(slaveId) && secondBehind > secondForAlarm && AlarmSender.needAlarmSend(key = "slave.behind", time = System.currentTimeMillis(), 60000L)) {
                            StringBuilder sb = new StringBuilder(100);
                            sb.append("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043e\u0441\u0442\u0430\u0432\u0430\u043d\u0438\u0435 Slave \u0411\u0414 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c  '").append(slaveId).append("' \u043d\u0430 ").append(secondBehind).append(" \u0441\u0435\u043a. \u043e\u0442 Master \u0411\u0414. \u0412\u0435\u043b\u0438\u0447\u0438\u043d\u0430 \u043e\u0442\u0441\u0442\u0430\u0432\u0430\u043d\u0438\u044f \u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0430\u0445, \u043f\u043e\u0441\u043b\u0435 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0432\u044b\u0441\u044b\u043b\u0430\u0435\u0442\u0441\u044f \u0434\u0430\u043d\u043d\u043e\u0435 \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 ").append("\u0437\u0430\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 'slave.alarm.second.behind.master'.\n");
                            DatabaseCheckTask.processList(conSlave, sb);
                            DatabaseCheckTask.innoDBStatus(conSlave, sb);
                            AlarmSender.sendAlarm(new AlarmErrorMessage(key, "\u041e\u0442\u0441\u0442\u0430\u0432\u0430\u043d\u0438\u0435 Slave \u0411\u0414", sb.toString()), time);
                        }
                    }
                    ps.close();
                }
                catch (Exception e) {
                    String key = "slave.check";
                    long time = System.currentTimeMillis();
                    if (!AlarmSender.needAlarmSend(key, time, 300000L)) continue;
                    String message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 Slave \u0411\u0414 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c '" + slaveId + "'. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u0440\u0435\u0432\u0438\u043b\u0435\u0433\u0438\u044f 'REPLICATION CLIENT' \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a Slave \u0411\u0414.";
                    AlarmSender.sendAlarm(new AlarmErrorMessage(key, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 Slave \u0411\u0414", message, e), time);
                }
                finally {
                    ServerUtils.closeConnection(conSlave);
                }
            }
        }
    }

    private static void processList(Connection con, StringBuilder sb) {
        try {
            sb.append("\nProcess list:\n");
            sb.append("id").append('\t').append("host").append('\t').append("db").append('\t').append("command").append('\t').append("time").append('\t').append("state").append('\t').append("info").append('\n');
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("SHOW PROCESSLIST");
            while (rs.next()) {
                sb.append(rs.getString("id")).append('\t').append(rs.getString("host")).append('\t').append(rs.getString("db")).append('\t').append(rs.getString("command")).append('\t').append(rs.getString("time")).append('\t').append(rs.getString("state")).append('\t').append(rs.getString("info")).append('\n');
            }
            stmt.close();
        }
        catch (Throwable e) {
            sb.append(e.getMessage());
        }
    }

    private static void innoDBStatus(Connection con, StringBuilder sb) {
        try {
            sb.append("\n\nInnoDB status:\n");
            Statement stmt = con.createStatement();
            ResultSet rs = stmt.executeQuery("SHOW ENGINE INNODB STATUS");
            while (rs.next()) {
                sb.append(rs.getString("status")).append("\n");
            }
            stmt.close();
        }
        catch (Throwable e) {
            sb.append(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForDisable() {
        int secondForDisable = this.setup.getInt("slave.disable.second.behind.master", -1);
        if (secondForDisable >= 0) {
            Set<String> slaveBaseIds = this.setup.getSlaveBaseId();
            for (String slaveId : slaveBaseIds) {
                Connection conSlave = this.setup.getSlaveConnectionFromPool(slaveId);
                if (conSlave == null) continue;
                try {
                    String query = "SHOW SLAVE STATUS";
                    PreparedStatement ps = conSlave.prepareStatement(query);
                    ResultSet rs = ps.executeQuery();
                    if (rs.next()) {
                        long time;
                        String key;
                        if (!this.checkSecondsNull(slaveId, rs, true)) continue;
                        int secondBehind = rs.getInt("Seconds_Behind_Master");
                        if (secondBehind > secondForDisable) {
                            if (Setup.getSetup().isReplicationNotBehindMaster(slaveId) && AlarmSender.needAlarmSend(key = "slave.disable", time = System.currentTimeMillis(), 60000L)) {
                                StringBuilder sb = new StringBuilder(100);
                                sb.append("\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043e\u0441\u0442\u0430\u0432\u0430\u043d\u0438\u0435 Slave \u0411\u0414 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c  '" + slaveId + "' \u043d\u0430 " + secondBehind + " \u0441\u0435\u043a. \u043e\u0442 Master \u0411\u0414! \u0412\u0441\u0435 \u0434\u0430\u043b\u044c\u043d\u0435\u0439\u0448\u0438\u0435 \u043e\u0431\u0440\u0430\u0449\u0435\u043d\u0438\u044f \u0431\u0443\u0434\u0443\u0442 \u0432\u044b\u043f\u043e\u043b\u043d\u044f\u0442\u044c\u0441\u044f \u043a Master \u0431\u0430\u0437\u0435. \u041a\u0430\u043a \u0442\u043e\u043b\u044c\u043a\u043e \u043e\u0442\u0441\u0442\u0430\u0432\u0430\u043d\u0438\u0435 \u043e\u0442 Master \u0431\u0430\u0437\u044b \u0441\u0442\u0430\u043d\u0435\u0442 \u043d\u0438\u0436\u0435 \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0433\u043e, \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u044f \u0431\u0443\u0434\u0443\u0442 \u0432\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u044b.\n\u0412\u0435\u043b\u0438\u0447\u0438\u043d\u0430 \u043e\u0442\u0441\u0442\u0430\u0432\u0430\u043d\u0438\u044f \u0432 \u0441\u0435\u043a\u0443\u043d\u0434\u0430\u0445, \u043f\u043e\u0441\u043b\u0435 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u043f\u0440\u0435\u043a\u0440\u0430\u0449\u0430\u0435\u0442\u0441\u044f \u0434\u043e\u0441\u0442\u0443\u043f \u043a Slave-\u0431\u0430\u0437\u0430\u043c \u0437\u0430\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u0435\u0440\u0435\u043c\u0435\u043d\u043d\u043e\u0439 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438 \u0441\u0435\u0440\u0432\u0435\u0440\u0430 \u0431\u0438\u043b\u043b\u0438\u043d\u0433\u0430 'slave.disable.second.behind.master'.\n");
                                DatabaseCheckTask.processList(conSlave, sb);
                                DatabaseCheckTask.innoDBStatus(conSlave, sb);
                                AlarmSender.sendAlarm(new AlarmErrorMessage(key, "\u041a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043e\u0442\u0441\u0442\u0430\u0432\u0430\u043d\u0438\u0435 Slave \u0411\u0414", sb.toString()), time);
                                Setup.getSetup().setReplicationNotBehindMaster(slaveId, false);
                            }
                        } else if (!Setup.getSetup().isReplicationNotBehindMaster(slaveId) && AlarmSender.needAlarmSend(key = "slave.enable", time = System.currentTimeMillis(), 60000L)) {
                            String message = "\u0423\u0441\u0442\u0440\u0430\u043d\u0435\u043d\u043e \u043a\u0440\u0438\u0442\u0438\u0447\u0435\u0441\u043a\u043e\u0435 \u043e\u0441\u0442\u0430\u0432\u0430\u043d\u0438\u0435 Slave \u0411\u0414 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c  '" + slaveId + "' \u043e\u0442 Master \u0411\u0414. \u0421\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u0441 \u0434\u0430\u043d\u043d\u043e\u0439 Slave \u0431\u0430\u0437\u043e\u0439 \u0432\u043d\u043e\u0432\u044c \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0435\u0442\u0441\u044f. ";
                            AlarmSender.sendAlarm(new AlarmErrorMessage(key, "\u0412\u043e\u0441\u0441\u0442\u0430\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0440\u0430\u0431\u043e\u0442\u0430 \u0441\u043e Slave \u0411\u0414", message), time);
                            Setup.getSetup().setReplicationNotBehindMaster(slaveId, true);
                        }
                    }
                    ps.close();
                }
                catch (Exception e) {
                    String key = "slave.check";
                    long time = System.currentTimeMillis();
                    if (!AlarmSender.needAlarmSend(key, time, 300000L)) continue;
                    String message = "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 Slave \u0411\u0414 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c '" + slaveId + "'. \u0412\u043e\u0437\u043c\u043e\u0436\u043d\u043e, \u043d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u0430 \u043f\u0440\u0435\u0432\u0438\u043b\u0435\u0433\u0438\u044f 'REPLICATION CLIENT' \u0434\u043e\u0441\u0442\u0443\u043f\u0430 \u043a Slave \u0411\u0414.";
                    AlarmSender.sendAlarm(new AlarmErrorMessage(key, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 Slave \u0411\u0414", message, e), time);
                }
                finally {
                    ServerUtils.closeConnection(conSlave);
                }
            }
        }
    }

    private boolean checkSecondsNull(String slaveId, ResultSet rs, boolean disable) {
        try {
            if (rs.getString("Seconds_Behind_Master") == null) {
                if (Setup.getSetup().isReplicationNotBehindMaster(slaveId)) {
                    long time;
                    String key = "unknown.slave.error";
                    if (disable) {
                        key = key + ".disable";
                    }
                    if (AlarmSender.needAlarmSend(key, time = System.currentTimeMillis(), 60000L)) {
                        String message = "\u041d\u0435\u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043f\u043e\u043b\u0443\u0447\u0438\u0442\u044c \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044e \u043e\u0431 \u043e\u0442\u0441\u0442\u0430\u0432\u0430\u043d\u0438\u0438 Slave \u0411\u0414 \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c '" + slaveId + "'. \u041e\u0442\u0441\u0442\u0430\u0432\u0430\u043d\u0438\u0435 \u0440\u0435\u043f\u043b\u0438\u043a\u0430\u0446\u0438\u0438 \u043e\u0442 Master \u0431\u0430\u0437\u044b \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u043e (NULL), \u0432\u0435\u0440\u043e\u044f\u0442\u043d\u0435\u0435 \u0432\u0441\u0435\u0433\u043e \u043f\u043e\u0442\u0435\u0440\u044f\u043d\u043e \u0441\u043e\u0435\u0434\u0438\u043d\u0435\u043d\u0438\u0435 \u043c\u0435\u0436\u0434\u0443\u0434\u0430\u043d\u043d\u043e\u0439 Slave \u0431\u0430\u0437\u043e\u0439 \u0438 Master'\u043e\u043c. ";
                        if (disable) {
                            message = message + "\n\n\u0414\u0430\u043d\u043d\u0430\u044f Slave \u0411\u0414 \u0431\u044b\u043b\u0430 \u043e\u0442\u043a\u043b\u044e\u0447\u0435\u043d\u0430!";
                            Setup.getSetup().setReplicationNotBehindMaster(slaveId, false);
                        }
                        AlarmSender.sendAlarm(new AlarmErrorMessage(key, "\u041e\u0448\u0438\u0431\u043a\u0430 \u043f\u0440\u043e\u0432\u0435\u0440\u043a\u0438 \u0441\u0442\u0430\u0442\u0443\u0441\u0430 Slave \u0411\u0414", message), time);
                    }
                }
                return false;
            }
            return true;
        }
        catch (Exception ex) {
            this.log.error((Object)ex.getMessage(), (Throwable)ex);
            return false;
        }
    }
}

