/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.tariff;

import bitel.billing.server.tariff.DefaultTariffTreeNode;
import bitel.billing.server.tariff.TariffRequest;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ru.bitel.common.Utils;

public class PrefixPartTariffTreeNode
extends DefaultTariffTreeNode {
    private Pattern pattern;
    private int dest;
    private int zone;

    @Override
    public void init(String data, int deep, int nodeID) {
        super.init(data, deep, nodeID);
        Map<String, String> dataHash = this.getDataInHash();
        String prefix = dataHash.get("prefix");
        if (prefix != null) {
            try {
                this.pattern = Pattern.compile("^(" + prefix + ")");
            }
            catch (Exception ex) {
                System.err.println("Error prefix compile: " + prefix);
            }
        }
        this.dest = Utils.parseInt(dataHash.get("dest"), 0);
        this.zone = Utils.parseInt(dataHash.get("zone"), 0);
    }

    @Override
    public void processRequest(TariffRequest request) {
        String phone = (String)request.getRequestParam("phone");
        String action = (String)request.getRequestParam("action");
        if (action != null && action.equals("reset")) {
            this.processForChilds(request);
        } else if (phone != null && this.pattern != null && !request.wasAccepted()) {
            Matcher m;
            String phoneRest = (String)request.getRequestParam("phone_rest");
            if (phoneRest == null) {
                phoneRest = phone;
            }
            if ((m = this.pattern.matcher(phoneRest)).find()) {
                String eqPart = m.group(0);
                phoneRest = phoneRest.substring(eqPart.length());
                request.setRequestParam("phone_rest", phoneRest);
                if (this.dest > 0) {
                    request.setResponseParam("dest", new Integer(this.dest));
                }
                if (this.zone > 0) {
                    request.setResponseParam("zone", new Integer(this.zone));
                }
                this.processForChilds(request);
                request.setAccepted();
            }
        }
    }
}

