/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.radius;

import bitel.billing.server.processor.LC_LimitChecker;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.util.HashMap;
import org.apache.log4j.Logger;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;

public class RadiusSetup
extends Setup {
    private static final Logger log = Logger.getLogger(RadiusSetup.class);
    private LC_LimitChecker limitChecker;
    private String _module;
    private int _mid = this.getInt("processor.mid", -1);

    public static RadiusSetup getSetup() {
        return (RadiusSetup)instance;
    }

    public RadiusSetup(String name) {
        super(name);
        if (this._mid < 0) {
            System.out.println("ERROR: No processor.mid defined!");
            System.exit(1);
        }
        this.reloadConfig();
    }

    public int getModuleId() {
        return this._mid;
    }

    public void setModule(String value) {
        this._module = value;
    }

    public String getModule() {
        return this._module;
    }

    public void setLimitChecker(LC_LimitChecker value) {
        this.limitChecker = value;
    }

    public LC_LimitChecker getLimitChecker() {
        return this.limitChecker;
    }

    public void reloadConfig() {
        Connection con = null;
        try {
            con = this.getDBConnectionFromPool();
            HashMap<String, String> data = new HashMap<String, String>();
            this.loadBundle(data);
            this.loadModuleSetup(con, 0, data);
            this.loadModuleSetup(con, this.getModuleId(), data);
            this.updateData(data);
            this.initTrashPoolsAndCreateTableOptions();
            this.throwActionEvent(new ActionEvent(this, 0, "reload"));
        }
        catch (Exception ex) {
            log.error((Object)ex.getMessage(), (Throwable)ex);
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }
}

