/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.ext;

import bitel.billing.server.ext.ExtSetup;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.apache.log4j.Logger;

public class ExtAdminSocketListener
extends Thread {
    protected final Logger log;
    protected final int port;
    protected final ExtSetup setup;
    protected final ExtAdminSocketThreadFactory factory;
    protected ServerSocket server;

    public ExtAdminSocketListener(Logger log, int port, ExtSetup setup, ExtAdminSocketThreadFactory factory) {
        this.log = log;
        this.port = port;
        this.setup = setup;
        this.factory = factory;
        this.initSocket();
        log.info((Object)("AdminSocketListener on port=" + port + " init ok."));
    }

    protected void initSocket() {
        try {
            this.server = new ServerSocket(this.port);
        }
        catch (Exception ex) {
            this.log.error((Object)("Port " + this.port + " is busy!!! [" + ex.getMessage() + "]"));
            System.exit(0);
        }
    }

    @Override
    public void run() {
        this.log.info((Object)"AdminSocketListener listen.");
        while (true) {
            try {
                while (true) {
                    Socket socket = this.server.accept();
                    this.factory.startNewAdminSocketThread(socket, this.log);
                }
            }
            catch (Exception ex) {
                this.log.error((Object)ex.getMessage());
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static interface ExtAdminSocketThreadFactory {
        public void startNewAdminSocketThread(Socket var1, Logger var2);
    }

    public static class ExtAdminSocketThread
    extends Thread {
        protected final InputStream in;
        protected final OutputStream out;
        protected final Socket socket;
        protected final Logger log;

        public ExtAdminSocketThread(Socket socket, Logger log) throws IOException {
            this.socket = socket;
            this.in = socket.getInputStream();
            this.out = socket.getOutputStream();
            this.log = log;
        }

        public InputStream getIn() {
            return this.in;
        }

        public OutputStream getOut() {
            return this.out;
        }

        public Socket getSocket() {
            return this.socket;
        }
    }
}

