/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action.web;

import bitel.billing.server.ActionConType;
import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.BalanceUtils;
import bitel.billing.server.contract.bean.Contract;
import bitel.billing.server.contract.bean.ContractManager;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.Payment;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.PaymentType;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentDao;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.PaymentTypeDao;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.system.ContractWebMessagesEvent;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

@ActionConType(value=2)
public class ActionShowBalance
extends ActionBase {
    protected int mm = -1;
    protected int yy = -1;
    protected BigDecimal summa1 = BigDecimal.ZERO;
    protected BigDecimal summa2 = BigDecimal.ZERO;
    protected BigDecimal summa3 = BigDecimal.ZERO;
    protected BigDecimal summa4 = BigDecimal.ZERO;
    protected ContractManager cm = null;
    protected Contract contract = null;
    protected List<Payment> paymentList = null;
    protected Map<Integer, PaymentType> paymentTypeMap = null;
    protected List<String[]> chargeList = new ArrayList<String[]>();
    protected List<String[]> accountList = new ArrayList<String[]>();
    protected ContractWebMessagesEvent event;

    @Override
    public void doAction() throws BGMessageException {
        List<String> messages;
        this.a();
        this.rootNode.setAttribute("status", "");
        Element dateElement = this.createElement(this.rootNode, "date");
        dateElement.setAttribute("month", String.valueOf(this.mm));
        dateElement.setAttribute("year", String.valueOf(this.yy));
        Element balance = this.createElement(this.rootNode, "balance");
        Element accounts = this.createElement(balance, "accounts");
        Element payments = this.createElement(balance, "payments");
        Element charges = this.createElement(balance, "charges");
        for (Payment payment : this.paymentList) {
            Element paymentElement = this.createElement(payments, "payment");
            paymentElement.setAttribute("title", TimeUtils.format(payment.getDate(), "dd.MM.yyyy") + " " + this.paymentTypeMap.get(payment.getTypeId()).getTitle() + (Utils.notEmptyString(payment.getComment()) ? "( ".concat(payment.getComment()).concat(" )") : ""));
            paymentElement.setAttribute("value", payment.getSum().toPlainString());
        }
        for (String[] str : this.chargeList) {
            Element charge = this.createElement(charges, "charge");
            charge.setAttribute("title", str[0]);
            charge.setAttribute("value", str[1]);
        }
        for (String[] str : this.accountList) {
            Element account = this.createElement(accounts, "account");
            account.setAttribute("title", str[0]);
            account.setAttribute("value", str[1]);
        }
        balance.setAttribute("summa1", Utils.formatBigDecimalSumm(this.summa1));
        balance.setAttribute("summa2", Utils.formatBigDecimalSumm(this.summa2));
        balance.setAttribute("summa3", Utils.formatBigDecimalSumm(this.summa3));
        balance.setAttribute("summa4", Utils.formatBigDecimalSumm(this.summa4));
        balance.setAttribute("summa5", Utils.formatBigDecimalSumm(this.summa1.add(this.summa2).subtract(this.summa3).subtract(this.summa4)));
        balance.setAttribute("limit", Utils.formatBigDecimalSumm(this.contract.getBalanceLimit()));
        if (this.cm.getSubContracts(this.cid, 1).size() > 0) {
            this.rootNode.setAttribute("has_independent_subs", "1");
        }
        if ((messages = this.event.getMessages()).size() > 0) {
            Element messagesEl = this.createElement(this.rootNode, "messages");
            for (String message : messages) {
                Element messageEl = this.createElement(messagesEl, "message");
                messageEl.setAttribute("text", message);
            }
        }
    }

    protected void a() throws BGMessageException {
        GregorianCalendar nowDate = new GregorianCalendar();
        this.mm = this.getIntParameter("month", nowDate.get(2) + 1);
        this.yy = this.getIntParameter("year", nowDate.get(1));
        this.cm = new ContractManager(this.con);
        this.contract = this.cm.getContractById(this.cid);
        ArrayList<Integer> cids = new ArrayList<Integer>();
        cids.add(this.cid);
        if (Utils.notBlankString(this.contract.getDependSubList())) {
            cids.addAll(Utils.toIntegerList(this.contract.getDependSubList()));
        }
        try (BalanceUtils balanceUtils = new BalanceUtils(this.con);){
            BigDecimal value;
            String[] str;
            Period period = new Period(this.yy, this.mm - 1, 1, 32);
            if (!this.contract.isDependSub()) {
                this.summa1 = balanceUtils.getBalanceSumma1(period.getDateFrom(), this.cid);
            }
            this.paymentList = new PaymentDao(this.con).getPaymentList(cids, period, null);
            PaymentTypeDao paymentTypeManager = new PaymentTypeDao(this.con);
            ArrayList<Integer> paymentTypeIds = new ArrayList<Integer>();
            for (Payment payment : this.paymentList) {
                int typeId = payment.getTypeId();
                if (!paymentTypeIds.contains(typeId)) {
                    paymentTypeIds.add(typeId);
                }
                this.summa2 = this.summa2.add(payment.getSum());
            }
            this.paymentTypeMap = paymentTypeManager.getTypeMapByIds(paymentTypeIds);
            String query = "SELECT t2.title, t1.summa, t1.dt, t1.comment FROM contract_charge AS t1 LEFT JOIN contract_charge_types AS t2 ON t1.pt=t2.id WHERE t1.cid IN ( " + Utils.toString(cids) + " ) AND t1.dt>=? AND t1.dt<? ORDER BY t1.dt";
            PreparedStatement ps = this.con.prepareStatement(query);
            ps.setDate(1, TimeUtils.convertDateToSqlDate(period.getDateFrom()));
            ps.setDate(2, TimeUtils.convertDateToSqlDate(TimeUtils.getNextDay(period.getDateTo())));
            ResultSet rs = ps.executeQuery();
            this.chargeList = new ArrayList<String[]>();
            while (rs.next()) {
                str = new String[2];
                value = rs.getBigDecimal(2);
                str[0] = this.format(rs.getString(1), rs.getDate(3), rs.getString(4));
                str[1] = value + "";
                this.chargeList.add(str);
                this.summa4 = this.summa4.add(value);
            }
            rs.close();
            ps.close();
            query = "SELECT t2.title, ROUND(t1.summa,2) FROM contract_account AS t1 LEFT JOIN service AS t2 ON t1.sid=t2.id WHERE cid IN ( " + Utils.toString(cids) + " ) AND mm=? AND yy=?";
            ps = this.con.prepareStatement(query);
            ps.setInt(1, this.mm);
            ps.setInt(2, this.yy);
            rs = ps.executeQuery();
            this.accountList = new ArrayList<String[]>();
            while (rs.next()) {
                str = new String[2];
                value = rs.getBigDecimal(2);
                String title = rs.getString(1);
                str[0] = title == null ? "?" : title;
                str[1] = String.valueOf(value);
                this.accountList.add(str);
                this.summa3 = this.summa3.add(value);
            }
            rs.close();
            ps.close();
            this.event = new ContractWebMessagesEvent(this.cid);
            EventProcessor.getInstance().request(this.event);
        }
        catch (Exception e) {
            throw new BGMessageException(e.getLocalizedMessage());
        }
    }

    private String format(String title, Date date, String comment) {
        StringBuilder sb = new StringBuilder();
        sb.append(TimeUtils.format((java.util.Date)date, "dd.MM.yyyy"));
        sb.append(' ');
        sb.append(title == null ? "?" : title);
        if (!Utils.isEmptyString(comment)) {
            sb.append(" (");
            sb.append(comment);
            sb.append(')');
        }
        return sb.toString();
    }
}

