/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.base.ActionBase;
import bitel.billing.server.contract.bean.ContractPatternManager;
import java.sql.SQLException;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.common.BGIllegalArgumentException;
import ru.bitel.bgbilling.common.BGMessageException;
import ru.bitel.bgbilling.kernel.contract.api.common.bean.Contract;
import ru.bitel.bgbilling.kernel.contract.api.common.event.ContractModifiedEvent;
import ru.bitel.bgbilling.kernel.contract.api.server.bean.ContractDao;
import ru.bitel.common.Utils;

public class ActionUpdateContractTitleAndComment
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        int contractId = this.getIntParameter("cid", -1);
        String title = this.getParameter("title");
        String comment = this.getParameter("comment");
        String patid = this.getParameter("patid");
        if (contractId > 0) {
            try (ContractDao contractDao = new ContractDao(this.con, this.userId);){
                if (Utils.notBlankString(title) && ContractPatternManager.isContractTitleDuplicated(title.trim(), false, contractId, this.con)) {
                    throw new BGMessageException("\u0414\u043e\u0433\u043e\u0432\u043e\u0440 \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u0435\u0442!");
                }
                Contract contract = (Contract)contractDao.get(contractId);
                ContractPatternManager.removeContractTitleFromLastTitles(contract.getTitle());
                if (title != null) {
                    contract.setTitle(title.trim());
                }
                if (comment != null) {
                    contract.setComment(comment.trim());
                }
                if (patid != null) {
                    contract.setTitlePatternId(Utils.parseInt(patid, 0));
                }
                contractDao.update(contract);
            }
        } else {
            throw new BGIllegalArgumentException();
        }
        this.context.publishAfterCommit(new ContractModifiedEvent(this.userId, contractId));
    }
}

