/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.contract.action;

import bitel.billing.server.contract.action.ActionContractBalanceBase;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.List;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.contract.balance.common.bean.ContractBalance;
import ru.bitel.bgbilling.kernel.contract.balance.server.bean.BalanceDao;
import ru.bitel.common.TimeUtils;
import ru.bitel.common.Utils;
import ru.bitel.common.model.Period;

public class ActionContractBalanceGeneral
extends ActionContractBalanceBase {
    @Override
    public void doAction() throws SQLException, BGException {
        String date1 = this.getParameter("date1");
        String date2 = this.getParameter("date2");
        this.balance(TimeUtils.parseCalendar(date1, "dd.MM.yyyy"), TimeUtils.parseCalendar(date2, "dd.MM.yyyy"));
    }

    protected void balance(Calendar d1, Calendar d2) throws SQLException {
        Element table = this.createElement(this.rootNode, "table");
        Element data = this.createElement(table, "data");
        BalanceDao balanceDao = new BalanceDao(this.con);
        List<ContractBalance> list = balanceDao.getContractBalanceList(this.cid, new Period(d1.getTime(), d2.getTime()));
        for (ContractBalance balance : list) {
            int mm = balance.getMonth() - 1;
            String date = (mm >= 0 && mm < TimeUtils.monthNames.length ? TimeUtils.monthNames[mm] : "-") + " " + balance.getYear();
            Element row = this.createElement(data, "row");
            row.setAttribute("month", date);
            row.setAttribute("input_balance", Utils.formatBigDecimalSumm(balance.getIncomingSaldo()));
            row.setAttribute("charge", Utils.formatBigDecimalSumm(balance.getCharges()));
            row.setAttribute("account", Utils.formatBigDecimalSumm(balance.getAccounts()));
            row.setAttribute("payment", Utils.formatBigDecimalSumm(balance.getPayments()));
            row.setAttribute("output_balance", Utils.formatBigDecimalSumm(balance.toBalance()));
        }
        table.setAttribute("summa1", Utils.formatBigDecimalSumm(list.size() > 0 ? list.get(list.size() - 1).getIncomingSaldo() : BigDecimal.ZERO));
        table.setAttribute("summa2", Utils.formatBigDecimalSumm(list.size() > 0 ? list.get(list.size() - 1).getCharges() : BigDecimal.ZERO));
        table.setAttribute("summa3", Utils.formatBigDecimalSumm(list.size() > 0 ? list.get(list.size() - 1).getAccounts() : BigDecimal.ZERO));
        table.setAttribute("summa4", Utils.formatBigDecimalSumm(list.size() > 0 ? list.get(list.size() - 1).getPayments() : BigDecimal.ZERO));
        table.setAttribute("summa5", Utils.formatBigDecimalSumm(list.size() > 0 ? list.get(list.size() - 1).toBalance() : BigDecimal.ZERO));
    }
}

