/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server.admin.action;

import bitel.billing.server.admin.action.base.ActionBase;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.w3c.dom.Element;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.common.Utils;

public class ActionPairsFromTable
extends ActionBase {
    @Override
    public void doAction() throws SQLException, BGException {
        String table = this.getParameter("table");
        if (this.mid > 0) {
            table = table + "_" + this.mid;
        }
        String title = this.getParameter("title");
        String command = this.getParameter("command", "list");
        String titleColumn = this.getParameter("title_column", "title");
        if (table != null && ServerUtils.tableExists(this.con, table)) {
            int id;
            if (command.equals("list")) {
                Element list = this.createElement(this.rootNode, "list");
                String query = "SELECT id, " + titleColumn + " FROM " + table + " ORDER BY " + titleColumn;
                ResultSet rs = this.con.prepareStatement(query).executeQuery();
                while (rs.next()) {
                    Element item = this.createElement(list, "item");
                    item.setAttribute("id", rs.getString(1));
                    item.setAttribute("value", rs.getString(2));
                }
            } else if (command.equals("add")) {
                String query = "INSERT INTO " + table + " ( title ) VALUES (?) ";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setString(1, title);
                ps.executeUpdate();
                int id2 = ServerUtils.lastInsertId(this.con);
                this.rootNode.setAttribute("id", String.valueOf(id2));
            } else if (command.equals("delete")) {
                int id3 = this.getIntParameter("id", -1);
                if (id3 > 0) {
                    String query = "DELETE FROM " + table + " WHERE id=?";
                    PreparedStatement ps = this.con.prepareStatement(query);
                    ps.setInt(1, id3);
                    ps.executeUpdate();
                }
            } else if (command.equals("rename") && (id = this.getIntParameter("id", -1)) > 0 && title != null) {
                String query = "UPDATE " + table + " SET title=? WHERE id=?";
                PreparedStatement ps = this.con.prepareStatement(query);
                ps.setString(1, title);
                ps.setInt(2, id);
                ps.executeUpdate();
            }
        } else {
            this.tariffDetail(table, command, title);
        }
        ServerUtils.prepareElementToSerialize(this.rootNode);
    }

    private boolean tariffDetail(String table, String command, String title) {
        if (table != null && table.startsWith("tariff_detail_cost_type")) {
            Element list = this.createElement(this.rootNode, "list");
            for (Map.Entry<String, String> e : this.moduleSetup.sub("tariff_detail.cost_type.").entrySet()) {
                int id = Utils.parseInt(e.getKey(), 0);
                if (id <= 0) continue;
                Element item = this.createElement(list, "item");
                item.setAttribute("id", String.valueOf(id));
                item.setAttribute("value", e.getValue());
            }
            return true;
        }
        return false;
    }
}

