/*
 * Decompiled with CFR 0.152.
 */
package bitel.billing.server;

import bitel.billing.common.VersionInfo;
import bitel.billing.server.AdminPortListener;
import bitel.billing.server.ApplicationModule;
import bitel.billing.server.MyAccessLogValve;
import bitel.billing.server.Update;
import bitel.billing.server.admin.errorlog.AlarmSender;
import bitel.billing.server.admin.errorlog.bean.AlarmErrorMessage;
import bitel.billing.server.installer.library.LibraryEventListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import javax.servlet.Servlet;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebInitParam;
import javax.servlet.annotation.WebServlet;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Valve;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.WebResourceSet;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.webresources.DirResourceSet;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.log4j.Logger;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tomcat.util.descriptor.web.ErrorPage;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.scan.StandardJarScanner;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.DatabaseCheckTask;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.LicCheckTask;
import ru.bitel.bgbilling.kernel.admin.server.errorlog.MQCheckTask;
import ru.bitel.bgbilling.kernel.base.server.servlet.DynamicExecutor;
import ru.bitel.bgbilling.kernel.dynamic.server.DynamicClassManager;
import ru.bitel.bgbilling.kernel.dynamic.server.ReadWriteClassManager;
import ru.bitel.bgbilling.kernel.event.EventProcessor;
import ru.bitel.bgbilling.kernel.event.events.ServerStartEvent;
import ru.bitel.bgbilling.kernel.event.processors.ServerEventProcessor;
import ru.bitel.bgbilling.kernel.module.common.bean.BGInstalledModule;
import ru.bitel.bgbilling.kernel.module.common.bean.BGModule;
import ru.bitel.bgbilling.kernel.module.server.ModuleCache;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginManagerServer;
import ru.bitel.bgbilling.kernel.plugin.server.BGPluginServer;
import ru.bitel.bgbilling.kernel.plugin.server.inpoint.OnDestroyServer;
import ru.bitel.bgbilling.kernel.update.server.LibInfoUtil;
import ru.bitel.bgbilling.server.api.HttpService;
import ru.bitel.bgbilling.server.util.ServerUtils;
import ru.bitel.bgbilling.server.util.Setup;
import ru.bitel.bgbilling.server.util.UserMap;
import ru.bitel.common.ParameterMap;
import ru.bitel.common.Preferences;
import ru.bitel.common.Utils;
import ru.bitel.common.logging.LoggingPrintStream;
import ru.bitel.common.logging.NestedContext;
import ru.bitel.common.sql.ConnectionSet;
import ru.bitel.oss.kernel.directories.domain.server.DomainRuntimeMap;
import ru.bitel.oss.kernel.job.server.JobScheduler;

public class Server
extends Tomcat {
    private static final Logger log = Logger.getLogger(Server.class);
    private static Setup setup;
    private StandardContext rootContext;
    public static final Date START_TIME;
    public static final String DEFAULT_CONTEXT_PATH = "/bgbilling";

    public Server() {
        NestedContext.push("server");
        LoggingPrintStream.assignToOutput();
        String catalinaHome = new File("data").getAbsolutePath().replace('\\', '/');
        catalinaHome = catalinaHome.substring(0, catalinaHome.lastIndexOf(47));
        this.setBaseDir(catalinaHome);
        Server.checkFiles(catalinaHome);
        Server.initSetup();
        new Update(setup);
        LibInfoUtil.getClientLibInfos();
        this.getEngine().setParentClassLoader(Thread.currentThread().getContextClassLoader());
        try {
            log.info((Object)"Starting BGBillingServer...");
            System.getProperties().setProperty("networkaddress.cache.ttl", "3600");
            String hostname = setup.get("server.host.name", "localhost.localdomain");
            this.getEngine().setDefaultHost(hostname);
            this.getHost().setName(hostname);
            this.getHost().setAppBase(catalinaHome + "/webroot");
            String contextPath = setup.get("context.path", DEFAULT_CONTEXT_PATH);
            this.rootContext = (StandardContext)this.addWebapp(contextPath, catalinaHome + "/webroot");
            this.rootContext.setDefaultWebXml(catalinaHome + "/data/default.web.xml");
            this.rootContext.setReloadable(false);
            this.rootContext.setWorkDir("tmp");
            this.rootContext.setUseNaming(false);
            this.rootContext.setSessionTimeout(setup.getInt("context.session.timeout", 30));
            this.rootContext.setIgnoreAnnotations(true);
            this.addResources(catalinaHome);
            ((StandardJarScanner)this.rootContext.getJarScanner()).setScanManifest(false);
            this.rootContext.getJarScanner().setJarScanFilter((type, name) -> !name.startsWith("ha-api") && !name.startsWith("jax") && !name.startsWith("morfologik") && !name.startsWith("fop") && !name.startsWith("xalan") && !name.startsWith("batik-js") && !name.startsWith("smack"));
            ParameterMap errorPages = setup.sub("server.error.");
            for (Map.Entry<String, String> entry : errorPages.entrySet()) {
                ErrorPage errorPage = new ErrorPage();
                errorPage.setErrorCode(Utils.parseInt(entry.getKey()));
                errorPage.setLocation(entry.getValue());
                this.rootContext.addErrorPage(errorPage);
            }
            this.rootContext.addValve((Valve)new MyAccessLogValve());
            this.initConnectors();
            Throwable throwable = null;
            try (ConnectionSet connectionSet = ConnectionSet.newInstance(setup, true);){
                DomainRuntimeMap.getInstance(connectionSet);
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                throw throwable2;
            }
            ServerEventProcessor serverEventProcessor = new ServerEventProcessor(setup);
            AlarmSender.initSender(setup);
            AlarmSender.registerAlarmTask(new DatabaseCheckTask());
            AlarmSender.registerAlarmTask(new LicCheckTask());
            AlarmSender.registerAlarmTask(new MQCheckTask());
            try {
                Utils.checkJava();
            }
            catch (BGException bGException) {
                AlarmSender.sendAlarm(new AlarmErrorMessage("bad.java", "\u0421\u0435\u0440\u0432\u0435\u0440: \u043d\u0435\u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u0430\u044f Java", bGException.getMessage()), System.currentTimeMillis());
            }
            if (setup.get("no.event.process", null) == null) {
                ReadWriteClassManager readWriteClassManager = new ReadWriteClassManager();
                DynamicClassManager.setInstance(readWriteClassManager);
                if (setup.getInt("dynamic.checkOnStart", 1) > 0) {
                    new Thread(() -> {
                        try {
                            Thread.sleep(50000L);
                        }
                        catch (InterruptedException e) {
                            log.error((Object)e.getMessage(), (Throwable)e);
                        }
                        manager.recompileAll();
                    }, "dyn-class-test").start();
                }
            }
            this.initKernel();
            this.initModules();
            this.initPlugins();
            serverEventProcessor.start();
            new AdminPortListener(setup, setup.getInt("port.admin", 2005));
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    Server.onServerShutdown();
                }
            });
            System.setProperty("java.protocol.handler.pkgs", "bitel.billing.common.protocol");
            System.setProperty("org.apache.catalina.startup.EXIT_ON_INIT_FAILURE", "true");
            log.info((Object)"start...");
            this.start();
            new LibraryEventListener();
            EventProcessor.getInstance().publish(new ServerStartEvent());
            JobScheduler.getInstance("reserve", 0);
            JobScheduler.getInstance("contract_period", 0);
            log.info((Object)"Start BGBillingServer OK");
        }
        catch (Exception ex) {
            log.error((Object)("HTTP server start alarm: " + ex.getMessage() + " exiting..."));
            ex.printStackTrace();
            System.exit(1);
        }
    }

    private static void onServerShutdown() {
        for (OnDestroyServer p : BGPluginManagerServer.getManager().getInvokeables(OnDestroyServer.class, false)) {
            p.onDestroyServer("server");
        }
    }

    private void initModules() {
        Connection con = setup.getDBConnectionFromPool();
        ModuleCache.removeModuleInstalledFlag(con);
        log.info((Object)"Browsing installed modules... and Creating installed modules map...");
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (BGInstalledModule module : ModuleCache.getInstance().getInstalledModulesList()) {
            VersionInfo versionInfo = VersionInfo.getVersionInfo(module.getName());
            if (versionInfo != null && versionInfo.getVersion() != null && versionInfo.getVersion().trim().length() > 0) {
                log.info((Object)(module.getName() + " v. " + versionInfo.getVersionString()));
            } else {
                log.info((Object)(module.getName() + " v." + module.getVersion()));
            }
            if (!"module".equals(module.getType())) continue;
            map2.put(module.getName(), module.getPackageServer());
            this.setServletAndFilters(module.getPackageServer() + ".servlet");
        }
        this.rootContext.getServletContext().setAttribute("installed_modules_map", map2);
        try {
            javax.naming.Context env = Setup.getEnvironment();
            for (BGModule module : ModuleCache.getInstance().getModulesList()) {
                ApplicationModule am;
                javax.naming.Context ctx = null;
                try {
                    ctx = (javax.naming.Context)env.lookup(String.valueOf(module.getId()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ctx == null) {
                    ctx = env.createSubcontext(String.valueOf(module.getId()));
                }
                if ((am = ModuleCache.getInstance().getApplicationModule(module.getName())) == null) continue;
                try {
                    am.start(con, ctx, module);
                }
                catch (BGException e) {
                    log.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        ServerUtils.closeConnection(con);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initPlugins() {
        Connection con = setup.getDBConnectionFromPool();
        try {
            BGPluginManagerServer bgPluginManagerServer = BGPluginManagerServer.getManager();
            bgPluginManagerServer.init(con, "server");
            log.info((Object)"Browsing installed plugins...");
            for (Map.Entry<String, BGPluginServer> module : bgPluginManagerServer.getPluginsMap().entrySet()) {
                VersionInfo vi = VersionInfo.getVersionInfo(module.getKey());
                if (vi != null && vi.getVersion() != null && vi.getVersion().trim().length() > 0) {
                    log.info((Object)(module.getKey() + " v. " + vi.getVersionString()));
                } else {
                    log.info((Object)(module.getKey() + " v. ???"));
                }
                this.setServletAndFilters(module.getValue().getPackServer() + ".servlet");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            ServerUtils.closeConnection(con);
        }
    }

    private static void checkFiles(String catalinaHomeDir) {
        File customCssFile = new File(catalinaHomeDir.concat(File.separator).concat("webroot").concat(File.separator).concat("custom.css"));
        if (!customCssFile.exists()) {
            try {
                customCssFile.createNewFile();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void main(String[] args) {
        Preferences setup = new Preferences("data.data");
        int adminPort = setup.getInt("port.admin", 2005);
        if (args.length > 0) {
            if (args[0].trim().equals("start")) {
                new Server();
            } else {
                Server.executeCommand(args, adminPort);
            }
        } else {
            Server.showHelp();
        }
    }

    public static void setSetup(Setup setup) {
        Server.setup = setup;
        UserMap.initUserMap(setup);
    }

    public static void initSetup() {
        if (setup != null) {
            return;
        }
        setup = new Setup("data.data");
        Setup.setSetup(setup);
        UserMap.initUserMap(setup);
    }

    public static void exit() {
        String[] cmd = new String[]{"stop"};
        Server.main(cmd);
    }

    private static void executeCommand(String[] args, int port) {
        try {
            StringBuffer command = new StringBuffer(args[0]);
            for (int i = 1; i < args.length; ++i) {
                command.append(" ");
                command.append(args[i]);
            }
            byte[] data = command.toString().getBytes("ISO-8859-1");
            DatagramPacket packet = new DatagramPacket(data, data.length);
            packet.setAddress(InetAddress.getByName("127.0.0.1"));
            packet.setPort(port);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
            byte[] buffer = new byte[1000000];
            DatagramPacket responsePacket = new DatagramPacket(buffer, buffer.length);
            socket.setSoTimeout(10000);
            socket.receive(responsePacket);
            socket.close();
            System.out.println(new String(responsePacket.getData(), 0, responsePacket.getLength(), "ISO-8859-1"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static void showHelp() {
        StringBuffer sb = new StringBuffer();
        sb.append("\nUsage: [start|stop|status|sysvar|javavar|conpool|help]");
        sb.append("\nParameters:");
        sb.append("\n\t help                       - show this help");
        sb.append("\n\t start                      - starting BGBillingServer");
        sb.append("\n\t stop                       - stopping BGBillingServer");
        sb.append("\n\t sysvar                     - show system variables");
        sb.append("\n\t javavar                    - show java properties");
        sb.append("\n\t conpool                    - show connection pool trace, need option db.trace=1 in data.properties");
        sb.append("\n\t diskBenchmark           - disk benchmark");
        sb.append("\n\nExample: server.sh start");
        sb.append("\nExample: server.sh status");
        System.out.println(sb.toString());
    }

    private void initKernel() {
        this.setServletAndFilters("ru.bitel.bgbilling.kernel.base.server.servlet");
        log.info((Object)"Add custom servlet from setup...");
        String servletKeys = setup.get("custom.servlet.keys", "");
        log.info((Object)("Custom.servlet.keys => " + servletKeys));
        for (String servletKey : Utils.toList(servletKeys)) {
            String servletPrefix = "custom.servlet." + servletKey;
            String servletClass = setup.get(servletPrefix + ".class");
            String servletMapping = setup.get(servletPrefix + ".mapping");
            log.info((Object)("Custom.servlet.class => " + servletClass));
            log.info((Object)("Custom.servlet.mapping => " + servletMapping));
            String[] servletMappings = new String[]{servletMapping};
            this.addServlet(servletClass, servletClass, servletMappings);
            for (String servletFilterKey : Utils.toList(setup.get(servletPrefix + ".filter.keys", ""))) {
                String servletFilterPrefix = servletPrefix + ".filter." + servletFilterKey;
                String filterName = setup.get(servletFilterPrefix + ".name");
                String filterClass = setup.get(servletFilterPrefix + ".class");
                HashMap<String, String> initParams = new HashMap<String, String>();
                for (String servletFilterInitParamKey : Utils.toList(setup.get(servletFilterPrefix + ".init-param.keys", ""))) {
                    String servletFilterInitParamPrefix = servletFilterPrefix + ".init-param." + servletFilterInitParamKey;
                    String paramname = setup.get(servletFilterInitParamPrefix + ".name");
                    String paramvalue = setup.get(servletFilterInitParamPrefix + ".value");
                    initParams.put(paramname, paramvalue);
                }
                this.addServletFilter(filterName, filterClass, servletMappings, initParams);
            }
        }
    }

    private void addResources(String catalinaHome) {
        StandardRoot resourceRoot = new StandardRoot((Context)this.rootContext);
        this.rootContext.setResources((WebResourceRoot)resourceRoot);
        resourceRoot.setCachingAllowed(true);
        this.rootContext.setDelegate(true);
        this.addClassesResources(catalinaHome, (WebResourceRoot)resourceRoot);
    }

    private void addClassesResources(String catalinaHome, WebResourceRoot resourceRoot) {
        File additionWebInfClasses;
        String path = "";
        try {
            URL url = ((Object)((Object)this)).getClass().getResource("Server.class");
            path = url.toURI().getSchemeSpecificPart();
        }
        catch (URISyntaxException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (path.contains("/build/classes/java/main") && (additionWebInfClasses = new File(catalinaHome + "/build/classes/java/main")).exists()) {
            DirResourceSet dirResourceSet = new DirResourceSet(resourceRoot, "/WEB-INF/classes", additionWebInfClasses.getAbsolutePath(), "/");
            resourceRoot.addPostResources((WebResourceSet)dirResourceSet);
            return;
        }
        if (path.contains("/out/production/classes") && (additionWebInfClasses = new File(catalinaHome + "/out/production/classes")).exists()) {
            DirResourceSet dirResourceSet = new DirResourceSet(resourceRoot, "/WEB-INF/classes", additionWebInfClasses.getAbsolutePath(), "/");
            resourceRoot.addPostResources((WebResourceSet)dirResourceSet);
            return;
        }
        additionWebInfClasses = new File(catalinaHome + "/classes");
        if (additionWebInfClasses.exists()) {
            DirResourceSet dirResourceSet = new DirResourceSet(resourceRoot, "/WEB-INF/classes", additionWebInfClasses.getAbsolutePath(), "/");
            resourceRoot.addPostResources((WebResourceSet)dirResourceSet);
        }
    }

    private void initConnectors() {
        log.info((Object)"Init of connectors...");
        this.getService().removeConnector(this.getConnector());
        String connectorHttp = null;
        connectorHttp = setup.get("connector.http");
        log.info((Object)("HTTP Connector: " + connectorHttp));
        if (connectorHttp != null) {
            String maxThreads = setup.get("connector.http.thread.max", "100");
            String compression = setup.get("connector.http.compression", "off");
            for (String connectorHttpItem : connectorHttp.split(",")) {
                int port;
                int pos = (connectorHttpItem = connectorHttpItem.trim()).lastIndexOf(58);
                if (pos <= -1) continue;
                String host = connectorHttpItem.substring(0, pos);
                if ("*".equals(host)) {
                    String string = host = "true".equals(System.getProperty("java.net.preferIPv4Stack")) ? "0.0.0.0" : "::";
                }
                if ((port = Utils.parseInt(connectorHttpItem.substring(pos + 1), -1)) <= 0) continue;
                log.info((Object)("Starting HTTP connector " + host + ":" + port + "..."));
                Connector connector = new Connector();
                IntrospectionUtils.setProperty((Object)connector, (String)"address", (String)host);
                connector.setPort(port);
                connector.setEnableLookups(false);
                connector.setProperty("maxThreads", maxThreads);
                connector.setProperty("compression", compression);
                connector.setProperty("compressionMinSize", "2048");
                connector.setProperty("compressableMimeType", "text/xml");
                connector.setProperty("sendReasonPhrase", "true");
                this.setCommonConnectorOptions(connector);
                this.getService().addConnector(connector);
            }
        }
        String connectorHttps = setup.get("connector.https");
        log.info((Object)("HTTPS Connector: " + connectorHttps));
        if (connectorHttps != null) {
            String connectorHttpsThreadMax = setup.get("connector.https.thread.max", "10");
            String sslEnabledProtocols = setup.get("connector.https.sslEnabledProtocols", null);
            String sslCiphers = setup.get("connector.https.ciphers", null);
            for (String connectorHttpsItem : connectorHttps.split(",")) {
                int port;
                int pos = (connectorHttpsItem = connectorHttpsItem.trim()).lastIndexOf(58);
                if (pos <= -1) continue;
                String host = connectorHttpsItem.substring(0, pos);
                if ("*".equals(host)) {
                    String string = host = "true".equals(System.getProperty("java.net.preferIPv4Stack")) ? "0.0.0.0" : "::";
                }
                if ((port = Utils.parseInt(connectorHttpsItem.substring(pos + 1), -1)) <= 0) continue;
                log.info((Object)("Starting HTTPS connector " + host + ":" + port + "..."));
                String password = setup.get("keystore.password", "bgbilling");
                String alias = setup.get("keystore.alias");
                Connector connector = new Connector();
                IntrospectionUtils.setProperty((Object)connector, (String)"address", (String)host);
                connector.setPort(port);
                connector.setEnableLookups(false);
                connector.setScheme("https");
                connector.setProperty("SSLEnabled", "true");
                connector.setProperty("maxThreads", connectorHttpsThreadMax);
                connector.setProperty("sendReasonPhrase", "true");
                SSLHostConfig sslConfig = new SSLHostConfig();
                sslConfig.setCertificateKeystoreFile(".keystore");
                sslConfig.setCertificateKeystorePassword(password);
                if (alias != null) {
                    sslConfig.setCertificateKeyAlias(alias);
                }
                if (this.checkTrustStoreNotEmpty(password)) {
                    log.info((Object)"Found public certificates in keystore. Set as truststore.");
                    sslConfig.setTruststoreFile(".keystore");
                    sslConfig.setTruststorePassword(password);
                } else {
                    log.info((Object)"Not found public certificates in keystore. Skip as truststore.");
                    sslConfig.setTruststorePassword(password);
                }
                sslConfig.setCertificateVerification("want");
                connector.addSslHostConfig(sslConfig);
                this.setCommonConnectorOptions(connector);
                if (sslEnabledProtocols != null) {
                    connector.setProperty("sslEnabledProtocols", sslEnabledProtocols);
                }
                if (sslCiphers != null) {
                    connector.setProperty("ciphers", sslCiphers);
                }
                this.getService().addConnector(connector);
            }
        }
    }

    private void setCommonConnectorOptions(Connector connector) {
        this.rootContext.setSessionCookiePath("/");
        connector.setUseBodyEncodingForURI(true);
        connector.setMaxPostSize(setup.getInt("max.post.size", 10000000));
        connector.setMaxSavePostSize(1000000);
    }

    private boolean checkTrustStoreNotEmpty(String password) {
        char[] passw = password.toCharArray();
        try {
            KeyStore store = KeyStore.getInstance("JKS");
            store.load(new FileInputStream(".keystore"), passw);
            Enumeration<String> aliases = store.aliases();
            while (aliases.hasMoreElements()) {
                String alias = aliases.nextElement();
                if (!store.isCertificateEntry(alias)) continue;
                return true;
            }
        }
        catch (FileNotFoundException store) {
        }
        catch (Exception e) {
            log.info((Object)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    public void addServletFilter(String filterName, String filterClass, String[] mappings, Map<String, String> initParams) {
        FilterDef filterDef = new FilterDef();
        filterDef.setFilterName(filterName);
        filterDef.setFilterClass(filterClass);
        for (Map.Entry<String, String> initparam : initParams.entrySet()) {
            filterDef.addInitParameter(initparam.getKey(), initparam.getValue());
        }
        this.rootContext.addFilterDef(filterDef);
        for (String mapping : mappings) {
            FilterMap filterMap = new FilterMap();
            filterMap.addURLPattern(mapping);
            filterMap.setFilterName(filterName);
            this.rootContext.addFilterMap(filterMap);
            log.info((Object)("Add mapping: " + filterClass + " to " + mapping));
        }
    }

    public void addServlet(String servletName, String servletClass, String[] mappings) {
        if (mappings != null && servletClass != null) {
            try {
                Class<?> clazz;
                Object servlet = Utils.newInstance(servletClass, Servlet.class);
                if (servlet == null && (clazz = DynamicClassManager.getInstance().loadClass(servletClass)) != null && HttpService.class.isAssignableFrom(clazz)) {
                    servlet = new DynamicExecutor(servletClass);
                }
                if (servlet != null) {
                    servletName = servletName != null ? servletName : servletClass;
                    Wrapper wrapper = this.rootContext.createWrapper();
                    wrapper.setName(servletName);
                    wrapper.setServletClass(servletClass);
                    wrapper.setServlet(servlet);
                    this.rootContext.addChild((Container)wrapper);
                    for (String mapping : mappings) {
                        this.rootContext.addServletMappingDecoded(mapping, servletName);
                        log.info((Object)("Add mapping: " + servletClass + " to " + mapping));
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)("Error while init class " + servletClass), (Throwable)e);
            }
        }
    }

    private void setServletAndFilters(String packageName) {
        for (Class<?> clazz : this.getClassList(packageName)) {
            String className = clazz.getName();
            if (clazz.isAnnotationPresent(WebServlet.class)) {
                WebServlet webServlet = clazz.getAnnotation(WebServlet.class);
                this.addServlet(webServlet.name(), className, webServlet.urlPatterns());
            }
            if (!clazz.isAnnotationPresent(WebFilter.class)) continue;
            WebFilter webFilter = clazz.getAnnotation(WebFilter.class);
            HashMap<String, String> initParams = new HashMap<String, String>();
            for (WebInitParam webInitParam : webFilter.initParams()) {
                initParams.put(webInitParam.name(), webInitParam.value());
            }
            this.addServletFilter(webFilter.filterName(), className, webFilter.urlPatterns(), initParams);
        }
    }

    private List<Class<?>> getClassList(String packageName) {
        URL url = Server.class.getResource("/" + packageName.replace(".", "/"));
        if (url != null) {
            try {
                URI uri = url.toURI();
                if ("jar".equals(uri.getScheme())) {
                    FileSystem fs = null;
                    try {
                        fs = FileSystems.getFileSystem(uri);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (fs == null) {
                        fs = FileSystems.newFileSystem(uri, Collections.emptyMap());
                    }
                    return this.getClassList2(packageName, fs.getPath("/" + packageName.replace(".", "/"), new String[0]));
                }
                if ("file".equals(uri.getScheme())) {
                    return this.getClassList2(packageName, Paths.get(uri));
                }
            }
            catch (Exception e) {
                log.error((Object)e);
                e.printStackTrace();
            }
        }
        return Collections.emptyList();
    }

    private List<Class<?>> getClassList2(String packageName, Path dirPath) throws IOException {
        ArrayList clazzs = new ArrayList();
        Files.list(dirPath).forEach(path -> {
            String fileName = path.getFileName().toString();
            String className = packageName + "." + fileName.substring(0, fileName.length() - 6);
            try {
                clazzs.add(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                log.error((Object)e);
                e.printStackTrace();
            }
        });
        return clazzs;
    }

    static {
        START_TIME = new Date();
    }
}

