/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.portlet.context;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletRequestDispatcher;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.context.TilesApplicationContextWrapper;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.portlet.context.PortletParamMap;
import org.apache.tiles.portlet.context.PortletParamValuesMap;
import org.apache.tiles.portlet.context.PortletRequestScopeMap;
import org.apache.tiles.portlet.context.PortletSessionScopeMap;
import org.apache.tiles.portlet.context.PortletTilesApplicationContext;
import org.apache.tiles.util.TilesIOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PortletTilesRequestContext
extends TilesApplicationContextWrapper
implements TilesRequestContext {
    private Map<String, String> header = null;
    private Map<String, String[]> headerValues = null;
    private PortletContext context = null;
    protected PortletRequest request = null;
    private Map<String, Object> requestScope = null;
    protected PortletResponse response = null;
    private Object[] requestObjects;
    private Map<String, Object> sessionScope = null;
    private boolean isRenderRequest;
    protected Map<String, String> param = null;
    protected Map<String, String[]> paramValues = null;

    public PortletTilesRequestContext(TilesApplicationContext applicationContext, PortletContext context, PortletRequest request, PortletResponse response) {
        super(applicationContext);
        this.context = context;
        this.initialize(request, response);
    }

    @Deprecated
    public PortletTilesRequestContext(PortletContext context, PortletRequest request, PortletResponse response) {
        super((TilesApplicationContext)new PortletTilesApplicationContext(context));
        this.context = context;
        this.initialize(request, response);
    }

    public void initialize(PortletRequest request, PortletResponse response) {
        this.request = request;
        this.response = response;
        this.isRenderRequest = false;
        if (request != null && request instanceof RenderRequest) {
            this.isRenderRequest = true;
        }
    }

    public void release() {
        this.header = null;
        this.headerValues = null;
        this.param = null;
        this.paramValues = null;
        this.requestScope = null;
        this.sessionScope = null;
        this.context = null;
        this.request = null;
        this.response = null;
    }

    public PortletRequest getRequest() {
        return this.request;
    }

    public PortletResponse getResponse() {
        return this.response;
    }

    public Map<String, String> getHeader() {
        if (this.header == null && this.request != null) {
            this.header = Collections.EMPTY_MAP;
        }
        return this.header;
    }

    public Map<String, String[]> getHeaderValues() {
        if (this.headerValues == null && this.request != null) {
            this.headerValues = Collections.EMPTY_MAP;
        }
        return this.headerValues;
    }

    public Map<String, String> getParam() {
        if (this.param == null && this.request != null) {
            this.param = new PortletParamMap(this.request);
        }
        return this.param;
    }

    public Map<String, String[]> getParamValues() {
        if (this.paramValues == null && this.request != null) {
            this.paramValues = new PortletParamValuesMap(this.request);
        }
        return this.paramValues;
    }

    public Map<String, Object> getRequestScope() {
        if (this.requestScope == null && this.request != null) {
            this.requestScope = new PortletRequestScopeMap(this.request);
        }
        return this.requestScope;
    }

    public Map<String, Object> getSessionScope() {
        if (this.sessionScope == null && this.request != null) {
            this.sessionScope = new PortletSessionScopeMap(this.request.getPortletSession());
        }
        return this.sessionScope;
    }

    public TilesApplicationContext getApplicationContext() {
        return this.getWrappedApplicationContext();
    }

    public void dispatch(String path) throws IOException {
        this.include(path);
    }

    public void include(String path) throws IOException {
        if (this.isRenderRequest) {
            try {
                PortletRequestDispatcher rd = this.context.getRequestDispatcher(path);
                if (rd == null) {
                    throw new IOException("No portlet request dispatcher returned for path '" + path + "'");
                }
                rd.include((RenderRequest)this.request, (RenderResponse)this.response);
            }
            catch (PortletException e) {
                throw new TilesIOException("PortletException while including path '" + path + "'.", (Throwable)e);
            }
        }
    }

    public OutputStream getOutputStream() throws IOException {
        return ((RenderResponse)this.response).getPortletOutputStream();
    }

    public PrintWriter getPrintWriter() throws IOException {
        return ((RenderResponse)this.response).getWriter();
    }

    public Writer getWriter() throws IOException {
        return ((RenderResponse)this.response).getWriter();
    }

    public Object[] getRequestObjects() {
        if (this.requestObjects == null) {
            this.requestObjects = new Object[2];
            this.requestObjects[0] = this.request;
            this.requestObjects[1] = this.response;
        }
        return this.requestObjects;
    }

    public Locale getRequestLocale() {
        if (this.request != null) {
            return this.request.getLocale();
        }
        return null;
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }
}

