/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.evaluator.el;

import java.util.Map;
import javax.el.ArrayELResolver;
import javax.el.BeanELResolver;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ListELResolver;
import javax.el.MapELResolver;
import javax.el.ResourceBundleELResolver;
import javax.el.ValueExpression;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.awareness.TilesApplicationContextAware;
import org.apache.tiles.context.TilesRequestContext;
import org.apache.tiles.evaluator.AbstractAttributeEvaluator;
import org.apache.tiles.evaluator.el.ELContextImpl;
import org.apache.tiles.evaluator.el.ExpressionFactoryFactory;
import org.apache.tiles.evaluator.el.TilesContextBeanELResolver;
import org.apache.tiles.evaluator.el.TilesContextELResolver;
import org.apache.tiles.evaluator.el.TomcatExpressionFactoryFactory;
import org.apache.tiles.reflect.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ELAttributeEvaluator
extends AbstractAttributeEvaluator
implements TilesApplicationContextAware {
    public static final String EXPRESSION_FACTORY_FACTORY_INIT_PARAM = "org.apache.tiles.evaluator.el.ExpressionFactoryFactory";
    protected TilesApplicationContext applicationContext;
    protected ExpressionFactory expressionFactory;
    protected ELResolver resolver;

    @Override
    public void init(Map<String, String> initParameters) {
        ExpressionFactoryFactory efFactory;
        String expressionFactoryClassName = initParameters.get(EXPRESSION_FACTORY_FACTORY_INIT_PARAM);
        if (expressionFactoryClassName != null) {
            efFactory = (ExpressionFactoryFactory)ClassUtil.instantiate((String)expressionFactoryClassName);
        } else {
            efFactory = (ExpressionFactoryFactory)ClassUtil.instantiate((String)"org.apache.tiles.evaluator.el.JspExpressionFactoryFactory", (boolean)true);
            if (efFactory == null) {
                efFactory = new TomcatExpressionFactoryFactory();
            }
        }
        if (efFactory instanceof TilesApplicationContextAware) {
            ((TilesApplicationContextAware)((Object)efFactory)).setApplicationContext(this.applicationContext);
        }
        this.expressionFactory = efFactory.getExpressionFactory();
        this.resolver = new CompositeELResolver(){
            {
                this.add((ELResolver)new TilesContextELResolver());
                this.add(new TilesContextBeanELResolver());
                this.add((ELResolver)new ArrayELResolver(false));
                this.add((ELResolver)new ListELResolver(false));
                this.add((ELResolver)new MapELResolver(false));
                this.add((ELResolver)new ResourceBundleELResolver());
                this.add((ELResolver)new BeanELResolver(false));
            }
        };
    }

    @Override
    public void setApplicationContext(TilesApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    public void setResolver(ELResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public Object evaluate(String expression, TilesRequestContext request) {
        ELContextImpl context = new ELContextImpl(this.resolver);
        context.putContext(TilesRequestContext.class, request);
        context.putContext(TilesApplicationContext.class, this.applicationContext);
        ValueExpression valueExpression = this.expressionFactory.createValueExpression((ELContext)context, expression, Object.class);
        return valueExpression.getValue((ELContext)context);
    }
}

