/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nonblocking.iobalancer;

import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.internal.networking.nonblocking.iobalancer.IOBalancer;
import com.hazelcast.logging.ILogger;
import com.hazelcast.util.EmptyStatement;
import java.util.concurrent.TimeUnit;

class IOBalancerThread
extends Thread {
    private static final String THREAD_NAME_PREFIX = "IOBalancerThread";
    private final IOBalancer ioBalancer;
    private final ILogger log;
    private final int balancerIntervalSeconds;
    private volatile boolean shutdown;

    IOBalancerThread(IOBalancer ioBalancer, int balancerIntervalSeconds, HazelcastThreadGroup threadGroup, ILogger log) {
        super(threadGroup.getInternalThreadGroup(), threadGroup.getThreadNamePrefix(THREAD_NAME_PREFIX));
        this.ioBalancer = ioBalancer;
        this.log = log;
        this.balancerIntervalSeconds = balancerIntervalSeconds;
    }

    void shutdown() {
        this.shutdown = true;
        this.interrupt();
    }

    @Override
    public void run() {
        try {
            this.log.finest("Starting IOBalancer thread");
            while (!this.shutdown) {
                this.ioBalancer.checkReadHandlers();
                this.ioBalancer.checkWriteHandlers();
                TimeUnit.SECONDS.sleep(this.balancerIntervalSeconds);
            }
        }
        catch (InterruptedException e) {
            this.log.finest("IOBalancer thread stopped");
            EmptyStatement.ignore(e);
        }
        catch (Throwable e) {
            this.log.severe("IOBalancer failed", e);
        }
    }
}

