<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:common="http://common.bitel.ru" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
<xsl:import href="layout.xsl"/>

<xsl:variable name="URL"><xsl:value-of select="$WEBEXECUTER"/>?action=Dispatch&amp;module=ru.bitel.bgbilling.plugins.dispatch&amp;mid=0&amp;operation=</xsl:variable>

<xsl:template name="head">
	<script language="javascript" type="text/javascript">
			<xsl:text disable-output-escaping="yes">
	<![CDATA[
	window.onload = function()
	{
		filterOptions();
		selChange( document.getElementById("contactType") );
	}
	
	function selChange( opt ) 
	{ 
		desc = opt.options[opt.selectedIndex].id;
		document.getElementById("hintMessage").innerHTML = desc; 
	} 
	
	function showEditor()
	{
		document.getElementById("newButton").style.visibility = 'hidden';
		document.getElementById("hiddenEditor").style.visibility = 'visible';
		selChange( document.getElementById("contactType") );
	}
	
	function hideEditor()
	{
		document.getElementById("newButton").style.visibility = 'visible';
		document.getElementById("hiddenEditor").style.visibility = 'hidden';
	}
	
	function filterOptions()
	{
		var dispatchSelect = document.getElementById("dispatchSelect");
		if( !dispatchSelect ) return;
	
		var select = document.getElementById("contacts");
		var options = select.getElementsByTagName("option");
	
		for( var i = 0; i < options.length; ++i )
		{
			options[i].selected = false;
			if( options[i].id != dispatchSelect.options[dispatchSelect.selectedIndex].id )
				options[i].style.visibility = 'hidden';
			else
				options[i].style.visibility = 'visible';
		}
	}
	
	function voiceip( json )
	{
		json
	}
	
	function sendRequest(url)
	{
		var my_JSON_object = {};
		var http_request = new XMLHttpRequest();
		http_request.open( "GET", url, true );
		http_request.onreadystatechange = function () 
		{
		  if (http_request.readyState == 4 && http_request.status == 200)
		  {
		       response = JSON.parse( http_request.responseText );
		       
		  }
		};
		http_request.send(null);
	}
	]]>
			</xsl:text>
		</script>
</xsl:template>

<xsl:template name="title">
	<xsl:choose>
		<xsl:when test="data/@action = 'Dispatch' and data/@operation = 'subscribe'">Подписка на рассылку</xsl:when>
		<xsl:when test="data/@action = 'Dispatch' and data/common:result/attributes/item[@key='subscriptions']">Мои рассылки</xsl:when>
		<xsl:when test="data/@action = 'Dispatch' and data/@operation = 'editContact'">Редактирование контакта</xsl:when>
		<xsl:otherwise>Мои контакты</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="/data">
	<xsl:call-template name="Сommon"/>
	<xsl:choose>
		<xsl:when test="common:result/attributes/item[@key='subscriptions']">
			<xsl:call-template name="Subscriptions"/>
		</xsl:when>
		<xsl:when test="@operation = 'subscribe'">
			<xsl:call-template name="EditSubscribe"/>
		</xsl:when>
		<xsl:when test="@operation = 'editContact'">
			<xsl:call-template name="EditContact"/>
		</xsl:when>
		<xsl:otherwise>
			<xsl:call-template name="Contacts"/>			
		</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template name="Сommon">
		<div>
		<xsl:call-template name="rawLinkButton">
			<xsl:with-param name="url"><xsl:value-of select="$URL"/>execute</xsl:with-param>
			<xsl:with-param name="title" select="'Мои контакты'"/>
		</xsl:call-template>
		<xsl:call-template name="rawLinkButton">
			<xsl:with-param name="url"><xsl:value-of select="$URL"/>subscriptions</xsl:with-param>
			<xsl:with-param name="title" select="'Мои рассылки'"/>
		</xsl:call-template>
	</div><br/>
</xsl:template>

<xsl:template name="Contacts">
	<table class="table800">
		<thead>
			<tr>
				<td width="160">Тип</td>
				<td>Значение</td>
				<td width="50">V</td>
				<td width="50">Х</td>
			</tr>
		</thead>
		<tbody>
			<xsl:for-each select="common:result/data/item">
				<xsl:variable name="typeId"><xsl:value-of select="contactTypeId/text()"/></xsl:variable>
				<tr>
					<td><xsl:value-of select="/data/contactTypes/data/item[@id=$typeId]/@title"/></td>
					<td><xsl:value-of select="value/text()"/></td>
					<td>
					<!--
					<xsl:call-template name="form Button">
						<xsl:with-param name="data">
							<xsl:call-template name="action"/>
							<input type="hidden" name="id">
								<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
							</input>
							<input type="hidden" name="operation" value="editContact"/>
						</xsl:with-param>
						<xsl:with-param name="title" select="'Редактировать'"/>
					</xsl:call-template>
					-->
					<form method='post' action='{$WEBEXECUTER}' style="display: inline;">
						<xsl:call-template name="action"/>
						<input type="hidden" name="id" value="{@id}"/>
						<input type="hidden" name="operation" value="editContact"/>
						<xsl:call-template name="submit">
							<xsl:with-param name="title" select="'Редактировать'"/>
						</xsl:call-template>
					</form>
					</td>
					<td>
					<!--
					<xsl:call-template name="form Button">
						<xsl:with-param name="data">
							<xsl:call-template name="action"/>
							<input type="hidden" name="id">
								<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
							</input>
							<input type="hidden" name="operation" value="removeContact"/>
						</xsl:with-param>
						<xsl:with-param name="title" select="'Удалить'"/>
					</xsl:call-template>
					-->
					<form method='post' action='{$WEBEXECUTER}' style="display: inline;">
						<xsl:call-template name="action"/>
						<input type="hidden" name="id" value="{@id}"/>
						<input type="hidden" name="operation" value="removeContact"/>
						<xsl:call-template name="submit">
							<xsl:with-param name="title" select="'Удалить'"/>
						</xsl:call-template>
					</form>
					</td>
				</tr>
			</xsl:for-each>
		</tbody>
	</table>
	<br/>
	<div>
		<xsl:call-template name="button">
			<xsl:with-param name="id">newButton</xsl:with-param>
			<xsl:with-param name="title">Новый</xsl:with-param>
			<xsl:with-param name="onclick">showEditor();</xsl:with-param>
		</xsl:call-template>
	</div>
	<div id="hiddenEditor" style="visibility: hidden;">
		<form action="{$WEBEXECUTER}" method="post">
			<xsl:call-template name="action"/>
			<input type="hidden" name="operation" value="addContact"/>
			<h4>Новый контакт</h4>
			<table>
				<tr>
					<td>Выберите тип:</td>
					<td>
						<select name="type" id="contactType" onchange="selChange(this)">
							<xsl:for-each select="contactTypes/data/item">
								<option>
									<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
									<xsl:attribute name="id"><xsl:value-of select="description/text()"/></xsl:attribute>
									<xsl:value-of select="@title"/>
								</option>
							</xsl:for-each>
						</select>
					</td>
				</tr>
				<tr>
					<td></td>
					<td id="hintMessage">
						Подсказка
					</td>
				</tr>
				<tr>
					<td>Введите значение:</td>
					<td><input name="value" type="text" width="100px"/></td>
				</tr>
				<tr class="foot">
					<td colspan="2">
						<xsl:call-template name="okCancel">
							<xsl:with-param name="title1">Создать</xsl:with-param>
							<xsl:with-param name="onclick1">submit();</xsl:with-param>
							<xsl:with-param name="onclick2">hideEditor();</xsl:with-param>
						</xsl:call-template>
					</td>
				</tr>
			</table>
		</form>
	</div>
</xsl:template>

<xsl:template name="EditContact">
<xsl:variable name="contactId"><xsl:value-of select="/data/currentContact/@id"/></xsl:variable>
<form action="{$WEBEXECUTER}" method="post">
	<xsl:call-template name="action"/>
	<input type="hidden" name="id">
		<xsl:attribute name="value"><xsl:value-of select="$contactId"/></xsl:attribute>
	</input>
	<input type="hidden" name="operation" value="updateContact"/>
	
	<h4>Редактирование контакта</h4>
	
	<xsl:variable name="typeId"><xsl:value-of select="currentContact/contactTypeId/text()"/></xsl:variable>
	<xsl:variable name="value"><xsl:value-of select="currentContact/value/text()"/></xsl:variable>
	<table>
		<tr>
			<td>Выберите тип: </td>
			<td>
				<select name="type" id="contactType" onchange="selChange(this)" onload="selChange(this)">
					<xsl:for-each select="contactTypes/data/item">
						<option>
							<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
							<xsl:attribute name="id"><xsl:value-of select="description/text()"/></xsl:attribute>
							<xsl:if test="$typeId=@id">
								<xsl:attribute name="selected"/>
							</xsl:if>
							<xsl:value-of select="@title"/>
						</option>
					</xsl:for-each>
				</select>
			</td>
		</tr>
		<tr>
			<td></td>
			<td id="hintMessage">
				Подсказка
			</td>
		</tr>
		<tr>
			<td>Введите значение:</td>
			<td>
				<input name="value" type="text" width="100px">
				<xsl:attribute name="value">
					<xsl:value-of select="$value"/>
				</xsl:attribute>
				</input>
			</td>
		</tr>
		<tr class="foot">
			<td colspan="2">
				<xsl:call-template name="button">
					<xsl:with-param name="title">Сохранить</xsl:with-param>
					<xsl:with-param name="onclick">submit();</xsl:with-param>
				</xsl:call-template>
			</td>
		</tr>
	</table>
</form>
</xsl:template>

<xsl:template name="Subscriptions">
	<table class="table800">
		<thead>
			<tr>
				<td width="160">Рассылка</td>
				<td width="200">Контакты</td>
				<td width="250">Расписание</td>
				<td width="250">Комментарий</td>
				<td width="100">V</td>
				<td width="100">Х</td>
			</tr>
		</thead>
		<tbody>
			<xsl:for-each select="common:result/data/item">
				<tr>
					<td>
						<xsl:value-of select="dispatch/@title"/>
						<xsl:if test="dispatch/personal/text() = 'true'">
							[персональная]
						</xsl:if>
					</td>
					<td>
						<xsl:for-each select="contacts">
							<xsl:value-of select="value/text()"/><br/>
						</xsl:for-each>
					</td>
					<td>
						<xsl:choose>
							<xsl:when test="dispatch/personal/text() = 'false'">
								<xsl:value-of select="dispatch/repeatTime/humanReadable/text()"/>
							</xsl:when>
							<xsl:otherwise>
								<xsl:value-of select="repeatTime/humanReadableWithoutTime/text()"/>
							</xsl:otherwise>
						</xsl:choose>
					</td>
					<td>
						<xsl:value-of select="comment/text()"/>
					</td>
					<td><!-- <xsl:call-template name="form Button">
						<xsl:with-param name="data">
							<xsl:call-template name="action"/>
							<input type="hidden" name="id">
								<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
							</input>
							<input type="hidden" name="operation" value="subscribe"/>
						</xsl:with-param>
						<xsl:with-param name="title" select="'Редактировать'"/>
					</xsl:call-template>-->
						<form method='post' action='{$WEBEXECUTER}' style="display: inline;">
							<xsl:call-template name="action"/>
							<input type="hidden" name="id" value="{@id}"/>
							<input type="hidden" name="operation" value="subscribe"/>
							<xsl:call-template name="submit">
								<xsl:with-param name="title" select="'Редактировать'"/>
							</xsl:call-template>
						</form>
					</td>
					<td><!-- <xsl:call-template name="form Button">
						<xsl:with-param name="data">
							<xsl:call-template name="action"/>
							<input type="hidden" name="id">
								<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
							</input>
							<input type="hidden" name="operation" value="unsubscribe"/>
						</xsl:with-param>
						<xsl:with-param name="title" select="'Удалить'"/>
					</xsl:call-template>-->
						<form method='post' action='{$WEBEXECUTER}' style="display: inline;">
							<xsl:call-template name="action"/>
							<input type="hidden" name="id" value="{@id}"/>
							<input type="hidden" name="operation" value="unsubscribe"/>
							<xsl:call-template name="submit">
								<xsl:with-param name="title" select="'Удалить'"/>
							</xsl:call-template>
						</form>
					</td>
				</tr>
			</xsl:for-each>
		</tbody>
	</table>
	<br/>
	<div>
		<!--
		<xsl:call-template name="form Button">
			<xsl:with-param name="data">
				<xsl:call-template name="action"/>
				<input type="hidden" name="id">
					<xsl:attribute name="value"><xsl:value-of select="0"/></xsl:attribute>
				</input>
				<input type="hidden" name="operation" value="subscribe"/>
				<select name="dispatchId">
					<xsl:for-each select="/data/dispatches/data/item">
						<option>
							<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
							<xsl:value-of select="@title"/>
						</option>
					</xsl:for-each>
				</select>
			</xsl:with-param>
			<xsl:with-param name="title" select="'Новая подписка'"/>
		</xsl:call-template>
		-->
		<form method='post' action='{$WEBEXECUTER}' style="display: inline;">
			<xsl:call-template name="action"/>
			<input type="hidden" name="id" value="0"/>
			<input type="hidden" name="operation" value="subscribe"/>
			<select name="dispatchId">
				<xsl:for-each select="/data/dispatches/data/item">
					<option value="{@id}"><xsl:value-of select="@title"/></option>
				</xsl:for-each>
			</select>
			<xsl:call-template name="submit">
				<xsl:with-param name="title" select="'Новая подписка'"/>
			</xsl:call-template>
		</form>
	</div>
</xsl:template>

<xsl:template name="EditSubscribe">
<xsl:variable name="subid"><xsl:value-of select="/data/subscription/@id"/></xsl:variable>
<div id="hiddenEditor">
	<form action="{$WEBEXECUTER}" method="post">
		<xsl:call-template name="action"/>
		<input type="hidden" name="id">
			<xsl:attribute name="value"><xsl:value-of select="$subid"/></xsl:attribute>
		</input>
		<input type="hidden" name="operation" value="subscribe"/>
		<input type="hidden" name="save" value="1"/>
		<input type="hidden" name="dispatchId">
			<xsl:attribute name="value"><xsl:value-of select="/data/currentDispatch/@id"/></xsl:attribute>
		</input>
		
		<h4>
		<xsl:choose>
			<xsl:when test="$subid='0'">Подписка на рассылку </xsl:when>
			<xsl:otherwise>Редактирование подписки </xsl:otherwise>
		</xsl:choose> "<xsl:value-of select="/data/currentDispatch/@title"/>"
		</h4>
		<div>
		Выберите контакты:<br/>
		<xsl:for-each select="/data/contacts/data/item">
			<xsl:variable name="id"><xsl:value-of select="@id"/></xsl:variable>
			<input type="checkbox">
				<xsl:attribute name="name">contact.<xsl:value-of select="$id"/></xsl:attribute>
				<xsl:if test="/data/subscription/contacts[@id=$id]">
					<xsl:attribute name="checked"/>
				</xsl:if>
				<xsl:value-of select="value/text()"/>
			</input><br/>
		</xsl:for-each>
		</div><br/>
		<xsl:if test="/data/currentDispatch/personal/text() = 'true'">
			<!-- personal dispatch data -->
			<div>
			<xsl:for-each select="/data/currentDispatch/conditions">
				<xsl:call-template name="matchCondition">
					<xsl:with-param name="class"><xsl:value-of select="@xsi:type"/></xsl:with-param>
					<xsl:with-param name="moduleId"><xsl:value-of select="moduleId/text()"/></xsl:with-param>
				</xsl:call-template>
			</xsl:for-each>
			</div><br/>
			<div>
				Дни недели (1-7): 
				<input name="days" type="text">
					<xsl:attribute name="value">
						<xsl:value-of select="subscription/repeatTime/dayOfWeekAsString/text()"/>
					</xsl:attribute>
				</input>
				<p>Дни недели, например "1-7" (каждый день), "1,2" (понедельник, вторник), в которые вам будет высылаться рассылка</p>
			</div>
		</xsl:if>
		<div>
			Ваш комментарий:<br/>
			<textarea name="comment" cols="50" rows="10">
				<xsl:value-of select="subscription/comment/text()"/>
			</textarea>
		</div><br/>
		<xsl:call-template name="button">
			<xsl:with-param name="title">Подписаться</xsl:with-param>
			<xsl:with-param name="onclick">submit();</xsl:with-param>
		</xsl:call-template>
	</form>
</div>
</xsl:template>

<xsl:template name="matchCondition">
	<xsl:param name="class"/>
	<xsl:param name="moduleId"/>
	<xsl:choose>
		<xsl:when test="$class = 'dispatchBalanceCondition'">
			<span>Укажите условия для баланса, при котором разрешать присылать рассылку</span><br/>
			<xsl:value-of select="/data/*[name()='data-kernel']/data/item"></xsl:value-of>
			<table>
				<tr>
					<td>От</td>
					<td>
						<input type="text">
							<xsl:attribute name="name">prefs.<xsl:value-of select="$moduleId"/>.from_balance</xsl:attribute>
							<xsl:attribute name="value">
								<xsl:value-of select="/data/data-kernel/data/entry[key/text()=concat($moduleId,'.from_balance')]/value/text()"/>
							</xsl:attribute>
						</input>
					</td>
				</tr>
				<tr>
					<td>До</td>
					<td>
						<input type="text">
							<xsl:attribute name="name">prefs.<xsl:value-of select="$moduleId"/>.to_balance</xsl:attribute>
							<xsl:attribute name="value">
								<xsl:value-of select="/data/data-kernel/data/entry[key/text()=concat($moduleId,'.to_balance')]/value/text()"/>
							</xsl:attribute>
						</input>
					</td>
				</tr>
			</table>
		</xsl:when>
		<xsl:when test="$class = 'voiceip'">
			<span>Укажите логин VoiceIP:</span><br/>
			<select>
				<xsl:attribute name="name">prefs.<xsl:value-of select="$moduleId"/>.voip_amount_login_id</xsl:attribute>
				<xsl:for-each select="/data/*[name()=concat('data-',$class)]/data/item">
					<option>
						<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
						<xsl:if test="/data/subscription/preferences/data/entry[key/text()=concat($moduleId,'.voip_amount_login_id')]/value/text()=@id">
							<xsl:attribute name="selected">1</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="@title"/>
					</option>
				</xsl:for-each>
			</select>
		</xsl:when>
		<xsl:when test="$class = 'inet'">
			<span>Укажите сервис Inet:</span><br/>
			<select>
				<xsl:attribute name="name">prefs.<xsl:value-of select="$moduleId"/>.inet_service_id</xsl:attribute>
				<xsl:for-each select="/data/*[name()=concat('data-',$class)]/data/item">
					<option>
						<xsl:attribute name="value"><xsl:value-of select="@id"/></xsl:attribute>
						<xsl:if test="/data/subscription/preferences/data/entry[key/text()=concat($moduleId,'.inet_service_id')]/value/text()=@id">
							<xsl:attribute name="selected">1</xsl:attribute>
						</xsl:if>
						<xsl:value-of select="concat(@deviceTitle,' / ',@typeTitle)"/>
					</option>
				</xsl:for-each>
			</select>
		</xsl:when>
	</xsl:choose>
</xsl:template>
</xsl:stylesheet>