/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.frk.utils;

import jssc.SerialPort;
import jssc.SerialPortException;
import jssc.SerialPortTimeoutException;
import ru.bitel.frk.utils.BGByteBuffer;
import ru.bitel.frk.utils.FakeSerialPort;
import ru.bitel.frk.utils.SerialParameters;

public class DeviceSerialPort {
    private SerialParameters a;
    private SerialPort b;
    private int c;

    public DeviceSerialPort(SerialParameters serialParameters) {
        this.a = serialParameters;
    }

    protected void _open() throws SerialPortException {
        this.b = new SerialPort(this.a.getPortName());
        this.b.openPort();
        this.b.setParams(this.a.getBaudRate(), this.a.getDatabits(), this.a.getStopbits(), this.a.getParity());
    }

    protected void _open_fake(String string) {
        this.b = new FakeSerialPort(string);
    }

    protected void _close() throws SerialPortException {
        if (this.b != null) {
            this.b.closePort();
        }
    }

    protected void _send(BGByteBuffer bGByteBuffer) throws SerialPortException {
        if (bGByteBuffer != null && bGByteBuffer.getBytes().length > 0) {
            this.b.writeBytes(bGByteBuffer.getBytes());
        }
    }

    protected void _send(byte by) throws SerialPortException {
        this.b.writeByte(by);
    }

    protected void _setTimeout(int n) {
        this.c = n;
    }

    protected BGByteBuffer _recv_all() throws SerialPortException {
        BGByteBuffer bGByteBuffer = new BGByteBuffer();
        try {
            while (true) {
                byte[] byArray = this.b.readBytes(1, this.c);
                bGByteBuffer.pushEnd(byArray, byArray.length);
            }
        }
        catch (SerialPortTimeoutException serialPortTimeoutException) {
            return bGByteBuffer;
        }
    }

    protected int _recv() throws SerialPortException {
        try {
            byte[] byArray = this.b.readBytes(1, this.c);
            return byArray[0] & 0xFF;
        }
        catch (SerialPortTimeoutException serialPortTimeoutException) {
            return -1;
        }
    }

    protected BGByteBuffer _recv(int n) throws SerialPortException {
        try {
            byte[] byArray = this.b.readBytes(n, this.c);
            return new BGByteBuffer(byArray);
        }
        catch (SerialPortTimeoutException serialPortTimeoutException) {
            return null;
        }
    }
}

