/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.frk.server;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jssc.SerialNativeInterface;
import jssc.SerialPortList;
import org.apache.log4j.Logger;
import org.apache.log4j.xml.DOMConfigurator;
import ru.bitel.common.io.InputStreamUnicodeReader;
import ru.bitel.frk.client.CmdProtocolClient;
import ru.bitel.frk.driver.ICashCheckDriver;
import ru.bitel.frk.server.CmdTcpServer;
import ru.bitel.frk.server.IDeviceDriver;
import ru.bitel.frk.utils.BGCfg;
import ru.bitel.frk.utils.FrkUtils;

public class TestServer {
    private Logger a;
    private BGCfg b;
    private boolean c;
    private boolean d;
    private int e;
    private int f;
    private Set<String> g;

    public static void main(String[] stringArray) {
        new TestServer(stringArray);
    }

    public TestServer(String[] object) {
        block13: {
            System.setProperty("cashserver.start.timestamp", String.valueOf(System.currentTimeMillis() / 1000L));
            DOMConfigurator.configureAndWatch((String)"log4j-cashcheck.xml", (long)10000L);
            this.a = Logger.getLogger(TestServer.class);
            this.b = null;
            this.c = false;
            this.d = false;
            this.e = 0;
            this.f = 0;
            this.g = null;
            if (((Object)object).length > 0) {
                for (Object object2 : object) {
                    if ("--dotest".equals(object2)) {
                        this.c = true;
                        continue;
                    }
                    if ("--dotouch".equals(object2)) {
                        this.d = true;
                        continue;
                    }
                    if (((String)object2).startsWith("--password")) {
                        this.e = FrkUtils.parseInt(((String)object2).substring(10), this.e);
                        continue;
                    }
                    if (((String)object2).startsWith("--drivers")) {
                        this.g = new HashSet<String>(Arrays.asList(((String)object2).substring(9).split(",")));
                        continue;
                    }
                    this.a.warn((Object)("unrecognized parameter " + (String)object2));
                    TestServer.c();
                    return;
                }
            } else {
                TestServer.c();
                return;
            }
            try {
                this.b = new BGCfg(new InputStreamUnicodeReader(new FileInputStream(new File(ClassLoader.getSystemResource("setupfrk.config").toURI())), "UTF-8"));
            }
            catch (Exception exception) {
                this.a.error((Object)"error parse config file", (Throwable)exception);
                return;
            }
            TestServer testServer = this;
            testServer.a.info((Object)(++testServer.f + ") CASHSERVER VERSION GETTING (LOCAL)"));
            testServer.a.info((Object)CmdTcpServer.getVersion());
            testServer.a.info((Object)(++testServer.f + ") JAVA VERSION"));
            testServer.a.info((Object)("os:" + System.getProperty("os.name") + "; java:" + System.getProperty("java.vm.name") + ", v." + System.getProperty("java.version")));
            testServer.a.info((Object)(++testServer.f + ") logging level " + testServer.a.getLevel()));
            testServer.a.info((Object)(++testServer.f + ") CHECK jssc.* CLASS"));
            try {
                Class.forName("jssc.SerialNativeInterface");
            }
            catch (Throwable throwable) {
                testServer.a.error((Object)"error get class", throwable);
                break block13;
            }
            testServer.a.info((Object)(++testServer.f + ") jssc VERSION GETTING"));
            testServer.a.info((Object)("libraryVersion=" + SerialNativeInterface.getLibraryVersion()));
            testServer.a.info((Object)("osType=" + SerialNativeInterface.getOsType() + " (" + (new String[]{"LIN", "WIN", "SOL", "MAC"})[SerialNativeInterface.getOsType()] + ")"));
        }
        if (this.d) {
            this.b();
        }
        if (this.c) {
            this.a();
        }
        this.a.info((Object)"TEST COMPLETED. THE END.");
    }

    /*
     * WARNING - void declaration
     */
    private void a() {
        Class<?> clazz;
        void object3;
        this.a.info((Object)(++this.f + ") PORT SCAN"));
        String[] stringArray = SerialPortList.getPortNames();
        this.a.info((Object)"Ports:");
        if (stringArray == null || stringArray.length <= 0) {
            this.a.warn((Object)"warning: no ports found!");
        }
        Object object = stringArray;
        int n = stringArray.length;
        boolean i = false;
        while (object3 < n) {
            clazz = object[object3];
            this.a.info((Object)clazz);
            ++object3;
        }
        this.a.info((Object)(++this.f + ") LOCAL TEST (CURRENT DRIVER)"));
        try {
            String exception = this.b.getString("driver");
            this.a.debug((Object)("create driver '" + exception + "' instance..."));
            object = (IDeviceDriver)Class.forName(exception).newInstance();
            this.a.debug((Object)("created driver: " + object));
            String[] stringArray2 = new HashMap();
            Map<String, Object> map = this.b.getMap(exception);
            if (map != null) {
                for (Map.Entry entry : map.entrySet()) {
                    if (entry.getValue() instanceof String) {
                        stringArray2.put(entry.getKey(), (String)entry.getValue());
                        this.a.trace((Object)("config: " + (String)entry.getKey() + "=" + (String)entry.getValue()));
                        continue;
                    }
                    this.a.warn((Object)("config driver parameter '" + entry.getValue() + "' is not stringable, ignored"));
                }
            }
            object.setConfig((Map<String, String>)stringArray2);
            if (this.e == 0) {
                this.a.warn((Object)"use DEFAULT oper password '0'");
            } else {
                this.a.debug((Object)("use oper password '" + this.e + "'"));
            }
            clazz = object.getClass();
            Class[] classArray = new Class[1];
            stringArray2 = new String[1];
            classArray[0] = String.class;
            stringArray2[0] = String.valueOf(this.e);
            this.a.debug((Object)"get deviceMethod 'name'...");
            Method method = clazz.getMethod("name", classArray);
            this.a.debug((Object)("invoke '" + method + "'..."));
            Object object2 = method.invoke(object, (Object[])stringArray2);
            this.a.info((Object)("getted device name: '" + (String)object2 + "'"));
            this.a.info((Object)("get device.getStatus(): " + object.getStatus()));
        }
        catch (Exception exception) {
            this.a.error((Object)"error local test", (Throwable)exception);
        }
        Object var1_13 = null;
        this.a.info((Object)(++this.f + ") REMOTE SERVER PROTOCOL TEST"));
        try {
            object = this.b.getString("port");
            CmdProtocolClient cmdProtocolClient = new CmdProtocolClient("127.0.0.1", Integer.parseInt((String)object));
            this.a.debug((Object)("connecting (127.0.0.1:" + Integer.parseInt((String)object) + ")..."));
            cmdProtocolClient.connect();
            this.a.debug((Object)"sending 'printtext'...");
            boolean bl = cmdProtocolClient.send("printtext", this.e, "\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442", "\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442", "\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442\u0442\u0435\u0441\u0442");
            this.a.debug((Object)("OK, result=" + bl + ", reply=" + cmdProtocolClient.getReply()));
            this.a.debug((Object)"sending 'name'...");
            bl = cmdProtocolClient.send("name", this.e);
            this.a.debug((Object)("OK, result=" + bl + ", reply=" + cmdProtocolClient.getReply()));
            this.a.debug((Object)"sending 'status'...");
            cmdProtocolClient.send("status", this.e);
            this.a.debug((Object)("OK: " + cmdProtocolClient.getReply()));
            this.a.debug((Object)"sending 'buzzer'...");
            bl = cmdProtocolClient.send("buzzer", this.e);
            this.a.debug((Object)("OK, result=" + bl + ", reply=" + cmdProtocolClient.getReply()));
        }
        catch (Exception exception) {
            this.a.error((Object)"error remote server test", (Throwable)exception);
        }
        this.a.info((Object)(++this.f + ") GET SERVER STATUS"));
        try {
            void var1_15;
            object = var1_15.getServerStatus();
            this.a.info((Object)("status: " + (String)object));
            var1_15.disconnect();
            return;
        }
        catch (Exception exception) {
            this.a.error((Object)"error get remote server status", (Throwable)exception);
            return;
        }
    }

    private void b() {
        this.a.info((Object)(++this.f + ") DRIVERS TOUCH"));
        try {
            int n = 0;
            Object object = FrkUtils.driversTouch();
            object = object.iterator();
            while (object.hasNext()) {
                Object object2 = (Class)object.next();
                if (!ICashCheckDriver.class.isAssignableFrom((Class<?>)object2) || ((Class)object2).isInterface()) continue;
                if (this.g != null && !this.g.contains(((Class)object2).getCanonicalName())) {
                    ++n;
                    continue;
                }
                this.a.debug((Object)("[!]driver: '" + ((Class)object2).getCanonicalName() + "'"));
                object2 = (ICashCheckDriver)((Class)object2).newInstance();
                object2.touchDriver();
            }
            if (n > 0) {
                this.a.debug((Object)(n + " driver(s) skiped"));
            }
            return;
        }
        catch (Exception exception) {
            this.a.error((Object)"error touch", (Throwable)exception);
            return;
        }
    }

    private static void c() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("TestServer of ").append(CmdTcpServer.getVersion()).append("\n");
        stringBuffer.append("Usage: testserver[.bat|.sh] [--dotest] [--dotouch] [--passwordXXX] [--driversDRIVER1,DRIVER2,...]\n");
        stringBuffer.append("Parameters:\n");
        stringBuffer.append("\t--dotest\tdo test\n");
        stringBuffer.append("\t--dotouch\tdo drivers touch\n");
        stringBuffer.append("\t--passwordXXX\tset operator password XXX\n");
        stringBuffer.append("\t--driversDRIVER1,DRIVER2,...\tset driver(s) for touch\n");
        System.out.println(stringBuffer.toString());
    }
}

