/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.frk.driver.shtrih2;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import jssc.SerialPortException;
import org.apache.log4j.Logger;
import ru.bitel.frk.driver.shtrih2.PrinterShtrihErrorException;
import ru.bitel.frk.driver.shtrih2.PrinterStatus;
import ru.bitel.frk.server.PrinterConnectException;
import ru.bitel.frk.utils.BGByteBuffer;
import ru.bitel.frk.utils.DeviceSerialPort;
import ru.bitel.frk.utils.FrkUtils;
import ru.bitel.frk.utils.SerialParameters;

public class ShtrihFRKPrinter
extends DeviceSerialPort {
    private BGByteBuffer a = null;
    private int b = 100;
    private Logger c;

    public ShtrihFRKPrinter(SerialParameters serialParameters, int n, long l, Logger logger) {
        super(serialParameters);
        this.b = n;
        this.a = ShtrihFRKPrinter.a(l, 4);
        this.c = logger;
    }

    private static BGByteBuffer a(String string, int n) {
        byte[] byArray = new byte[n];
        if (string != null) {
            byte[] byArray2 = null;
            try {
                byArray2 = string.getBytes("windows-1251");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            System.arraycopy(byArray2, 0, byArray, 0, Math.min(n, byArray2.length));
        }
        return new BGByteBuffer(byArray, n);
    }

    private static BGByteBuffer a(long l, int n) {
        byte by;
        if (l < 0L) {
            long l2 = 1L;
            for (by = 0; by < n; ++by) {
                l2 <<= 8;
            }
            l += l2;
        }
        BGByteBuffer bGByteBuffer = new BGByteBuffer();
        for (int i = 0; i < n; ++i) {
            if (l > 0L) {
                by = (byte)(l % 256L);
                bGByteBuffer.pushEnd(by);
                l /= 256L;
                continue;
            }
            bGByteBuffer.pushEnd((byte)0);
        }
        return bGByteBuffer;
    }

    private static long a(byte[] byArray, int n, int n2) {
        long l = 1L;
        long l2 = 0L;
        for (int i = n; i < n + n2; ++i) {
            l2 += (long)BGByteBuffer.byte2int(byArray[i]) * l;
            l <<= 8;
        }
        return l2;
    }

    private BGByteBuffer a(BGByteBuffer bGByteBuffer) throws PrinterShtrihErrorException, PrinterConnectException {
        BGByteBuffer bGByteBuffer2 = new BGByteBuffer(bGByteBuffer);
        byte by = (byte)bGByteBuffer2.getBytes().length;
        bGByteBuffer2.pushBegin(by);
        bGByteBuffer2.pushEnd(bGByteBuffer2.getLRC());
        bGByteBuffer2.pushBegin((byte)2);
        this.a("SEND (full packet): " + bGByteBuffer2.toString());
        bGByteBuffer2 = this.a(bGByteBuffer2, true);
        this.a("RECV (packet body): " + bGByteBuffer2.toString());
        by = bGByteBuffer2.popBeginByte();
        if (by != -1) {
            if (by != bGByteBuffer.getBytes()[0]) {
                throw new PrinterConnectException("protocol error: not equals code from ask (0x" + BGByteBuffer.toString(bGByteBuffer.getBytes()[0]) + ") and reply (0x" + BGByteBuffer.toString(by) + ")");
            }
        } else {
            this.a("_sendCommand: detected two-byte command number");
            by = bGByteBuffer2.popBeginByte();
            if (by != bGByteBuffer.getBytes()[1]) {
                throw new PrinterConnectException("protocol error: not equals code2 of TWO-BYTE command from ask (0x" + BGByteBuffer.toString(bGByteBuffer.getBytes()[1]) + ") and reply (0x" + BGByteBuffer.toString(by) + ")");
            }
        }
        if ((by = bGByteBuffer2.popBeginByte()) != 0) {
            throw new PrinterShtrihErrorException(BGByteBuffer.byte2int(by));
        }
        return bGByteBuffer2;
    }

    private BGByteBuffer a(BGByteBuffer bGByteBuffer, boolean bl) throws PrinterConnectException {
        block4: for (int i = 0; i < 5; ++i) {
            try {
                int n;
                block15: {
                    int n2;
                    block14: {
                        for (n2 = 0; n2 < 5; ++n2) {
                            this.a("_transferPacket: send ENQ");
                            this._send((byte)5);
                            this.a("_transferPacket: set timeout 10000");
                            this._setTimeout(10000);
                            n = this._recv();
                            if (n == -1) {
                                this.b("_transferPacket: (timeout) there was no reaction to ENQ");
                                throw new PrinterConnectException("there was no reaction to ENQ. (\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d \u043b\u0438 \u043f\u0440\u0438\u043d\u0442\u0435\u0440)");
                            }
                            if (n == 21) {
                                this.a("_transferPacket: getted NAK");
                                break block14;
                            }
                            if (n == 6) {
                                this.a("_transferPacket: getted ACK");
                                break block14;
                            }
                            this.b("_transferPacket: getted unknown response (not NAK or ACK)...");
                            this.a("_transferPacket: set timeout 2000");
                            this._setTimeout(2000);
                            BGByteBuffer bGByteBuffer2 = this._recv_all();
                            bGByteBuffer2.pushBegin((byte)n);
                            this.a("_transferPacket: read garbage midden (with first byte): " + bGByteBuffer2.toString());
                        }
                        throw new PrinterConnectException("reset: ENQ incorrect response to the 5 attempts.");
                    }
                    if (n == 21 && bl) {
                        for (n2 = 0; n2 < 5; ++n2) {
                            this.a("_transferPacket: send packet");
                            this._send(bGByteBuffer);
                            this.a("_transferPacket: set timeout " + this.b);
                            this._setTimeout(this.b);
                            n = this._recv();
                            if (n == -1) {
                                this.b("_transferPacket: (timeout) no answer to the command posted, (!)reentering");
                                continue block4;
                            }
                            if (n == 6) {
                                this.a("_transferPacket: getted ACK, ok!");
                                break block15;
                            }
                            this.b("_transferPacket: getted non-ACK " + BGByteBuffer.toString(n));
                        }
                        throw new PrinterConnectException("send command error: printer not reply ACK to the 5 attempts. ");
                    }
                }
                if (n == 6) {
                    try {
                        BGByteBuffer bGByteBuffer3 = this.b();
                        this.a("_transferPacket: ok, send ACK");
                        this._send((byte)6);
                        return bGByteBuffer3;
                    }
                    catch (PrinterConnectException printerConnectException) {
                        this.b("_transferPacket: error read stx-packet, send NAK, (!)reentering");
                        this._send((byte)21);
                        continue;
                    }
                }
                return null;
            }
            catch (SerialPortException serialPortException) {
                throw new PrinterConnectException(serialPortException);
            }
        }
        throw new PrinterConnectException("there was no normal transfer to the 5 attempts (enters to transfer packet).");
    }

    private BGByteBuffer b() throws SerialPortException, PrinterConnectException {
        this.a("_readSTX: set timeout 120000");
        this._setTimeout(120000);
        int n = this._recv();
        if (n == -1) {
            this.b("_readSTX: (timeout) error read STX-byte");
            throw new PrinterConnectException("error read STX-byte");
        }
        this.a("_readSTX: ok read STX-byte");
        if (n != 2) {
            this.b("_readSTX: error STX-byte: STX=0x" + BGByteBuffer.toString((byte)n));
            throw new PrinterConnectException("error STX-byte");
        }
        n = this._recv();
        if (n == -1) {
            this.b("_readSTX: (timeout) error read STX-packet (len)");
            throw new PrinterConnectException("error read STX-packet (len)");
        }
        this.a("_readSTX: ok read len=" + n);
        this.a("_readSTX: set timeout " + this.b);
        this._setTimeout(this.b);
        BGByteBuffer bGByteBuffer = this._recv(n);
        if (bGByteBuffer == null || bGByteBuffer.getBytes().length != n) {
            this.b("_readSTX: error read STX-packet (body): body=" + bGByteBuffer + ", len=" + n);
            throw new PrinterConnectException("error read STX-packet (body)");
        }
        this.a("_readSTX: ok read body " + bGByteBuffer.toString());
        int n2 = this._recv();
        if (n2 == -1) {
            this.b("_readSTX: (timeout) error read STX-packet (checksum)");
            throw new PrinterConnectException("error read STX-packet (checksum)");
        }
        this.a("_readSTX: ok read lrc");
        BGByteBuffer bGByteBuffer2 = new BGByteBuffer();
        bGByteBuffer2.pushEnd((byte)n);
        bGByteBuffer2.pushEnd(bGByteBuffer);
        byte by = bGByteBuffer2.getLRC();
        this.a("_readSTX: RECV (full): " + BGByteBuffer.toString((byte)2) + "|" + BGByteBuffer.toString(n) + "|" + bGByteBuffer.toString() + "|" + BGByteBuffer.toString(n2));
        if (by == (byte)n2) {
            return bGByteBuffer;
        }
        this.b("_readSTX: STX-packet checksum/LRC failed (read=0x" + BGByteBuffer.toString((byte)n2) + ", calc=0x" + BGByteBuffer.toString(by) + ")");
        throw new PrinterConnectException("error read STX-packet (checksum failed)");
    }

    public String getName() throws PrinterConnectException, PrinterShtrihErrorException {
        this.a("try getName()");
        Object object = this.a(new BGByteBuffer(-4));
        byte by = ((BGByteBuffer)object).popBeginByte();
        byte by2 = ((BGByteBuffer)object).popBeginByte();
        byte by3 = ((BGByteBuffer)object).popBeginByte();
        byte by4 = ((BGByteBuffer)object).popBeginByte();
        byte by5 = ((BGByteBuffer)object).popBeginByte();
        byte by6 = ((BGByteBuffer)object).popBeginByte();
        String string = null;
        try {
            string = new String(((BGByteBuffer)object).getBytes(), "windows-1251");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {}
        object = new StringBuilder(128);
        ((StringBuilder)object).append(string).append(" (");
        if (by == 0 && by2 == 0) {
            ((StringBuilder)object).append("\u0442\u0438\u043f:\u041a\u041a\u041c/\u0424\u0420");
        } else {
            ((StringBuilder)object).append("\u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u043e\u0435 \u0443\u0441\u0442\u0440\u043e-\u0432\u043e: \u0442\u0438\u043f ").append(by).append(".").append(by2);
        }
        ((StringBuilder)object).append(", \u043c\u043e\u0434\u0435\u043b\u044c:").append(by5);
        ((StringBuilder)object).append(", \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b:").append(by3).append(".").append(by4);
        ((StringBuilder)object).append(", \u044f\u0437\u044b\u043a:").append(by6).append(by6 == 0 ? "(RU)" : "");
        ((StringBuilder)object).append(")");
        return ((StringBuilder)object).toString();
    }

    public PrinterStatus getStatusShort() throws PrinterConnectException, PrinterShtrihErrorException {
        this.a("try getStatusShort()");
        Object object = new BGByteBuffer(16);
        ((BGByteBuffer)object).pushEnd(this.a);
        BGByteBuffer bGByteBuffer = this.a((BGByteBuffer)object);
        object = new PrinterStatus();
        new PrinterStatus().operatorNum = bGByteBuffer.getBytes()[0];
        ((PrinterStatus)object).rulonOpJournal = FrkUtils.testBit(bGByteBuffer.getBytes()[1], 0);
        ((PrinterStatus)object).rulonVoucherTape = FrkUtils.testBit(bGByteBuffer.getBytes()[1], 1);
        ((PrinterStatus)object).haveEKLZ = FrkUtils.testBit(bGByteBuffer.getBytes()[1], 5);
        ((PrinterStatus)object).paperOpJournal = FrkUtils.testBit(bGByteBuffer.getBytes()[1], 6);
        ((PrinterStatus)object).paperVoucherTape = FrkUtils.testBit(bGByteBuffer.getBytes()[1], 7);
        ((PrinterStatus)object).leverPrintheadControlTape = FrkUtils.testBit(bGByteBuffer.getBytes()[2], 0);
        ((PrinterStatus)object).leverPrintheadVoucherTape = FrkUtils.testBit(bGByteBuffer.getBytes()[2], 1);
        ((PrinterStatus)object).coverCorpsFR = FrkUtils.testBit(bGByteBuffer.getBytes()[2], 2);
        ((PrinterStatus)object).moneyBox = FrkUtils.testBit(bGByteBuffer.getBytes()[2], 3);
        ((PrinterStatus)object).filledEKLZ = FrkUtils.testBit(bGByteBuffer.getBytes()[2], 6);
        ((PrinterStatus)object).mode = bGByteBuffer.getBytes()[3];
        ((PrinterStatus)object).submode = bGByteBuffer.getBytes()[4];
        ((PrinterStatus)object).operationCount = (bGByteBuffer.getBytes()[10] << 8) + bGByteBuffer.getBytes()[5];
        ((PrinterStatus)object).voltageBackupBattery = Float.valueOf((float)BGByteBuffer.byte2int(bGByteBuffer.getBytes()[6]) / 51.0f);
        ((PrinterStatus)object).voltagePowerSource = Float.valueOf((float)BGByteBuffer.byte2int(bGByteBuffer.getBytes()[7]) / 9.0f);
        ((PrinterStatus)object).errorFP = bGByteBuffer.getBytes()[8];
        ((PrinterStatus)object).errorEKLZ = bGByteBuffer.getBytes()[9];
        return object;
    }

    final void a(String string, boolean bl) throws PrinterShtrihErrorException, PrinterConnectException {
        this.a("try printLine(" + string + "," + bl + ")");
        BGByteBuffer bGByteBuffer = new BGByteBuffer(23);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd(bl ? (byte)3 : 2);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(string, 40));
        this.a(bGByteBuffer);
    }

    final void a() throws PrinterShtrihErrorException, PrinterConnectException {
        this.a("try cut()");
        BGByteBuffer bGByteBuffer = new BGByteBuffer(37);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd((byte)1);
        this.a(bGByteBuffer);
    }

    public void _waitToNoPrint(int n, int n2) throws PrinterShtrihErrorException, PrinterConnectException {
        if (n2 > 0) {
            PrinterStatus printerStatus = null;
            for (int i = 0; i < n2; ++i) {
                printerStatus = this.getStatusShort();
                if (printerStatus.submode != 4 && printerStatus.submode != 5) {
                    return;
                }
                try {
                    Thread.sleep(n);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            throw new PrinterConnectException("too many wait to substatus with noprint (last mode " + printerStatus.modeNumString() + ", submode " + printerStatus.submode + ")");
        }
    }

    public void sale(long l, long l2, int n, String string, int n2, int n3, int n4, int n5) throws PrinterShtrihErrorException, PrinterConnectException {
        this.a("try sale(" + l + "," + l2 + "," + n + ",\"" + string + "\"," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-128);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l2, 5));
        bGByteBuffer.pushEnd((byte)n);
        bGByteBuffer.pushEnd((byte)n2);
        bGByteBuffer.pushEnd((byte)n3);
        bGByteBuffer.pushEnd((byte)n4);
        bGByteBuffer.pushEnd((byte)n5);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(string, 40));
        this.a(bGByteBuffer);
    }

    public void saleback(long l, long l2, int n, String string, int n2, int n3, int n4, int n5) throws PrinterShtrihErrorException, PrinterConnectException {
        this.a("try saleback(" + l + "," + l2 + "," + n + ",\"" + string + "\"," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-126);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l2, 5));
        bGByteBuffer.pushEnd((byte)n);
        bGByteBuffer.pushEnd((byte)n2);
        bGByteBuffer.pushEnd((byte)n3);
        bGByteBuffer.pushEnd((byte)n4);
        bGByteBuffer.pushEnd((byte)n5);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(string, 40));
        this.a(bGByteBuffer);
    }

    public void saleV2(int n, long l, long l2, int n2, String string, int n3, int n4, int n5) throws PrinterShtrihErrorException, PrinterConnectException {
        this.a("try saleV2(" + n + "," + l + "," + l2 + "," + n2 + ",\"" + string + "\"," + n3 + "," + n4 + "," + n5 + ")");
        BGByteBuffer bGByteBuffer = new BGByteBuffer();
        bGByteBuffer.pushEnd((byte)-1);
        bGByteBuffer.pushEnd((byte)70);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd((byte)n);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l, 6));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l2, 5));
        long l3 = l2 * l / 1000000L;
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l3, 5));
        bGByteBuffer.pushEnd((byte)-1);
        bGByteBuffer.pushEnd((byte)-1);
        bGByteBuffer.pushEnd((byte)-1);
        bGByteBuffer.pushEnd((byte)-1);
        bGByteBuffer.pushEnd((byte)-1);
        bGByteBuffer.pushEnd((byte)n3);
        bGByteBuffer.pushEnd((byte)n2);
        bGByteBuffer.pushEnd((byte)n4);
        bGByteBuffer.pushEnd((byte)n5);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(string, 128));
        this.a(bGByteBuffer);
    }

    public long closeCheck(long l, long l2, long l3, long l4, int n, String string, int n2, int n3, int n4, int n5) throws PrinterShtrihErrorException, PrinterConnectException {
        this.a("try closeCheck(" + l + "," + l2 + "," + l3 + "," + l4 + "," + n + ",\"" + string + "\"," + n2 + "," + n3 + "," + n4 + "," + n5 + ")");
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-123);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l2, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l3, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l4, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a((long)n, 2));
        bGByteBuffer.pushEnd((byte)n2);
        bGByteBuffer.pushEnd((byte)n3);
        bGByteBuffer.pushEnd((byte)n4);
        bGByteBuffer.pushEnd((byte)n5);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(string, 40));
        BGByteBuffer bGByteBuffer2 = this.a(bGByteBuffer);
        long l5 = ShtrihFRKPrinter.a(bGByteBuffer2.getBytes(), 1, 5);
        return l5;
    }

    public CloseCheckReturn closeCheckExV2(long l, int n, String string, int n2) throws PrinterShtrihErrorException, PrinterConnectException {
        int n3;
        this.a("try closeCheckExV2(" + l + "," + n + ",,\"" + string + "\"," + n2 + ")");
        BGByteBuffer bGByteBuffer = new BGByteBuffer();
        bGByteBuffer.pushEnd((byte)-1);
        bGByteBuffer.pushEnd((byte)69);
        bGByteBuffer.pushEnd(this.a);
        for (n3 = 1; n3 <= 16; ++n3) {
            bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(n == n3 ? l : 0L, 5));
        }
        bGByteBuffer.pushEnd((byte)0);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(0L, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(0L, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(0L, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(0L, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(0L, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(0L, 5));
        n3 = 1 << n2;
        bGByteBuffer.pushEnd((byte)n3);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(string, 64));
        BGByteBuffer bGByteBuffer2 = this.a(bGByteBuffer);
        CloseCheckReturn closeCheckReturn = new CloseCheckReturn();
        new CloseCheckReturn().a = ShtrihFRKPrinter.a(bGByteBuffer2.getBytes(), 0, 5);
        ShtrihFRKPrinter.a(bGByteBuffer2.getBytes(), 5, 4);
        ShtrihFRKPrinter.a(bGByteBuffer2.getBytes(), 9, 4);
        if (bGByteBuffer2.getBytes().length >= 18) {
            closeCheckReturn.decodeDATE_TIME(bGByteBuffer2.getBytes(), 13);
        }
        return closeCheckReturn;
    }

    public void buzzer() throws PrinterShtrihErrorException, PrinterConnectException {
        this.a("try buzzer()");
        BGByteBuffer bGByteBuffer = new BGByteBuffer(19);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public void xreport() throws PrinterConnectException, PrinterShtrihErrorException {
        this.a("try xreport()");
        BGByteBuffer bGByteBuffer = new BGByteBuffer(64);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public void zreport() throws PrinterConnectException, PrinterShtrihErrorException {
        this.a("try zreport()");
        BGByteBuffer bGByteBuffer = new BGByteBuffer(65);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public void divreport() throws PrinterConnectException, PrinterShtrihErrorException {
        this.a("try divreport()");
        BGByteBuffer bGByteBuffer = new BGByteBuffer(66);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public void repeatDoc() throws PrinterConnectException, PrinterShtrihErrorException {
        this.a("try repeatDoc()");
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-116);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public BGByteBuffer pureCmd(String string) throws PrinterConnectException, PrinterShtrihErrorException {
        this.a("try pureCmd(" + string + ")");
        return this.a(new BGByteBuffer(string));
    }

    public void continuePrint() throws PrinterConnectException, PrinterShtrihErrorException {
        this.a("try continuePrint()");
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-80);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public void cancelCheck() throws PrinterShtrihErrorException, PrinterConnectException {
        this.a("try cancelCheck()");
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-120);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public void openDay() throws PrinterShtrihErrorException, PrinterConnectException {
        this.a("try openDay()");
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-32);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public void sendTLV(int n, byte[] byArray) throws PrinterShtrihErrorException, PrinterConnectException {
        this.a("try sendTLV(" + n + ")");
        BGByteBuffer bGByteBuffer = new BGByteBuffer();
        bGByteBuffer.pushEnd((byte)-1);
        bGByteBuffer.pushEnd((byte)12);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(n, byArray));
        this.a(bGByteBuffer);
    }

    public void sendTLVOperation(int n, byte[] byArray) throws PrinterShtrihErrorException, PrinterConnectException {
        this.a("try sendTLVOperation(" + n + ")");
        BGByteBuffer bGByteBuffer = new BGByteBuffer();
        bGByteBuffer.pushEnd((byte)-1);
        bGByteBuffer.pushEnd((byte)77);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(n, byArray));
        this.a(bGByteBuffer);
    }

    private static BGByteBuffer a(int n, byte[] byArray) {
        BGByteBuffer bGByteBuffer = new BGByteBuffer();
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a((long)n, 2));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a((long)byArray.length, 2));
        bGByteBuffer.pushEnd(byArray, byArray.length);
        return bGByteBuffer;
    }

    public void open() throws PrinterConnectException {
        try {
            super._open();
            this.a(new BGByteBuffer(), false);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            this.close();
            if (exception2 instanceof PrinterConnectException) {
                throw (PrinterConnectException)exception2;
            }
            throw new PrinterConnectException(exception2);
        }
    }

    public void close() {
        try {
            super._close();
            return;
        }
        catch (SerialPortException serialPortException) {
            SerialPortException serialPortException2 = serialPortException;
            serialPortException.printStackTrace();
            return;
        }
    }

    public String _touch() {
        Object object = null;
        boolean bl = false;
        try {
            this._open();
            for (int i = 0; i < 5; ++i) {
                this.a("_touch: start: send ENQ" + (i > 0 ? " (attempt " + (i + 1) + ")" : ""));
                this._send((byte)5);
                this.a("_touch: set timeout 1000");
                this._setTimeout(1000);
                int n = this._recv();
                if (n == -1) {
                    this.a("_touch: timeout");
                    object = "no reaction";
                    break;
                }
                if (n == 21) {
                    this.a("_touch: getted NAK");
                    object = "OK reaction";
                    bl = true;
                    break;
                }
                if (n == 6) {
                    this.a("_touch: getted ACK");
                    BGByteBuffer bGByteBuffer = this.b();
                    if (bGByteBuffer != null) {
                        this.a("_touch: ACK reaction, readed STX: " + bGByteBuffer.toString());
                        this._send((byte)6);
                        object = "ACK reaction, readed STX: " + bGByteBuffer.toString();
                    } else {
                        this.a("_touch: ACK reaction, but error read STX");
                        this._send((byte)21);
                        object = "ACK reaction, but error read STX";
                    }
                    bl = true;
                    continue;
                }
                this.a("_touch: getted garbage midden...");
                BGByteBuffer bGByteBuffer = new BGByteBuffer((byte)n);
                this.a("_touch: set timeout 2000");
                this._setTimeout(2000);
                object = this._recv_all();
                bGByteBuffer.pushEnd((BGByteBuffer)object);
                object = "garbage midden: '" + bGByteBuffer.toString() + "'";
                this.a("_touch: garbage midden: " + bGByteBuffer.toString());
                bl = false;
            }
            if (bl) {
                try {
                    object = (String)object + "; name: " + this.getName();
                }
                catch (Throwable throwable) {
                    StringWriter stringWriter = new StringWriter();
                    throwable.printStackTrace(new PrintWriter(stringWriter));
                    object = (String)object + "; error get name: " + stringWriter.toString();
                }
            }
        }
        catch (Throwable throwable) {
            object = "device touch error: " + throwable.toString();
        }
        finally {
            try {
                this._close();
            }
            catch (Throwable throwable) {
                this.c.error((Object)"_touch: error close port", throwable);
            }
        }
        return object;
    }

    private void a(String string) {
        if (this.c != null) {
            this.c.trace((Object)("shtrih2-driver: " + string));
        }
    }

    private void b(String string) {
        if (this.c != null) {
            this.c.warn((Object)("shtrih2-driver: " + string));
        }
    }

    public int readTableByte(int n, int n2, int n3) throws PrinterShtrihErrorException, PrinterConnectException {
        this.a("try readTableByte(" + n + "," + n2 + "," + n3 + ")");
        BGByteBuffer bGByteBuffer = new BGByteBuffer();
        bGByteBuffer.pushEnd((byte)31);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd((byte)n);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a((long)n2, 2));
        bGByteBuffer.pushEnd((byte)n3);
        bGByteBuffer = this.a(bGByteBuffer);
        if (bGByteBuffer.getBytes().length != 1) {
            throw new PrinterShtrihErrorException("table value (" + n + "," + n2 + "," + n3 + ") isnt 1 byte len, but " + bGByteBuffer.getBytes().length);
        }
        return BGByteBuffer.byte2int(bGByteBuffer.popBeginByte());
    }

    public void writeTableByte(int n, int n2, int n3, int n4) throws PrinterShtrihErrorException, PrinterConnectException {
        this.a("try writeTableByte(" + n + "," + n2 + "," + n3 + ", => " + n4 + ")");
        BGByteBuffer bGByteBuffer = new BGByteBuffer();
        bGByteBuffer.pushEnd((byte)30);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd((byte)n);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a((long)n2, 2));
        bGByteBuffer.pushEnd((byte)n3);
        bGByteBuffer.pushEnd((byte)n4);
        this.a(bGByteBuffer);
    }

    public static class CloseCheckReturn {
        long a;

        public void decodeDATE_TIME(byte[] byArray, int n) {
            byte by = byArray[n];
            byte by2 = byArray[n + 1];
            byte by3 = byArray[n + 2];
            byte by4 = byArray[n + 3];
            byte by5 = byArray[n + 4];
            LocalDateTime.of(by + 2000, by2, (int)by3, (int)by4, (int)by5);
        }
    }
}

