/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.frk.driver.shtrih;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import jssc.SerialPortException;
import org.apache.log4j.Logger;
import ru.bitel.frk.driver.shtrih.PrinterShtrihErrorException;
import ru.bitel.frk.driver.shtrih.PrinterStatus;
import ru.bitel.frk.server.PrinterConnectException;
import ru.bitel.frk.utils.BGByteBuffer;
import ru.bitel.frk.utils.DeviceSerialPort;
import ru.bitel.frk.utils.FrkUtils;
import ru.bitel.frk.utils.SerialParameters;

public class ShtrihFRKPrinter
extends DeviceSerialPort {
    private BGByteBuffer a = null;
    private int b = 100;
    private Logger c;

    public ShtrihFRKPrinter(SerialParameters serialParameters, int n, long l, Logger logger) {
        super(serialParameters);
        this.b = n;
        this.a = ShtrihFRKPrinter.a(l, 4);
        this.c = logger;
    }

    private static BGByteBuffer a(String string, int n) {
        byte[] byArray = new byte[40];
        if (string != null) {
            byte[] byArray2 = null;
            try {
                byArray2 = string.getBytes("windows-1251");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            System.arraycopy(byArray2, 0, byArray, 0, Math.min(40, byArray2.length));
        }
        return new BGByteBuffer(byArray, 40);
    }

    private static BGByteBuffer a(long l, int n) {
        byte by;
        if (l < 0L) {
            long l2 = 1L;
            for (by = 0; by < n; ++by) {
                l2 <<= 8;
            }
            l += l2;
        }
        BGByteBuffer bGByteBuffer = new BGByteBuffer();
        for (int i = 0; i < n; ++i) {
            if (l > 0L) {
                by = (byte)(l % 256L);
                bGByteBuffer.pushEnd(by);
                l /= 256L;
                continue;
            }
            bGByteBuffer.pushEnd((byte)0);
        }
        return bGByteBuffer;
    }

    private BGByteBuffer a(BGByteBuffer bGByteBuffer) throws PrinterShtrihErrorException, PrinterConnectException {
        try {
            BGByteBuffer bGByteBuffer2 = new BGByteBuffer(bGByteBuffer);
            byte by = (byte)bGByteBuffer2.getBytes().length;
            bGByteBuffer2.pushBegin(by);
            bGByteBuffer2.pushEnd(bGByteBuffer2.getLRC());
            bGByteBuffer2.pushBegin((byte)2);
            this.a("SEND: " + bGByteBuffer2.toString());
            this._send(bGByteBuffer2);
            this._setTimeout(this.b << 1);
            int n = this._recv();
            if (n == -1) {
                throw new PrinterConnectException("echo error: no answer to the command posted");
            }
            if (n == 6) {
                this._setTimeout(60000);
                BGByteBuffer bGByteBuffer3 = this.b();
                if (bGByteBuffer3 != null) {
                    this._send((byte)6);
                    by = bGByteBuffer3.popBeginByte();
                    if (by != bGByteBuffer.getBytes()[0]) {
                        throw new PrinterConnectException("protocol error: not equals code from ask and reply");
                    }
                    byte by2 = bGByteBuffer3.popBeginByte();
                    if (by2 != 0) {
                        throw new PrinterShtrihErrorException(BGByteBuffer.byte2int(by2));
                    }
                    return bGByteBuffer3;
                }
            }
        }
        catch (SerialPortException serialPortException) {
            throw new PrinterConnectException(serialPortException.toString());
        }
        return null;
    }

    private BGByteBuffer b() throws SerialPortException {
        int n = this._recv();
        if (n == -1) {
            return null;
        }
        if (n != 2) {
            this.a("_readSTX: error: STX=0x" + new BGByteBuffer((byte)n));
            return null;
        }
        n = this._recv();
        if (n == -1) {
            return null;
        }
        BGByteBuffer bGByteBuffer = this._recv(n);
        if (bGByteBuffer == null || bGByteBuffer.getBytes().length != n) {
            this.a("_readSTX: error: body=" + bGByteBuffer + ", len=" + n);
            return null;
        }
        int n2 = this._recv();
        if (n2 == -1) {
            return null;
        }
        BGByteBuffer bGByteBuffer2 = new BGByteBuffer();
        bGByteBuffer2.pushEnd((byte)n);
        bGByteBuffer2.pushEnd(bGByteBuffer);
        n = bGByteBuffer2.getLRC();
        this.a("RECV: " + new BGByteBuffer(bGByteBuffer2).pushEnd((byte)n2).pushBegin((byte)2));
        if (n == (byte)n2) {
            bGByteBuffer2.popBeginByte();
            return bGByteBuffer2;
        }
        this.a("_readSTX: error LRC");
        return null;
    }

    public String getName() throws PrinterConnectException, PrinterShtrihErrorException {
        String string = null;
        this.c();
        BGByteBuffer bGByteBuffer = this.a(new BGByteBuffer(-4));
        if (bGByteBuffer != null) {
            byte by = bGByteBuffer.popBeginByte();
            byte by2 = bGByteBuffer.popBeginByte();
            byte by3 = bGByteBuffer.popBeginByte();
            byte by4 = bGByteBuffer.popBeginByte();
            byte by5 = bGByteBuffer.popBeginByte();
            byte by6 = bGByteBuffer.popBeginByte();
            string = null;
            try {
                string = new String(bGByteBuffer.getBytes(), "windows-1251");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
            string = string + " (";
            string = by == 0 && by2 == 0 ? string + "\u0442\u0438\u043f:\u041a\u041a\u041c/\u0424\u0420" : string + "\u043d\u0435\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u043c\u043e\u0435 \u0443\u0441\u0442\u0440\u043e-\u0432\u043e: \u0442\u0438\u043f " + by + "." + by2;
            string = string + ", \u043c\u043e\u0434\u0435\u043b\u044c:" + by5;
            string = string + ", \u043f\u0440\u043e\u0442\u043e\u043a\u043e\u043b:" + by3 + "." + by4;
            string = string + ", \u044f\u0437\u044b\u043a:" + by6 + (by6 == 0 ? "(RU)" : "");
            string = string + ")";
        }
        return string;
    }

    public PrinterStatus getStatusShort() throws PrinterConnectException, PrinterShtrihErrorException {
        PrinterStatus printerStatus = null;
        this.c();
        BGByteBuffer bGByteBuffer = new BGByteBuffer(16);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer = this.a(bGByteBuffer);
        if (bGByteBuffer != null) {
            printerStatus = new PrinterStatus();
            new PrinterStatus().operatorNum = bGByteBuffer.getBytes()[0];
            printerStatus.rulonOpJournal = FrkUtils.testBit(bGByteBuffer.getBytes()[1], 0);
            printerStatus.rulonVoucherTape = FrkUtils.testBit(bGByteBuffer.getBytes()[1], 1);
            printerStatus.haveEKLZ = FrkUtils.testBit(bGByteBuffer.getBytes()[1], 5);
            printerStatus.paperOpJournal = FrkUtils.testBit(bGByteBuffer.getBytes()[1], 6);
            printerStatus.paperVoucherTape = FrkUtils.testBit(bGByteBuffer.getBytes()[1], 7);
            printerStatus.leverPrintheadControlTape = FrkUtils.testBit(bGByteBuffer.getBytes()[2], 0);
            printerStatus.leverPrintheadVoucherTape = FrkUtils.testBit(bGByteBuffer.getBytes()[2], 1);
            printerStatus.coverCorpsFR = FrkUtils.testBit(bGByteBuffer.getBytes()[2], 2);
            printerStatus.moneyBox = FrkUtils.testBit(bGByteBuffer.getBytes()[2], 3);
            printerStatus.filledEKLZ = FrkUtils.testBit(bGByteBuffer.getBytes()[2], 6);
            printerStatus.mode = bGByteBuffer.getBytes()[3];
            printerStatus.submode = bGByteBuffer.getBytes()[4];
            printerStatus.operationCount = (bGByteBuffer.getBytes()[10] << 8) + bGByteBuffer.getBytes()[5];
            printerStatus.voltageBackupBattery = Float.valueOf((float)BGByteBuffer.byte2int(bGByteBuffer.getBytes()[6]) / 51.0f);
            printerStatus.voltagePowerSource = Float.valueOf((float)BGByteBuffer.byte2int(bGByteBuffer.getBytes()[7]) / 9.0f);
            printerStatus.errorFP = bGByteBuffer.getBytes()[8];
            printerStatus.errorEKLZ = bGByteBuffer.getBytes()[9];
        }
        return printerStatus;
    }

    final void a(String string, boolean bl) throws PrinterShtrihErrorException, PrinterConnectException {
        BGByteBuffer bGByteBuffer = new BGByteBuffer(23);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd(bl ? (byte)3 : 2);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(string, 40));
        this.a(bGByteBuffer);
    }

    final void a() throws PrinterShtrihErrorException, PrinterConnectException {
        BGByteBuffer bGByteBuffer = new BGByteBuffer(37);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd((byte)1);
        this.a(bGByteBuffer);
    }

    public void _waitToNoPrint(int n, int n2) throws PrinterShtrihErrorException, PrinterConnectException {
        if (n2 > 0) {
            PrinterStatus printerStatus = null;
            for (int i = 0; i < n2; ++i) {
                printerStatus = this.getStatusShort();
                if (printerStatus.submode != 4 && printerStatus.submode != 5) {
                    return;
                }
                try {
                    Thread.sleep(n);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    return;
                }
            }
            throw new PrinterConnectException("too many wait to substatus with noprint (last mode " + printerStatus.modeNumString() + ", submode " + printerStatus.submode + ")");
        }
    }

    public void sale(long l, long l2, int n, String string, int n2, int n3, int n4, int n5) throws PrinterShtrihErrorException, PrinterConnectException {
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-128);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l2, 5));
        bGByteBuffer.pushEnd((byte)n);
        bGByteBuffer.pushEnd((byte)n2);
        bGByteBuffer.pushEnd((byte)n3);
        bGByteBuffer.pushEnd((byte)n4);
        bGByteBuffer.pushEnd((byte)n5);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(string, 40));
        this.a(bGByteBuffer);
    }

    public void saleback(long l, long l2, int n, String string, int n2, int n3, int n4, int n5) throws PrinterShtrihErrorException, PrinterConnectException {
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-126);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l2, 5));
        bGByteBuffer.pushEnd((byte)n);
        bGByteBuffer.pushEnd((byte)n2);
        bGByteBuffer.pushEnd((byte)n3);
        bGByteBuffer.pushEnd((byte)n4);
        bGByteBuffer.pushEnd((byte)n5);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(string, 40));
        this.a(bGByteBuffer);
    }

    public long closeCheck(long l, long l2, long l3, long l4, int n, String string, int n2, int n3, int n4, int n5) throws PrinterShtrihErrorException, PrinterConnectException {
        long l5 = 0L;
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-123);
        bGByteBuffer.pushEnd(this.a);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l2, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l3, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(l4, 5));
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(n, 2));
        bGByteBuffer.pushEnd((byte)n2);
        bGByteBuffer.pushEnd((byte)n3);
        bGByteBuffer.pushEnd((byte)n4);
        bGByteBuffer.pushEnd((byte)n5);
        bGByteBuffer.pushEnd(ShtrihFRKPrinter.a(string, 40));
        BGByteBuffer bGByteBuffer2 = this.a(bGByteBuffer);
        if (bGByteBuffer2 != null) {
            int n6 = 5;
            n6 = 1;
            byte[] byArray = bGByteBuffer2.getBytes();
            long l6 = 1L;
            long l7 = 0L;
            for (int i = 1; i < 6; ++i) {
                l7 += (long)BGByteBuffer.byte2int(byArray[i]) * l6;
                l6 <<= 8;
            }
            l5 = l7;
        }
        return l5;
    }

    public void buzzer() throws PrinterShtrihErrorException, PrinterConnectException {
        BGByteBuffer bGByteBuffer = new BGByteBuffer(19);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public void xreport() throws PrinterConnectException, PrinterShtrihErrorException {
        this.c();
        BGByteBuffer bGByteBuffer = new BGByteBuffer(64);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public void zreport() throws PrinterConnectException, PrinterShtrihErrorException {
        this.c();
        BGByteBuffer bGByteBuffer = new BGByteBuffer(65);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public void divreport() throws PrinterConnectException, PrinterShtrihErrorException {
        this.c();
        BGByteBuffer bGByteBuffer = new BGByteBuffer(66);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public void repeatDoc() throws PrinterConnectException, PrinterShtrihErrorException {
        this.c();
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-116);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public BGByteBuffer pureCmd(String string) throws PrinterConnectException, PrinterShtrihErrorException {
        this.c();
        return this.a(new BGByteBuffer(string));
    }

    public void continuePrint() throws PrinterConnectException, PrinterShtrihErrorException {
        this.c();
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-80);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public void cancelCheck() throws PrinterShtrihErrorException, PrinterConnectException {
        this.c();
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-120);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    public void openDay() throws PrinterShtrihErrorException, PrinterConnectException {
        this.c();
        BGByteBuffer bGByteBuffer = new BGByteBuffer(-32);
        bGByteBuffer.pushEnd(this.a);
        this.a(bGByteBuffer);
    }

    private boolean c() throws PrinterConnectException {
        try {
            for (int i = 0; i < 10; ++i) {
                BGByteBuffer bGByteBuffer;
                try {
                    Thread.sleep(this.b << 1);
                }
                catch (InterruptedException interruptedException) {}
                this._send((byte)5);
                this.a("_reset: send ENQ (" + i + ")");
                this._setTimeout(10000);
                int n = this._recv();
                if (n == -1) {
                    throw new PrinterConnectException("reset: there was no reaction to ENQ. (\u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435 \u0432\u043a\u043b\u044e\u0447\u0435\u043d \u043b\u0438 \u043f\u0440\u0438\u043d\u0442\u0435\u0440)");
                }
                if (n == 21) {
                    this.a("_reset: getted NAK (" + i + ")");
                    return true;
                }
                if (n == 6) {
                    this.a("_reset: getted ACK (" + i + ")");
                    bGByteBuffer = this.b();
                    this.a("_reset: STX message= " + bGByteBuffer + " (" + i + ")");
                    if (bGByteBuffer != null) {
                        this.a("_reset: send ACK (" + i + ")");
                        this._send((byte)6);
                        continue;
                    }
                    this.a("_reset: send NAK (" + i + ")");
                    this._send((byte)21);
                    continue;
                }
                this.a("_reset: unknown response (not NAK or ACK) (" + i + ")");
                this._setTimeout(1000);
                this.a("_reset: read garbage midden: " + BGByteBuffer.toString((byte)n) + "... (" + i + ")");
                bGByteBuffer = this._recv_all();
                this.a(bGByteBuffer.toString());
            }
            throw new PrinterConnectException("reset: ENQ incorrect response to the 10 attempts.");
        }
        catch (SerialPortException serialPortException) {
            throw new PrinterConnectException(serialPortException.toString());
        }
    }

    public boolean open() throws PrinterConnectException {
        try {
            super._open();
            this.c();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            this.close();
            if (exception2 instanceof PrinterConnectException) {
                throw (PrinterConnectException)exception2;
            }
            throw new PrinterConnectException(exception2.toString());
        }
        return true;
    }

    public void close() {
        try {
            super._close();
            return;
        }
        catch (SerialPortException serialPortException) {
            SerialPortException serialPortException2 = serialPortException;
            serialPortException.printStackTrace();
            return;
        }
    }

    public String _touch() {
        String string;
        boolean bl = false;
        try {
            this._open();
            this._send((byte)5);
            this._setTimeout(100);
            int n = this._recv();
            if (n == -1) {
                string = "no reaction";
            } else if (n == 21) {
                string = "OK reaction";
                bl = true;
            } else if (n == 6) {
                BGByteBuffer bGByteBuffer = this.b();
                if (bGByteBuffer != null) {
                    this._send((byte)6);
                    string = "ACK reaction, readed STX: " + bGByteBuffer.toString();
                } else {
                    this._send((byte)21);
                    string = "ACK reaction, but error read STX";
                }
                bl = true;
            } else {
                BGByteBuffer bGByteBuffer = new BGByteBuffer((byte)n);
                this._setTimeout(100);
                BGByteBuffer bGByteBuffer2 = this._recv_all();
                bGByteBuffer.pushEnd(bGByteBuffer2);
                string = "garbage midden: '" + bGByteBuffer.toString() + "'";
                bl = true;
            }
            if (bl) {
                try {
                    string = string + "; name: " + this.getName();
                }
                catch (Throwable throwable) {
                    StringWriter stringWriter = new StringWriter();
                    throwable.printStackTrace(new PrintWriter(stringWriter));
                    string = string + "; error get name: " + stringWriter.toString();
                }
            }
        }
        catch (Throwable throwable) {
            string = "device touch error: " + throwable.toString();
        }
        finally {
            try {
                this._close();
            }
            catch (Throwable throwable) {
                this.c.error((Object)"error close port", throwable);
            }
        }
        return string;
    }

    private void a(String string) {
        if (this.c != null) {
            this.c.trace((Object)("shtrih-driver: " + string));
        }
    }
}

