/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.frk.driver.shtrih;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import jssc.SerialPortList;
import org.apache.log4j.Logger;
import ru.bitel.frk.driver.ICashCheckDriver;
import ru.bitel.frk.driver.shtrih.PrinterShtrihErrorException;
import ru.bitel.frk.driver.shtrih.PrinterStatus;
import ru.bitel.frk.driver.shtrih.ShtrihFRKPrinter;
import ru.bitel.frk.server.DriverException;
import ru.bitel.frk.server.NotImplementedException;
import ru.bitel.frk.server.PrinterConnectException;
import ru.bitel.frk.utils.BGByteBuffer;
import ru.bitel.frk.utils.CheckLine;
import ru.bitel.frk.utils.FrkUtils;
import ru.bitel.frk.utils.SerialParameters;

public class Driver
implements ICashCheckDriver {
    private SerialParameters a = new SerialParameters();
    private int b = 100;
    private int c = 1000;
    private int d = 20;
    private boolean e = false;
    private boolean f = false;
    private static final Logger g = Logger.getLogger(Driver.class);

    @Override
    public void setConfig(Map<String, String> map) {
        if (map.containsKey("portName")) {
            this.a.setPortName(map.get("portName"));
        }
        if (map.containsKey("baudRate")) {
            this.a.setBaudRate(map.get("baudRate"));
        }
        if (map.containsKey("flowControlIn")) {
            this.a.setFlowControlIn(map.get("flowControlIn"));
        }
        if (map.containsKey("flowControlOut")) {
            this.a.setFlowControlOut(map.get("flowControlOut"));
        }
        if (map.containsKey("databits")) {
            this.a.setDatabits(map.get("databits"));
        }
        if (map.containsKey("stopbits")) {
            this.a.setStopbits(map.get("stopbits"));
        }
        if (map.containsKey("parity")) {
            this.a.setParity(map.get("parity"));
        }
        this.b = FrkUtils.parseInt(map.get("oneByteTimeout"), this.b);
        this.c = FrkUtils.parseInt(map.get("waitNoprintTimeout"), this.c);
        this.d = FrkUtils.parseInt(map.get("waitNoprintNumtry"), this.d);
        this.e = FrkUtils.parseBoolean(map.get("cutterDisabled"), this.e);
        this.f = FrkUtils.parseBoolean(map.get("cutterForceManual"), this.f);
    }

    @Override
    public synchronized void touchDriver() {
        Object object;
        StringBuilder charSequence2 = new StringBuilder();
        String[] stringArray = SerialPortList.getPortNames();
        charSequence2.append("available serial ports:\n");
        Object[] objectArray = stringArray;
        int nArray = stringArray.length;
        for (int nArray2 = 0; nArray2 < nArray; ++nArray2) {
            object = objectArray[nArray2];
            charSequence2.append((String)object).append("\n");
        }
        if (stringArray.length <= 0) {
            charSequence2.append("not available com ports!\n");
        }
        g.debug((Object)charSequence2.toString());
        objectArray = new int[]{2400, 4800, 9600, 19200, 38400, 57600, 115200};
        int[] nArray2 = new int[]{0};
        int[] nArray3 = new int[]{0};
        object = new int[]{7, 8};
        int[] nArray4 = new int[]{1};
        int[] nArray5 = new int[]{0, 2, 1};
        SerialParameters serialParameters = new SerialParameters();
        ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(serialParameters, this.b, 0L, g);
        for (String string : stringArray) {
            serialParameters.setPortName(string);
            Object[] objectArray2 = objectArray;
            for (int i = 0; i < 7; ++i) {
                String object2 = objectArray2[i];
                serialParameters.setBaudRate((int)object2);
                int[] nArray6 = nArray2;
                for (int j = 0; j <= 0; ++j) {
                    Object n2 = nArray6[j];
                    serialParameters.setFlowControlIn((int)n2);
                    int[] nArray7 = nArray3;
                    for (int k = 0; k <= 0; ++k) {
                        n2 = nArray7[k];
                        serialParameters.setFlowControlOut((int)n2);
                        Object object3 = object;
                        for (int i2 = 0; i2 < 2; ++i2) {
                            n2 = object3[i2];
                            serialParameters.setDatabits((int)n2);
                            int[] nArray8 = nArray4;
                            for (int i3 = 0; i3 <= 0; ++i3) {
                                n2 = nArray8[i3];
                                serialParameters.setStopbits((int)n2);
                                int[] nArray9 = nArray5;
                                for (int i4 = 0; i4 < 3; ++i4) {
                                    int stringBuilder = nArray9[i4];
                                    serialParameters.setParity(stringBuilder);
                                    StringBuilder stringBuilder2 = new StringBuilder();
                                    stringBuilder2.append(serialParameters.getPortName()).append(",BR:").append(serialParameters.getBaudRateString()).append(",DB:").append(serialParameters.getDatabitsString()).append(",SB:").append(serialParameters.getStopbitsString()).append(",P:").append(serialParameters.getParityString());
                                    String string2 = shtrihFRKPrinter._touch();
                                    stringBuilder2.append(" -> ").append(string2).append("\n");
                                    g.debug((Object)stringBuilder2.toString());
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public synchronized void buzzer(String string) throws PrinterShtrihErrorException, PrinterConnectException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);){
            if (shtrihFRKPrinter.open()) {
                shtrihFRKPrinter.buzzer();
            }
            return;
        }
    }

    @Override
    public synchronized void printtext(String ... stringArray) throws PrinterShtrihErrorException, PrinterConnectException, DriverException {
        int n = FrkUtils.parseInt(stringArray[0]);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);){
            if (shtrihFRKPrinter.open()) {
                shtrihFRKPrinter._waitToNoPrint(this.c, this.d);
                for (int i = 1; i < stringArray.length; ++i) {
                    if ("!CUT%)".equals(stringArray[i]) && !this.e) {
                        shtrihFRKPrinter.a();
                        continue;
                    }
                    shtrihFRKPrinter.a(stringArray[i], false);
                }
            }
            return;
        }
    }

    @Override
    public synchronized String name(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        String string2 = null;
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);){
            if (shtrihFRKPrinter.open()) {
                string2 = shtrihFRKPrinter.getName();
            }
        }
        return string2;
    }

    @Override
    public synchronized String status(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        StringBuffer stringBuffer = new StringBuffer(1024);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);){
            if (shtrihFRKPrinter.open()) {
                PrinterStatus printerStatus = shtrihFRKPrinter.getStatusShort();
                stringBuffer.append("\u041f\u043e\u0440\u044f\u0434\u043a\u043e\u0432\u044b\u0439 \u043d\u043e\u043c\u0435\u0440 \u043e\u043f\u0435\u0440\u0430\u0442\u043e\u0440\u0430: ");
                stringBuffer.append(printerStatus.operatorNum);
                stringBuffer.append("\n\u0420\u0443\u043b\u043e\u043d \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u0433\u043e \u0436\u0443\u0440\u043d\u0430\u043b\u0430: ");
                stringBuffer.append(printerStatus.rulonOpJournal != false ? "\u0435\u0441\u0442\u044c" : "\u043d\u0435\u0442");
                stringBuffer.append("\n\u0420\u0443\u043b\u043e\u043d \u0447\u0435\u043a\u043e\u0432\u043e\u0439 \u043b\u0435\u043d\u0442\u044b: ");
                stringBuffer.append(printerStatus.rulonVoucherTape != false ? "\u0435\u0441\u0442\u044c" : "\u043d\u0435\u0442");
                stringBuffer.append("\n\u042d\u041a\u041b\u0417: ");
                stringBuffer.append(printerStatus.haveEKLZ != false ? "\u0435\u0441\u0442\u044c" : "\u043d\u0435\u0442");
                stringBuffer.append("\n\u041e\u043f\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0434\u0430\u0442\u0447\u0438\u043a \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u043e\u043d\u043d\u043e\u0433\u043e \u0436\u0443\u0440\u043d\u0430\u043b\u0430: ");
                stringBuffer.append(printerStatus.paperOpJournal != false ? "\u0431\u0443\u043c\u0430\u0433\u0430 \u0435\u0441\u0442\u044c" : "\u0431\u0443\u043c\u0430\u0433\u0438 \u043d\u0435\u0442");
                stringBuffer.append("\n\u041e\u043f\u0442\u0438\u0447\u0435\u0441\u043a\u0438\u0439 \u0434\u0430\u0442\u0447\u0438\u043a \u0447\u0435\u043a\u043e\u0432\u043e\u0439 \u043b\u0435\u043d\u0442\u044b: ");
                stringBuffer.append(printerStatus.paperVoucherTape != false ? "\u0431\u0443\u043c\u0430\u0433\u0430 \u0435\u0441\u0442\u044c" : "\u0431\u0443\u043c\u0430\u0433\u0438 \u043d\u0435\u0442");
                stringBuffer.append("\n\u0420\u044b\u0447\u0430\u0433 \u0442\u0435\u0440\u043c\u043e\u0433\u043e\u043b\u043e\u0432\u043a\u0438 \u043a\u043e\u043d\u0442\u0440\u043e\u043b\u044c\u043d\u043e\u0439 \u043b\u0435\u043d\u0442\u044b: ");
                stringBuffer.append(printerStatus.leverPrintheadControlTape != false ? "\u043e\u043f\u0443\u0449\u0435\u043d" : "\u043f\u043e\u0434\u043d\u044f\u0442");
                stringBuffer.append("\n\u0420\u044b\u0447\u0430\u0433 \u0442\u0435\u0440\u043c\u043e\u0433\u043e\u043b\u043e\u0432\u043a\u0438 \u0447\u0435\u043a\u043e\u0432\u043e\u0439 \u043b\u0435\u043d\u0442\u044b: ");
                stringBuffer.append(printerStatus.leverPrintheadVoucherTape != false ? "\u043e\u043f\u0443\u0449\u0435\u043d" : "\u043f\u043e\u0434\u043d\u044f\u0442");
                stringBuffer.append("\n\u041a\u0440\u044b\u0448\u043a\u0430 \u043a\u043e\u0440\u043f\u0443\u0441\u0430 \u0424\u0420: ");
                stringBuffer.append(printerStatus.coverCorpsFR != false ? "\u043f\u043e\u0434\u043d\u044f\u0442\u0430" : "\u043e\u043f\u0443\u0449\u0435\u043d\u0430");
                stringBuffer.append("\n\u0414\u0435\u043d\u0435\u0436\u043d\u044b\u0439 \u044f\u0449\u0438\u043a: ");
                stringBuffer.append(printerStatus.moneyBox != false ? "\u043e\u0442\u043a\u0440\u044b\u0442" : "\u0437\u0430\u043a\u0440\u044b\u0442");
                stringBuffer.append("\n\u042d\u041a\u041b\u0417 \u043f\u043e\u0447\u0442\u0438 \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0430: ");
                stringBuffer.append(printerStatus.filledEKLZ != false ? "\u0434\u0430" : "\u043d\u0435\u0442");
                stringBuffer.append("\n\u0420\u0435\u0436\u0438\u043c \u0424\u0420: ");
                stringBuffer.append("#" + printerStatus.modeNumString() + " : " + printerStatus.modeString());
                stringBuffer.append("\n\u041f\u043e\u0434\u0440\u0435\u0436\u0438\u043c \u0424\u0420: ");
                stringBuffer.append("#" + printerStatus.submode + " : " + printerStatus.submodeString());
                stringBuffer.append("\n\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u043f\u0435\u0440\u0430\u0446\u0438\u0439 \u0432 \u0447\u0435\u043a\u0435: ");
                stringBuffer.append(printerStatus.operationCount);
                stringBuffer.append("\n\u041d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435 \u0440\u0435\u0437\u0435\u0440\u0432\u043d\u043e\u0439 \u0431\u0430\u0442\u0430\u0440\u0435\u0438: ");
                stringBuffer.append(printerStatus.voltageBackupBattery);
                stringBuffer.append("\n\u041d\u0430\u043f\u0440\u044f\u0436\u0435\u043d\u0438\u0435 \u0438\u0441\u0442\u043e\u0447\u043d\u0438\u043a\u0430 \u043f\u0438\u0442\u0430\u043d\u0438\u044f: ");
                stringBuffer.append(printerStatus.voltagePowerSource);
                stringBuffer.append("\n\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 \u0424\u041f: ");
                stringBuffer.append(printerStatus.errorFP);
                stringBuffer.append("\n\u041a\u043e\u0434 \u043e\u0448\u0438\u0431\u043a\u0438 \u042d\u041a\u041b\u0417: ");
                stringBuffer.append(printerStatus.errorEKLZ);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public synchronized void xreport(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);){
            if (shtrihFRKPrinter.open()) {
                shtrihFRKPrinter._waitToNoPrint(this.c, this.d);
                shtrihFRKPrinter.xreport();
                if (this.f) {
                    shtrihFRKPrinter.a();
                }
            }
            return;
        }
    }

    @Override
    public synchronized void divreport(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);){
            if (shtrihFRKPrinter.open()) {
                shtrihFRKPrinter._waitToNoPrint(this.c, this.d);
                shtrihFRKPrinter.divreport();
                if (this.f) {
                    shtrihFRKPrinter.a();
                }
            }
            return;
        }
    }

    @Override
    public synchronized void zreport(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);){
            if (shtrihFRKPrinter.open()) {
                shtrihFRKPrinter._waitToNoPrint(this.c, this.d);
                shtrihFRKPrinter.zreport();
                if (this.f) {
                    shtrihFRKPrinter.a();
                }
            }
            return;
        }
    }

    @Override
    public synchronized String check(String ... object) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(object[0]);
        Object object2 = FrkUtils.processCommandCheckClientsumma(object[1]);
        BigDecimal bigDecimal = ((FrkUtils.CommandCheckClientsumma)object2).summa;
        object2 = ((FrkUtils.CommandCheckClientsumma)object2).typ;
        BigDecimal bigDecimal2 = new BigDecimal(100);
        g.debug((Object)("Driver: check(clientsumma=" + bigDecimal + "):"));
        ArrayList<CheckLine> arrayList = new ArrayList<CheckLine>();
        object = FrkUtils.processCommandCheckParameters((String[])object, arrayList, g);
        if (bigDecimal.compareTo(((FrkUtils.CommandCheckParameters)object).totalPositionSumma) < 0) {
            throw new PrinterShtrihErrorException("\u0414\u0435\u043d\u0435\u0433 \u0432\u043d\u0435\u0441\u0435\u043d\u043e (" + bigDecimal.toPlainString() + ") \u043c\u0435\u043d\u044c\u0448\u0435 \u0441\u0443\u043c\u043c\u044b \u0447\u0435\u043a\u0430 (" + ((FrkUtils.CommandCheckParameters)object).totalPositionSumma.toPlainString() + ")");
        }
        long l = 0L;
        object = new ShtrihFRKPrinter(this.a, this.b, n, g);
        try {
            if (((ShtrihFRKPrinter)object).open()) {
                ((ShtrihFRKPrinter)object)._waitToNoPrint(this.c, this.d);
                for (CheckLine checkLine : arrayList) {
                    if (checkLine.getSumma() == null) {
                        ((ShtrihFRKPrinter)object).a(checkLine.getText(), true);
                        continue;
                    }
                    ((ShtrihFRKPrinter)object).sale(1000L, checkLine.getSumma().multiply(bigDecimal2).longValue(), checkLine.getDivision(), checkLine.getText(), 0, 0, 0, 0);
                }
                long l2 = bigDecimal.multiply(bigDecimal2).longValue();
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                long l6 = 0L;
                if (object2 == null || (Integer)object2 == 1) {
                    l3 = l2;
                } else if ((Integer)object2 == 2) {
                    l4 = l2;
                } else if ((Integer)object2 == 3) {
                    l5 = l2;
                } else if ((Integer)object2 == 4) {
                    l6 = l2;
                } else {
                    throw new DriverException("payment type must be 1..4");
                }
                l = ((ShtrihFRKPrinter)object).closeCheck(l3, l4, l5, l6, 0, "", 0, 0, 0, 0);
                ((ShtrihFRKPrinter)object).buzzer();
                if (this.f) {
                    ((ShtrihFRKPrinter)object).a();
                }
            }
        }
        finally {
            ((ShtrihFRKPrinter)object).close();
        }
        return String.valueOf(l / 100L) + "." + String.valueOf(l % 100L);
    }

    @Override
    public synchronized String checkreturn(String ... stringArray) throws NotImplementedException {
        throw new NotImplementedException();
    }

    @Override
    public synchronized String returnscheck(String string, String string2, String string3, String string4) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        int n2 = FrkUtils.parseInt(string2, 0);
        long l = (long)(Double.parseDouble(string3) * 100.0);
        long l2 = 0L;
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);){
            if (shtrihFRKPrinter.open()) {
                shtrihFRKPrinter._waitToNoPrint(this.c, this.d);
                shtrihFRKPrinter.saleback(1000L, l, n2, string4, 0, 0, 0, 0);
                l2 = shtrihFRKPrinter.closeCheck(l, 0L, 0L, 0L, 0, "", 0, 0, 0, 0);
                shtrihFRKPrinter.buzzer();
                if (this.f) {
                    shtrihFRKPrinter.a();
                }
            }
        }
        return String.valueOf(l2 / 100L) + "." + String.valueOf(l2 % 100L);
    }

    @Override
    public synchronized String closecheck_fix(String string, String string2) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);
        long l = 0L;
        double d = Double.parseDouble(string2);
        try {
            if (shtrihFRKPrinter.open()) {
                shtrihFRKPrinter._waitToNoPrint(this.c, this.d);
                l = shtrihFRKPrinter.closeCheck((long)(d * 100.0), 0L, 0L, 0L, 0, "\u044d\u043a\u0441\u0442\u0440\u0435\u043d\u043d\u043e\u0435 \u0437\u0430\u043a\u0440\u044b\u0442\u0438\u0435 \u0447\u0435\u043a\u0430", 0, 0, 0, 0);
                if (this.f) {
                    shtrihFRKPrinter.a();
                }
            }
        }
        finally {
            shtrihFRKPrinter.close();
        }
        return String.valueOf(l / 100L) + "." + String.valueOf(l % 100L);
    }

    @Override
    public synchronized void continueprint(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);){
            if (shtrihFRKPrinter.open()) {
                shtrihFRKPrinter._waitToNoPrint(this.c, this.d);
                shtrihFRKPrinter.continuePrint();
                if (this.f) {
                    shtrihFRKPrinter.a();
                }
            }
            return;
        }
    }

    @Override
    public synchronized String purecommand(String string, String object) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        String string2 = "?";
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);){
            if (shtrihFRKPrinter.open() && (object = shtrihFRKPrinter.pureCmd((String)object)) != null) {
                string2 = ((BGByteBuffer)object).toString();
            }
        }
        return string2;
    }

    @Override
    public synchronized void repeatcheck(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);){
            if (shtrihFRKPrinter.open()) {
                shtrihFRKPrinter._waitToNoPrint(this.c, this.d);
                shtrihFRKPrinter.repeatDoc();
                if (this.f) {
                    shtrihFRKPrinter.a();
                }
            }
            return;
        }
    }

    @Override
    public synchronized void cancelcheck(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);){
            if (shtrihFRKPrinter.open()) {
                shtrihFRKPrinter.cancelCheck();
            }
            return;
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getStatus() {
        return "portName=" + this.a.getPortName() + ", baudRate = " + this.a.getBaudRate();
    }

    @Override
    public void openday(String string) throws PrinterConnectException, PrinterShtrihErrorException, DriverException {
        int n = FrkUtils.parseInt(string);
        try (ShtrihFRKPrinter shtrihFRKPrinter = new ShtrihFRKPrinter(this.a, this.b, n, g);){
            if (shtrihFRKPrinter.open()) {
                shtrihFRKPrinter._waitToNoPrint(this.c, this.d);
                shtrihFRKPrinter.openDay();
            }
            return;
        }
    }
}

