/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common.model;

import bitel.billing.common.TimeUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.bind.annotation.XmlAttribute;

public class Period
implements Comparable<Period> {
    private Date a;
    private Date b;

    public Period() {
    }

    public Period(Date date, Date date2) {
        this.a = date;
        this.b = date2;
    }

    public Period(int n, int n2, int n3, int n4) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n, n2, 1);
        gregorianCalendar.set(5, Math.max(n3, gregorianCalendar.getActualMinimum(5)));
        this.a = gregorianCalendar.getTime();
        gregorianCalendar.set(5, Math.min(n4, gregorianCalendar.getActualMaximum(5)));
        this.b = gregorianCalendar.getTime();
    }

    @XmlAttribute
    public Date getDateFrom() {
        return this.a;
    }

    public void setDateFrom(Date date) {
        this.a = date;
    }

    public int getMonthFrom() {
        int n = -1;
        if (this.a != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(this.a);
            n = gregorianCalendar.get(2) + 1;
        }
        return n;
    }

    public int getYearFrom() {
        int n = -1;
        if (this.a != null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(this.a);
            n = gregorianCalendar.get(1);
        }
        return n;
    }

    @XmlAttribute
    public Date getDateTo() {
        return this.b;
    }

    public void setDateTo(Date date) {
        this.b = date;
    }

    public Calendar getDateFromCalendar() {
        return TimeUtils.convertDateToCalendar(this.a);
    }

    public Calendar getDateToCalendar() {
        return TimeUtils.convertDateToCalendar(this.b);
    }

    public String toString() {
        return TimeUtils.formatPeriod(this);
    }

    @Override
    public int compareTo(Period period) {
        Date date = period != null && period.getDateFrom() != null ? period.getDateFrom() : null;
        Comparable<Date> comparable = period = period != null && period.getDateTo() != null ? period.getDateTo() : null;
        int n = this.a == null ? (date == null ? (this.b == null ? (period == null ? 0 : -1) : this.b.compareTo((Date)((Object)period))) : -1) : (date == null ? 1 : (this.a.equals(date) ? (this.b == null ? (period == null ? 0 : -1) : this.b.compareTo((Date)((Object)period))) : this.a.compareTo(date)));
        return n;
    }
}

