/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.common;

import bitel.billing.common.TimestampPrintStream;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.ThreadMXBean;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.InternetAddress;
import org.w3c.dom.Document;
import ru.bitel.bgbilling.common.BGException;
import ru.bitel.common.XMLUtils;
import ru.bitel.common.model.Id;
import ru.bitel.common.model.ListItem;
import ru.bitel.common.model.Period;

public class Utils {
    public static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    public static final char[] HEX_LOWERCASE = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final int MINUTE = 60;
    public static final int HOUR = 3600;
    public static final int DAY = 86400;
    public static final Pattern patternComma = Pattern.compile("\\s*,\\s*");
    public static final Pattern patternSemicolon = Pattern.compile("\\s*;\\s*");
    public static final Pattern patternColon = Pattern.compile("\\s*:\\s*");
    public static String PART = "sdlkfj9879fdgdf08098gdr09809g8d0fg09809d8fg0980d9f8g09809g809dfgsgsdfdsf98sd09f8sd0f8098sdf0";
    public static final String GUID_PREFIX = "GUID";
    public static final AtomicLong guidGenerator = new AtomicLong(System.nanoTime());
    private static final Provider a;
    private static final Pattern b;
    private static final String[] c;
    private static final Map<String, Set<String>> d;

    public static final boolean isEmptyString(String string) {
        return string == null || string.length() == 0;
    }

    public static final boolean isBlankString(String string) {
        return string == null || string.trim().length() == 0;
    }

    public static final boolean isZeroFilledArray(byte[] byArray) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == 0) continue;
            return false;
        }
        return true;
    }

    public static final boolean notEmptyString(String string) {
        return string != null && string.length() > 0;
    }

    public static final boolean notBlankString(String string) {
        return string != null && string.trim().length() > 0;
    }

    public static final String maskNull(String string) {
        if (string != null) {
            return string;
        }
        return "";
    }

    public static final <K> List<K> maskNull(List<K> list) {
        if (list != null) {
            return list;
        }
        return new ArrayList(5);
    }

    public static final BigDecimal maskNull(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            return bigDecimal;
        }
        return BigDecimal.ZERO;
    }

    public static final Long maskNull(Long l) {
        if (l != null) {
            return l;
        }
        return 0L;
    }

    public static final String maskBlank(String string, String string2) {
        if (Utils.isBlankString(string)) {
            return string2;
        }
        return string;
    }

    public static int parseInt(String string, int n) {
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static int parseInt(String string) {
        return Utils.parseInt(string, 0);
    }

    public static Integer parseInteger(String string, Integer n) {
        try {
            return Integer.valueOf(string);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public static long parseLong(String string, long l) {
        try {
            return Long.parseLong(string);
        }
        catch (Exception exception) {
            return l;
        }
    }

    public static long parseLong(String string) {
        return Utils.parseLong(string, 0L);
    }

    public static float parseFloat(String string, float f) {
        try {
            return Float.parseFloat(string);
        }
        catch (Exception exception) {
            return f;
        }
    }

    public static double parseDouble(String string, double d) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public static BigDecimal parseBigDecimal(String string, BigDecimal bigDecimal) {
        try {
            return new BigDecimal(string);
        }
        catch (Exception exception) {
            return bigDecimal;
        }
    }

    public static boolean parseBoolean(String string, boolean bl) {
        if (Utils.isBlankString(string)) {
            return bl;
        }
        return string.equals("1") || string.equalsIgnoreCase("true") || string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("on");
    }

    public static boolean parseBoolean(String string) {
        return Utils.parseBoolean(string, false);
    }

    public static Period parsePeriod(String object, String string, Period period) {
        if (object != null || string != null) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            if (object != null) {
                try {
                    object = simpleDateFormat.parse((String)object);
                    if (period == null) {
                        period = new Period();
                    }
                    period.setDateFrom((Date)object);
                }
                catch (ParseException parseException) {}
            }
            if (string != null) {
                try {
                    object = simpleDateFormat.parse(string);
                    if (period == null) {
                        period = new Period();
                    }
                    period.setDateTo((Date)object);
                }
                catch (ParseException parseException) {}
            }
        }
        return period;
    }

    public static final List<String> toList(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Utils.notBlankString(string)) {
            Collections.addAll(arrayList, patternComma.split(string.trim()));
        }
        return arrayList;
    }

    public static final List<String> toList(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Utils.notBlankString(string)) {
            Collections.addAll(arrayList, string.trim().split(string2));
        }
        return arrayList;
    }

    public static final List<Integer> toIntegerList(String stringArray) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (Utils.notBlankString((String)stringArray)) {
            String[] stringArray2 = patternComma.split((CharSequence)stringArray);
            stringArray = stringArray2;
            stringArray = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                arrayList.add(Utils.parseInt(string.trim()));
            }
        }
        return arrayList;
    }

    public static final int[] toIntArray(String stringArray) {
        int[] nArray = new int[]{};
        if (Utils.notBlankString((String)stringArray)) {
            int n = 0;
            stringArray = patternComma.split((CharSequence)stringArray);
            nArray = new int[stringArray.length];
            for (String string : stringArray) {
                nArray[n++] = Utils.parseInt(string.trim());
            }
        }
        return nArray;
    }

    public static final List<Long> toLongList(String stringArray) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (Utils.notBlankString((String)stringArray)) {
            String[] stringArray2 = patternComma.split((CharSequence)stringArray);
            stringArray = stringArray2;
            stringArray = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                arrayList.add(Utils.parseLong(string.trim()));
            }
        }
        return arrayList;
    }

    public static final Set<String> toSet(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        if (Utils.notBlankString(string)) {
            Collections.addAll(hashSet, patternComma.split(string.trim()));
        }
        return hashSet;
    }

    public static final Set<Integer> toIntegerSet(String stringArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        if (Utils.notBlankString((String)stringArray)) {
            String[] stringArray2 = patternComma.split((CharSequence)stringArray);
            stringArray = stringArray2;
            stringArray = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                hashSet.add(Utils.parseInt(string.trim()));
            }
        }
        return hashSet;
    }

    public static final Set<Long> toLongSet(String stringArray) {
        HashSet<Long> hashSet = new HashSet<Long>();
        if (Utils.notBlankString((String)stringArray)) {
            String[] stringArray2 = patternComma.split((CharSequence)stringArray);
            stringArray = stringArray2;
            stringArray = stringArray2;
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                hashSet.add(Utils.parseLong(string.trim()));
            }
        }
        return hashSet;
    }

    public static final String toString(Collection<?> collection) {
        return Utils.toString(collection, ",");
    }

    public static final String toString(Collection<?> collection, String string) {
        return Utils.toString(collection, string);
    }

    public static final String toString(Iterable<?> iterable) {
        return Utils.toString(iterable, ",");
    }

    public static final String toString(Iterable<?> object, String string) {
        if (object != null) {
            StringBuilder stringBuilder = new StringBuilder();
            object = object.iterator();
            while (object.hasNext()) {
                Object e = object.next();
                stringBuilder.append(e);
                stringBuilder.append(string);
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.setLength(stringBuilder.length() - string.length());
            }
            return stringBuilder.toString();
        }
        return "";
    }

    public static final String toString(Object[] objectArray, String string) {
        return Utils.toString(Arrays.asList(objectArray), string);
    }

    public static final String toString(Map<?, ?> map, String string) {
        return Utils.toString(map.entrySet(), string);
    }

    public static final String toString(List<?> list, int n) {
        return Utils.toString(list, ",", n);
    }

    public static final String toString(List<?> list, String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = list.size();
        while (n < n2) {
            stringBuilder.append(list.get(n));
            stringBuilder.append(string);
            ++n;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static final long enumToMask(String stringArray) {
        long l = 0L;
        if (stringArray != null) {
            stringArray = patternComma.split((CharSequence)stringArray);
            for (int i = 0; i < stringArray.length; ++i) {
                int n = Utils.parseInt(stringArray[i], -1);
                if (n < 0) continue;
                l |= 1L << n;
            }
        }
        return l;
    }

    public static String maskToEnum(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = 1L;
        for (int i = 0; i < 63; ++i) {
            if ((l & l2) == l2) {
                stringBuilder.append(i).append(',');
            }
            l2 <<= 1;
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public static String formatCost(float f) {
        return Utils.formatCost(f, 2);
    }

    public static String formatCost(BigDecimal bigDecimal) {
        return Utils.formatCost(bigDecimal, 2);
    }

    private static DecimalFormat a(int n) {
        StringBuilder stringBuilder = new StringBuilder("########0");
        if (n > 0) {
            stringBuilder.append(".");
        }
        for (int i = 0; i < n; ++i) {
            stringBuilder.append("0");
        }
        DecimalFormatSymbols decimalFormatSymbols = new DecimalFormatSymbols();
        decimalFormatSymbols.setDecimalSeparator('.');
        DecimalFormat decimalFormat = new DecimalFormat(stringBuilder.toString(), decimalFormatSymbols);
        return decimalFormat;
    }

    public static String formatCost(float f, int n) {
        return Utils.a(n).format(f);
    }

    public static String formatCost(BigDecimal bigDecimal, int n) {
        if (bigDecimal != null) {
            return Utils.a(n).format(bigDecimal);
        }
        return null;
    }

    public static String formatSessionCost(BigDecimal bigDecimal) {
        if (bigDecimal != null) {
            Cloneable cloneable = new DecimalFormatSymbols();
            cloneable.setDecimalSeparator('.');
            cloneable.setGroupingSeparator(' ');
            cloneable = new DecimalFormat("###,###,##0.00000", (DecimalFormatSymbols)cloneable);
            return ((Format)cloneable).format(bigDecimal);
        }
        return null;
    }

    public static String formatSessionCost(float f) {
        Cloneable cloneable = new DecimalFormatSymbols();
        cloneable.setDecimalSeparator('.');
        cloneable.setGroupingSeparator(' ');
        cloneable = new DecimalFormat("###,###,##0.00000", (DecimalFormatSymbols)cloneable);
        return ((NumberFormat)cloneable).format(f);
    }

    public static final String memoryStatus() {
        StringBuilder stringBuilder = new StringBuilder(50);
        DecimalFormat decimalFormat = new DecimalFormat("###,###,###,###");
        Object object = new DecimalFormatSymbols();
        ((DecimalFormatSymbols)object).setGroupingSeparator(' ');
        decimalFormat.setDecimalFormatSymbols((DecimalFormatSymbols)object);
        object = Runtime.getRuntime();
        stringBuilder.append("Memory total: ");
        stringBuilder.append(decimalFormat.format(((Runtime)object).totalMemory()));
        stringBuilder.append("; max: ");
        stringBuilder.append(decimalFormat.format(((Runtime)object).maxMemory()));
        stringBuilder.append("; free: ");
        stringBuilder.append(decimalFormat.format(((Runtime)object).freeMemory()));
        object = stringBuilder.append("\nMemory pools:");
        for (MemoryPoolMXBean memoryPoolMXBean : ManagementFactory.getMemoryPoolMXBeans()) {
            ((StringBuilder)object).append("\n  ");
            ((StringBuilder)object).append((Object)((Object)memoryPoolMXBean.getType()) + "[" + memoryPoolMXBean.getName() + "]: ");
            ((StringBuilder)object).append("max: ");
            ((StringBuilder)object).append(decimalFormat.format(memoryPoolMXBean.getUsage().getMax()));
            ((StringBuilder)object).append("; used: ");
            ((StringBuilder)object).append(decimalFormat.format(memoryPoolMXBean.getUsage().getUsed()));
            ((StringBuilder)object).append("; peek: ");
            ((StringBuilder)object).append(decimalFormat.format(memoryPoolMXBean.getPeakUsage().getUsed()));
        }
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        stringBuilder.append("\nThread count: ");
        stringBuilder.append(threadMXBean.getThreadCount());
        return stringBuilder.toString();
    }

    public static String bytesToHexString(byte[] byArray) {
        return Utils.bytesToString(byArray, true, null);
    }

    public static byte[] hexStringToBytes(String string) {
        return Utils.stringToBytes(string, " ");
    }

    public static String bytesToString(byte[] byArray) {
        return Utils.bytesToString(byArray, true, " ");
    }

    public static String bytesToString(byte[] byArray, boolean bl, String string) {
        StringBuilder stringBuilder;
        int n;
        char[] cArray;
        if (byArray == null || byArray.length == 0) {
            return "";
        }
        char[] cArray2 = cArray = bl ? HEX : HEX_LOWERCASE;
        if (string != null && (n = string.length()) > 0) {
            stringBuilder = new StringBuilder(byArray.length * (n + 2));
            int n2 = byArray.length;
            for (int i = 0; i < n2; ++i) {
                if (i > 0) {
                    stringBuilder.append(string);
                }
                stringBuilder.append(cArray[(byArray[i] & 0xF0) >> 4]);
                stringBuilder.append(cArray[byArray[i] & 0xF]);
            }
        } else {
            stringBuilder = new StringBuilder(byArray.length << 1);
            int n3 = byArray.length;
            for (int i = 0; i < n3; ++i) {
                stringBuilder.append(cArray[(byArray[i] & 0xF0) >> 4]);
                stringBuilder.append(cArray[byArray[i] & 0xF]);
            }
        }
        return stringBuilder.toString();
    }

    public static byte[] stringToBytes(String string, String object) {
        byte[] byArray;
        int n;
        int n2;
        if (Utils.isBlankString(string)) {
            return null;
        }
        if (Utils.notEmptyString((String)object) && (n2 = ((StringTokenizer)(object = new StringTokenizer(string, (String)object))).countTokens()) > 1) {
            byte[] byArray2 = new byte[n2];
            int n3 = 0;
            try {
                while (((StringTokenizer)object).hasMoreTokens()) {
                    byArray2[n3++] = (byte)Integer.parseInt(((StringTokenizer)object).nextToken().trim(), 16);
                }
            }
            catch (Exception exception) {
                Exception exception2 = exception;
                exception.printStackTrace();
            }
            return byArray2;
        }
        int n4 = string.length();
        if (n4 % 2 == 0) {
            n = 0;
            n2 = 0;
            byArray = new byte[n4 / 2];
        } else {
            n = 1;
            n2 = 1;
            byte[] byArray3 = new byte[n4 / 2 + 1];
            byArray = byArray3;
            byArray3[0] = (byte)Character.digit(string.charAt(0), 16);
        }
        while (n2 < n4) {
            int n5 = Character.digit(string.charAt(n2++), 16);
            int n6 = Character.digit(string.charAt(n2++), 16);
            byArray[n++] = (byte)((n5 << 4) + n6);
        }
        return byArray;
    }

    public static byte[] byteBufferAsArray(ByteBuffer byteBuffer) {
        return Utils.byteBufferAsArray(byteBuffer, byteBuffer.capacity());
    }

    public static byte[] byteBufferAsArray(ByteBuffer byteBuffer, int n) {
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        byteBuffer.rewind();
        return byArray;
    }

    public static final Set<Integer> getIdSet(Collection<? extends Id> object) {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        object = object.iterator();
        while (object.hasNext()) {
            Id id = (Id)object.next();
            hashSet.add(id.getId());
        }
        return hashSet;
    }

    public static final String getSystemVariables() {
        StringBuilder stringBuilder = new StringBuilder();
        Map<String, String> map = System.getenv();
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            String object = (String)entry.getValue();
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(object);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static final String getJavaProperties() {
        StringBuilder stringBuilder = new StringBuilder();
        Properties properties = System.getProperties();
        for (Map.Entry entry : properties.entrySet()) {
            String string = entry.getKey().toString();
            String object = entry.getValue().toString();
            stringBuilder.append(string);
            stringBuilder.append("=");
            stringBuilder.append(object);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public static <I> I newInstance(String object, Class<? extends I> clazz) throws BGException {
        try {
            object = Class.forName((String)object);
            return ((Class)object).asSubclass(clazz).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
        catch (Exception exception) {
            throw new BGException(exception);
        }
    }

    public static byte[] getDigestBytes(byte[] byArray) {
        byte[] byArray2 = null;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            messageDigest.update(byArray);
            byArray2 = messageDigest.digest();
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
        }
        return byArray2;
    }

    public static String getDigest(String string, String string2) {
        return Utils.getDigest(string, string2, "MD5");
    }

    public static String getDigest(String object, String string, String object2) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            object2 = MessageDigest.getInstance((String)object2);
            ((MessageDigest)object2).update(string == null ? ((String)object).getBytes() : ((String)object).getBytes(string));
            object = ((MessageDigest)object2).digest();
            for (int i = 0; i < ((Object)object).length; ++i) {
                stringBuffer.append(HEX[(object[i] & 0xF0) >> 4]);
                stringBuffer.append(HEX[object[i] & 0xF]);
            }
        }
        catch (Exception exception) {}
        if (stringBuffer.length() == 0) {
            return null;
        }
        return stringBuffer.toString();
    }

    public static String swapWords(String charSequence) {
        charSequence = new StringBuilder((String)charSequence);
        int n = ((StringBuilder)charSequence).length();
        for (int i = 0; i < n - 1; i += 2) {
            char c = ((StringBuilder)charSequence).charAt(i);
            char c2 = ((StringBuilder)charSequence).charAt(i + 1);
            ((StringBuilder)charSequence).setCharAt(i, c2);
            ((StringBuilder)charSequence).setCharAt(i + 1, c);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static final int pageCount(int n, int n2) {
        if (n % n2 == 0) {
            return n / n2;
        }
        return n / n2 + 1;
    }

    public static final String pairToString(List<String[]> list) {
        return Utils.pairToString(list, ",", "=");
    }

    public static final String pairHashToString(Map<String, String> object) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>(object.size());
        for (Map.Entry entry : object.entrySet()) {
            arrayList.add(new String[]{(String)entry.getKey(), (String)entry.getValue()});
        }
        return Utils.pairToString(arrayList, ",", "=");
    }

    public static final String pairToString(List<String[]> object, String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        object = object.iterator();
        while (object.hasNext()) {
            String[] stringArray = (String[])object.next();
            if (stringBuilder.length() > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(stringArray[0]);
            stringBuilder.append(string2);
            stringBuilder.append(stringArray[1]);
        }
        return stringBuilder.toString();
    }

    public static final List<String[]> stringToPairs(String string) {
        return Utils.stringToPairs(string, ",;", "=");
    }

    public static final Map<String, String> stringToPairsHash(String iterator) {
        iterator = Utils.stringToPairs((String)((Object)iterator), ",;", "=");
        HashMap<String, String> hashMap = new HashMap<String, String>(iterator.size());
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            String[] stringArray = (String[])iterator.next();
            hashMap.put(stringArray[0], stringArray[1]);
        }
        return hashMap;
    }

    public static final List<String[]> stringToPairs(String object, String stringArray, String string) {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        object = new StringTokenizer((String)object, (String)stringArray);
        while (((StringTokenizer)object).hasMoreTokens()) {
            stringArray = ((StringTokenizer)object).nextToken().trim();
            if ((stringArray = stringArray.split("\\s*" + string + "\\s*")).length != 2) continue;
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    public static byte[] readByBlock(InputStream object) throws IOException {
        int n;
        object = new BufferedInputStream((InputStream)object);
        Vector<byte[]> vector = new Vector<byte[]>(5, 5);
        Vector<Integer> vector2 = new Vector<Integer>(5, 5);
        int n2 = 0;
        do {
            byte[] byArray;
            if ((n = ((BufferedInputStream)object).read(byArray = new byte[1024], 0, 1024)) <= 0) continue;
            n2 += n;
            vector.addElement(byArray);
            vector2.addElement(n);
        } while (n != -1);
        int n3 = 0;
        object = new byte[n2];
        for (n2 = 0; n2 < vector.size(); ++n2) {
            n = (Integer)vector2.elementAt(n2);
            System.arraycopy(vector.elementAt(n2), 0, object, n3, n);
            n3 += n;
        }
        return object;
    }

    public static boolean flush(InputStream inputStream, OutputStream outputStream) throws IOException {
        int n;
        boolean bl = false;
        byte[] byArray = new byte[1024];
        while ((n = inputStream.read(byArray)) != -1) {
            outputStream.write(byArray, 0, n);
            bl = true;
        }
        return bl;
    }

    public static void readFullBuffer(Reader reader, char[] cArray) throws IOException {
        int n;
        int n2 = 0;
        int n3 = cArray.length;
        do {
            if ((n = reader.read(cArray, n2, n3)) == -1) {
                throw new IOException("insufficient length of data (" + cArray.length + " bytes needed, " + n2 + " was read)");
            }
            n2 += n;
        } while ((n3 -= n) != 0);
    }

    public static void readFullBuffer(InputStream inputStream, byte[] byArray) throws IOException {
        int n;
        int n2 = 0;
        int n3 = byArray.length;
        do {
            if ((n = inputStream.read(byArray, n2, n3)) == -1) {
                throw new IOException("insufficient length of data (" + byArray.length + " bytes needed, " + n2 + " was read)");
            }
            n2 += n;
        } while ((n3 -= n) != 0);
    }

    public static String getMessage(Document document) {
        return XMLUtils.selectText(document, "/data/text()", "");
    }

    public static final String multiLetter(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public static String randomAlphanumeric(int n) {
        if (n == 0) {
            return "";
        }
        if (n < 0) {
            throw new IllegalArgumentException("Requested random string length " + n + " is less than 0.");
        }
        Random random = new Random();
        char[] cArray = new char[n];
        while (n-- != 0) {
            char c = (char)(random.nextInt(91) + 32);
            if (Character.isLetter(c) || Character.isDigit(c)) {
                if (c >= '\udc00' && c <= '\udfff') {
                    if (n != 0) {
                        cArray[n] = c;
                        cArray[--n] = (char)(55296 + random.nextInt(128));
                        continue;
                    }
                } else if (c >= '\ud800' && c <= '\udb7f') {
                    if (n != 0) {
                        cArray[n] = (char)(56320 + random.nextInt(128));
                        cArray[--n] = c;
                        continue;
                    }
                } else if (c < '\udb80' || c > '\udbff') {
                    cArray[n] = c;
                    continue;
                }
            }
            ++n;
        }
        return new String(cArray);
    }

    @Deprecated
    public static final int BuToI(byte by) {
        return Utils.unsignedByteToInt(by);
    }

    @Deprecated
    public static long IuTol(int n) {
        return Utils.unsignedIntToLong(n);
    }

    @Deprecated
    public static final long IuToL(int n) {
        return Utils.unsignedIntToLong(n);
    }

    public static final int unsignedByteToInt(byte n) {
        int n2 = n;
        if (n < 0) {
            n2 = n & 0xFF;
            n2 |= 0x80;
        }
        return n2;
    }

    public static final long unsignedIntToLong(int n) {
        long l = n;
        if (l < 0L) {
            l &= 0xFFFFFFFFL;
            l |= 0x80000000L;
        }
        return l;
    }

    public static int convertBytesToInt(byte[] byArray) {
        int n = 0;
        if (byArray != null && byArray.length == 4) {
            n = 0xFF & byArray[3] | 0xFF00 & byArray[2] << 8 | 0xFF0000 & byArray[1] << 16 | 0xFF000000 & byArray[0] << 24;
        }
        return n;
    }

    public static long convertBytesToLong(byte[] byArray) {
        long l = ((long)byArray[0] & 0xFFL) << 56 | ((long)byArray[1] & 0xFFL) << 48 | ((long)byArray[2] & 0xFFL) << 40 | ((long)byArray[3] & 0xFFL) << 32 | ((long)byArray[4] & 0xFFL) << 24 | ((long)byArray[5] & 0xFFL) << 16 | ((long)byArray[6] & 0xFFL) << 8 | (long)byArray[7] & 0xFFL;
        return l;
    }

    public static byte[] convertIntToBytes(int n) {
        return Utils.a(n, 4);
    }

    public static byte[] convertLongToBytes(long l) {
        return Utils.a(l, 8);
    }

    private static byte[] a(long l, int n) {
        byte[] byArray = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray[n - 1 - i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return byArray;
    }

    public static String formatBigDecimal(BigDecimal bigDecimal, int n) {
        return Utils.maskNull(bigDecimal).setScale(n, 4).toString();
    }

    public static String formatBigDecimalSumm(BigDecimal bigDecimal) {
        return Utils.maskNull(bigDecimal).setScale(2, 4).toString();
    }

    public static BigDecimal roundBigDecimalSumm(BigDecimal bigDecimal) {
        return bigDecimal.setScale(2, 4);
    }

    public static final boolean checkMacAddres(String object) {
        boolean bl = object != null && ((String)object).trim().length() == 17;
        object = new StringTokenizer((String)object, "-: ");
        while (((StringTokenizer)object).hasMoreTokens()) {
            String string = ((StringTokenizer)object).nextToken().trim();
            try {
                Integer.parseInt(string, 16);
            }
            catch (Exception exception) {
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static final byte[] removeZeroTail(byte[] byArray) {
        byte[] byArray2;
        int n = 0;
        int n2 = byArray.length;
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] != 0) continue;
            n = i;
            break;
        }
        if (n == 0) {
            byArray2 = byArray;
        } else {
            byArray2 = new byte[n];
            System.arraycopy(byArray, 0, byArray2, 0, n);
        }
        return byArray2;
    }

    public static final String booleanToStringInt(boolean bl) {
        if (bl) {
            return "1";
        }
        return "0";
    }

    public static String formatPhoneNumber(String string) {
        StringBuilder stringBuilder;
        block7: {
            int n;
            stringBuilder = new StringBuilder();
            if (string == null || string.length() <= 0) break block7;
            for (n = 0; n < string.length(); ++n) {
                if (Character.isDigit(string.charAt(n))) continue;
                return string;
            }
            if (string.charAt(0) == '7' && string.length() == 11) {
                for (n = 0; n < string.length(); ++n) {
                    if (n == 1 || n == 4 || n == 7 || n == 9) {
                        stringBuilder.append('-');
                    }
                    stringBuilder.append(string.charAt(n));
                }
            } else {
                for (n = 0; n < string.length(); ++n) {
                    if ((n + string.length() % 2) % 2 == 0 && n > 0) {
                        stringBuilder.append('-');
                    }
                    stringBuilder.append(string.charAt(n));
                }
            }
        }
        return stringBuilder.toString().replace('\u0000', ' ');
    }

    public static boolean isArrayString(String object) {
        if (Utils.isEmptyString((String)object)) {
            return true;
        }
        return !((Matcher)(object = b.matcher((CharSequence)object))).find();
    }

    public static final void setTimestampStreams() {
        System.setOut(new TimestampPrintStream(System.out));
        System.setErr(new TimestampPrintStream(System.err));
    }

    public static String deleteAfterDog(String string) {
        int n;
        String string2 = string;
        if (string != null && (n = string.indexOf("@")) > 0) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public static String deleteBeforeSharp(String string) {
        int n;
        String string2 = string;
        if (string != null && (n = string.indexOf("#")) >= 0) {
            string2 = string.substring(n + 1, string.length());
        }
        return string2;
    }

    public static String formatSessionTime(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        if (n / 3600 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n / 3600);
        stringBuilder.append(':');
        if (n % 3600 / 60 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n % 3600 / 60);
        stringBuilder.append(':');
        if (n % 60 < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n % 60);
        stringBuilder.append(" [").append(n).append(']');
        return stringBuilder.toString();
    }

    public static String charsetConvert(String string, String string2) {
        if (string != null) {
            try {
                string = new String(string.getBytes("ISO-8859-1"), string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return string;
    }

    public static String toTranslit(String charSequence) {
        char[] cArray = ((String)charSequence).toCharArray();
        charSequence = new StringBuilder(((String)charSequence).length());
        for (char c : cArray) {
            int n = c - 1025;
            if (n >= 0 && n < 81) {
                String string = Utils.c[n];
                ((StringBuilder)charSequence).append(string == null ? Character.valueOf(c) : string);
                continue;
            }
            ((StringBuilder)charSequence).append(c);
        }
        return ((StringBuilder)charSequence).toString();
    }

    public static String getMD4Digest(String object, String charSequence) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        object = Utils.getMD4Digest(((String)object).getBytes((String)charSequence));
        charSequence = new StringBuffer();
        for (int i = 0; i < ((Object)object).length; ++i) {
            Object object2 = object[i] < 0 ? (Object)(256 + object[i]) : object[i];
            String string = Integer.toHexString((int)object2);
            if (string.length() == 1) {
                string = "0" + string;
            }
            ((StringBuffer)charSequence).append(string);
        }
        return ((StringBuffer)charSequence).toString();
    }

    public static MessageDigest newMD4() throws NoSuchAlgorithmException {
        if (a == null) {
            return MessageDigest.getInstance("MD4");
        }
        return MessageDigest.getInstance("MD4", a);
    }

    public static byte[] getMD4Digest(byte[] byArray) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = Utils.newMD4();
        byArray = messageDigest.digest(byArray);
        return byArray;
    }

    public static boolean checkEmail(String string) {
        boolean bl = true;
        try {
            new InternetAddress(string);
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public static <E extends Enum<E>> E getListItemEnumFromId(Class<E> enumArray, int n, E e) {
        for (Enum enum_ : (Enum[])enumArray.getEnumConstants()) {
            if (((ListItem)((Object)enum_)).getId() != n) continue;
            return (E)enum_;
        }
        return e;
    }

    public static <E extends Enum<E>> E getListItemEnumFromId(Class<E> clazz, int n) {
        return Utils.getListItemEnumFromId(clazz, n, null);
    }

    public static String unpackValues(long l, int n) {
        StringBuffer stringBuffer = new StringBuffer("*");
        if (l > 0L) {
            stringBuffer.delete(0, 1);
            int n2 = 0;
            int n3 = 0;
            for (long i = 1L; i <= l; i <<= 1) {
                boolean bl = (l & i) > 0L;
                if (bl && n2 == 0) {
                    stringBuffer.append(stringBuffer.length() == 0 ? "" + (n3 + n) : "," + (n3 + n));
                    ++n2;
                } else if (bl && n2 > 0) {
                    ++n2;
                } else {
                    if (!bl && n2 > 1) {
                        stringBuffer.append("-" + (n3 - 1 + n));
                    }
                    n2 = 0;
                }
                ++n3;
            }
            if (n2 > 1) {
                stringBuffer.append("-" + (n3 - 1 + n));
            }
        }
        return stringBuffer.toString();
    }

    public static long packValues(Collection<String> object, int n) {
        long l = 0L;
        if (object != null) {
            object = object.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                try {
                    int n2 = string.indexOf("-");
                    if (n2 != -1) {
                        int n3 = Integer.parseInt(string.substring(0, n2));
                        int n4 = Integer.parseInt(string.substring(n2 + 1));
                        if (n3 < 0 || n4 < 0 || n3 > n4) continue;
                        for (n2 = n3; n2 <= n4; ++n2) {
                            l += 1L << n2 - n;
                        }
                        continue;
                    }
                    l += 1L << Integer.parseInt(string) - n;
                }
                catch (Exception exception) {}
            }
        }
        return l;
    }

    public static final Object convert(Object object, Class<?> clazz) {
        if (object instanceof Number) {
            return Utils.convert((Number)object, clazz);
        }
        if (object instanceof String || object == null) {
            return Utils.convert((String)object, clazz);
        }
        throw new IllegalArgumentException();
    }

    public static final Object convert(Number number, Class<?> clazz) {
        if (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE)) {
            return number.intValue();
        }
        if (clazz.equals(Long.class) || clazz.equals(Long.TYPE)) {
            return number.longValue();
        }
        if (clazz.equals(Float.class) || clazz.equals(Float.TYPE)) {
            return Float.valueOf(number.floatValue());
        }
        if (clazz.equals(Double.class) || clazz.equals(Double.TYPE)) {
            return number.doubleValue();
        }
        return 0;
    }

    public static final Object convert(String string, Class<?> serializable) {
        if (serializable.equals(String.class)) {
            return string;
        }
        if (serializable.equals(BigDecimal.class)) {
            return Utils.parseBigDecimal(string, BigDecimal.ZERO);
        }
        if (serializable.equals(Integer.class) || serializable.equals(Integer.TYPE)) {
            return Utils.parseInt(string, 0);
        }
        if (serializable.equals(Long.class) || serializable.equals(Long.TYPE)) {
            return Utils.parseLong(string, 0L);
        }
        if (serializable.equals(Float.class) || serializable.equals(Float.TYPE)) {
            return Float.valueOf(Utils.parseFloat(string, 0.0f));
        }
        if (serializable.equals(Double.class) || serializable.equals(Double.TYPE)) {
            return Utils.parseDouble(string, 0.0);
        }
        if (serializable.equals(Date.class)) {
            serializable = null;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd.MM.yyyy");
            if (string != null) {
                try {
                    serializable = simpleDateFormat.parse(string);
                }
                catch (Exception exception) {}
            }
            return serializable;
        }
        return null;
    }

    public static String checkPath(String string) {
        if (string != null) {
            if (!(string = string.replace('\\', '/')).endsWith("/")) {
                string = string + "/";
            }
            return string;
        }
        return null;
    }

    public static String escapeHTML(String string) {
        int n;
        int n2;
        int n3;
        int n4 = n3 = string.length();
        boolean bl = false;
        block18: for (int i = 0; i < n3; ++i) {
            n2 = string.charAt(i);
            n = 0xFFFF & n2;
            if (n < 32) {
                switch (n2) {
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: {
                        break;
                    }
                    default: {
                        --n4;
                        bl = true;
                        break;
                    }
                }
                continue;
            }
            switch (n2) {
                case 34: {
                    n4 += 5;
                    bl = true;
                    continue block18;
                }
                case 38: 
                case 39: {
                    n4 += 4;
                    bl = true;
                    continue block18;
                }
                case 60: 
                case 62: {
                    n4 += 3;
                    bl = true;
                }
            }
        }
        if (!bl) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n4);
        block19: for (n2 = 0; n2 < n3; ++n2) {
            n = string.charAt(n2);
            n4 = 0xFFFF & n;
            if (n4 < 32) {
                switch (n) {
                    case 9: 
                    case 10: 
                    case 12: 
                    case 13: {
                        stringBuffer.append((char)n);
                        break;
                    }
                }
                continue;
            }
            switch (n) {
                case 34: {
                    stringBuffer.append("&quot;");
                    continue block19;
                }
                case 39: {
                    stringBuffer.append("&#39;");
                    continue block19;
                }
                case 38: {
                    stringBuffer.append("&amp;");
                    continue block19;
                }
                case 60: {
                    stringBuffer.append("&lt;");
                    continue block19;
                }
                case 62: {
                    stringBuffer.append("&gt;");
                    continue block19;
                }
                default: {
                    stringBuffer.append((char)n);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void checkJava() throws BGException {
        String string = "";
        Object object = System.getProperty("java.specification.version");
        if (!d.get("6.2").contains(object)) {
            string = string + "\u0421\u043f\u0435\u0446\u0438\u0444\u0438\u043a\u0430\u0446\u0438\u044f " + (String)object + " \u043d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f (\u043f\u043e\u0434\u0434\u0435\u0440\u0436\u0438\u0432\u0430\u0435\u0442\u0441\u044f " + Utils.toString((Collection)d.get("6.2")) + ")\n";
        }
        if (!((String)(object = System.getProperty("java.vm.name"))).startsWith("Java HotSpot")) {
            string = string + "\u0412\u0438\u0440\u0442\u0443\u0430\u043b\u044c\u043d\u0430\u044f \u043c\u0430\u0448\u0438\u043d\u0430 " + (String)object + " \u043d\u0435 \u0440\u0435\u043a\u043e\u043c\u0435\u043d\u0434\u0443\u0435\u0442\u0441\u044f\n";
        }
        object = new SimpleDateFormat("HZ");
        ((DateFormat)object).setTimeZone(TimeZone.getTimeZone("Asia/Yekaterinburg"));
        if (!(((DateFormat)object).format(new Date(1314567890000L)).equals("3+0600") && ((DateFormat)object).format(new Date(1324567890000L)).equals("21+0600") && ((DateFormat)object).format(new Date(1412888888666L)).equals("3+0600") && ((DateFormat)object).format(new Date(1414888888666L)).equals("5+0500"))) {
            string = string + "\u041d\u0435\u043e\u0431\u0445\u043e\u0434\u0438\u043c\u043e \u0441\u0440\u043e\u0447\u043d\u043e \u043e\u0431\u043d\u043e\u0432\u0438\u0442\u044c \u0442\u0430\u0439\u043c\u0437\u043e\u043d\u044b\n";
        }
        if (!string.isEmpty()) {
            throw new BGException(string);
        }
    }

    public static String getOsJavaVersion(boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(50);
        if (!bl) {
            stringBuilder.append("os: " + System.getProperty("os.name") + "; java: " + System.getProperty("java.vm.name") + ", v." + System.getProperty("java.version"));
        } else {
            stringBuilder.append("os: " + System.getProperty("os.name") + " " + System.getProperty("os.arch") + ", " + System.getProperty("os.version") + "\n");
            stringBuilder.append("java: " + System.getProperty("java.vm.name") + ", v." + System.getProperty("java.version") + "\n");
            stringBuilder.append("jre home: " + System.getProperty("java.home"));
        }
        return stringBuilder.toString();
    }

    public static String guid() {
        return GUID_PREFIX + guidGenerator.decrementAndGet();
    }

    public static <T extends Enum<T>> T parseEnum(Class<T> clazz, String string, T t) {
        try {
            if (string == null || string.length() == 0) {
                return t;
            }
            return Enum.valueOf(clazz, string.trim());
        }
        catch (Exception exception) {
            return t;
        }
    }

    public static DecimalFormat getDecimalFormatSumma() {
        return new DecimalFormat("###,###,###,##0.00");
    }

    public static String checkCanReadFiles(File[] fileArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : fileArray) {
            if (file.canRead()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(Utils.a(file, 80));
        }
        if (stringBuilder.length() > 0) {
            return stringBuilder.toString();
        }
        return null;
    }

    public static String getNamesFiles(File[] fileArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : fileArray) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(Utils.a(file, 80)).append(" [").append(file.length() / 1024L).append("\u043a\u0431]");
        }
        return stringBuilder.toString();
    }

    public static String maskEmail(String stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray2 = stringArray.split("@");
        stringArray = stringArray2;
        stringArray = stringArray2;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            String[] stringArray3 = stringArray[i];
            if (stringBuilder.length() > 0) {
                stringBuilder.append('@');
            }
            for (String string : stringArray3.split("\\.")) {
                if (stringBuilder.length() > 0 && !stringBuilder.toString().endsWith("@")) {
                    stringBuilder.append('.');
                }
                StringBuilder stringBuilder2 = new StringBuilder();
                if (string != null) {
                    if (string.length() > 2) {
                        stringBuilder2.append(string.charAt(0));
                        for (int j = 1; j < string.length() - 1; ++j) {
                            stringBuilder2.append('*');
                        }
                        stringBuilder2.append(string.charAt(string.length() - 1));
                    } else {
                        stringBuilder2.append(string);
                    }
                }
                stringBuilder.append(stringBuilder2.toString());
            }
        }
        return stringBuilder.toString();
    }

    public static String maskPhoneNumber(String string, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        if (string != null) {
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < string.length(); ++n3) {
                if (!Character.isDigit(string.charAt(n3))) continue;
                ++n4;
            }
            n3 = n4 - n - n2;
            if (n3 < 0) {
                n3 = 0;
            }
            for (n2 = 0; n2 < string.length(); ++n2) {
                char c = string.charAt(n2);
                n4 = c;
                if (Character.isDigit(c)) {
                    if (n > 0) {
                        --n;
                    } else if (n3 > 0) {
                        n4 = 42;
                        --n3;
                    }
                }
                stringBuilder.append((char)n4);
            }
        }
        return stringBuilder.toString();
    }

    public static String maskConfidential(String string) {
        String string2 = null;
        if (Utils.notBlankString(string)) {
            for (int i = 0; i < string.length(); ++i) {
                string2 = string2 + '*';
            }
        }
        return string2;
    }

    private static String a(File object, int n) {
        if (((String)(object = ((File)object).toString())).length() > 80) {
            return ((String)object).substring(0, 38) + "..." + ((String)object).substring(((String)object).length() - 40 - 2);
        }
        return object;
    }

    public static String htmlEncode(String string, String string2) {
        try {
            return URLEncoder.encode(string, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException(unsupportedEncodingException);
        }
    }

    public static final String insertBOM() {
        return "\ufeff";
    }

    static {
        Provider provider = null;
        try {
            MessageDigest.getInstance("MD4");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            Provider provider2 = provider = new Provider("MD4Provider", 1.0, "MD4 MessageDigest"){};
            AccessController.doPrivileged(new PrivilegedAction<Void>(provider2){
                private /* synthetic */ Provider a;
                {
                    this.a = provider;
                }

                @Override
                public final /* synthetic */ Object run() {
                    2 var1_1 = this;
                    var1_1.a.put("MessageDigest.MD4", "sun.security.provider.MD4");
                    return null;
                }
            });
        }
        a = provider;
        b = Pattern.compile("[a-zA-Z;]+");
        String[] stringArray = new String[81];
        c = stringArray;
        stringArray[15] = "A";
        Utils.c[16] = "B";
        Utils.c[17] = "V";
        Utils.c[18] = "G";
        Utils.c[19] = "D";
        Utils.c[20] = "E";
        Utils.c[0] = "E";
        Utils.c[21] = "ZH";
        Utils.c[22] = "Z";
        Utils.c[23] = "I";
        Utils.c[24] = "I";
        Utils.c[25] = "K";
        Utils.c[26] = "L";
        Utils.c[27] = "M";
        Utils.c[28] = "N";
        Utils.c[29] = "O";
        Utils.c[30] = "P";
        Utils.c[31] = "R";
        Utils.c[32] = "S";
        Utils.c[33] = "T";
        Utils.c[34] = "U";
        Utils.c[35] = "F";
        Utils.c[36] = "H";
        Utils.c[37] = "C";
        Utils.c[38] = "CH";
        Utils.c[39] = "SH";
        Utils.c[40] = "SH";
        Utils.c[41] = "'";
        Utils.c[42] = "Y";
        Utils.c[43] = "'";
        Utils.c[44] = "E";
        Utils.c[45] = "U";
        Utils.c[46] = "YA";
        for (int i = 0; i < 81; ++i) {
            char c = (char)((char)i + 1025);
            c = new String(new char[]{c}).toLowerCase().charAt(0);
            if (Utils.c[i] == null) continue;
            Utils.c[c - 1025] = Utils.c[i].toLowerCase();
        }
        d = new HashMap<String, Set<String>>(){
            {
                this.put("5.1", new HashSet<String>(this){
                    {
                        this.add("1.6");
                    }
                });
                this.put("5.2", new HashSet<String>(this){
                    {
                        this.add("1.6");
                        this.add("1.7");
                    }
                });
                this.put("6.0", new HashSet<String>(this){
                    {
                        this.add("1.6");
                        this.add("1.7");
                    }
                });
                this.put("6.1", new HashSet<String>(this){
                    {
                        this.add("1.7");
                    }
                });
                this.put("6.2", new HashSet<String>(this){
                    {
                        this.add("1.8");
                    }
                });
                this.put("6.3", new HashSet<String>(this){
                    {
                        this.add("1.8");
                    }
                });
            }
        };
    }
}

