/*
 * Decompiled with CFR 0.152.
 */
package ru.bitel.bgbilling.modules.voiceip.server.action;

import jakarta.servlet.http.HttpServletResponse;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.StringTokenizer;
import java.util.Vector;
import ru.bitel.bgbilling.modules.voiceip.server.action.base.ActionBase;
import ru.bitel.common.TimeUtils;

public class ActionLoadTariff
extends ActionBase {
    public void doAction() throws Exception {
        int tpid = this.getIntParameter("tpid", -1);
        int mid = this.getIntParameter("mid", -1);
        String data = this.getParameter("data");
        Date date = this.getDateParameter("date");
        Vector<String> wrongLines = new Vector<String>();
        Vector<String> createdDest = new Vector<String>();
        Vector<String> updatedPrices = new Vector<String>();
        Vector<String> createdPrices = new Vector<String>();
        StringBuffer report = new StringBuffer();
        if (tpid > 0 & data != null && mid > 0 && date != null) {
            StringTokenizer st = new StringTokenizer(data, "\n");
            int count = 0;
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                StringTokenizer elements = new StringTokenizer(line, "\t");
                if (elements.countTokens() != 4) continue;
                try {
                    int destCode = Integer.parseInt(elements.nextToken().trim());
                    String destTitle = elements.nextToken().trim();
                    int prefix = Integer.parseInt(elements.nextToken().trim());
                    float cost = Float.parseFloat(elements.nextToken().replace(',', '.').trim());
                    String query = "DELETE FROM voiceip_dest_" + mid + " WHERE id=?";
                    PreparedStatement ps = this.con.prepareStatement(query);
                    ps.setInt(1, destCode);
                    if (ps.executeUpdate() == 0) {
                        createdDest.add(line);
                    }
                    ps.close();
                    query = "INSERT INTO voiceip_dest_" + mid + "( id, title ) VALUES (?, ?, ?)";
                    ps = this.con.prepareStatement(query);
                    ps.setInt(1, destCode);
                    ps.setString(2, destTitle);
                    ps.executeUpdate();
                    ps.close();
                    query = "SELECT cost, date1, id FROM voiceip_outgoing_tariff_" + mid + "WHERE dest=? AND tariff=? AND prefix=? LIMIT 1";
                    ps = this.con.prepareStatement(query);
                    ps.setInt(1, destCode);
                    ps.setInt(2, tpid);
                    ps.setInt(3, prefix);
                    ResultSet rs = ps.executeQuery();
                    boolean needInsert = false;
                    if (rs.next()) {
                        if (rs.getFloat(1) != cost) {
                            if (rs.getDate(2).equals(date)) {
                                query = "DELETE FROM voiceip_outgoing_tariff_" + mid + " WHERE id=?";
                                ps = this.con.prepareStatement(query);
                                ps.setInt(1, rs.getInt(3));
                                ps.executeUpdate();
                            } else {
                                query = "UPDATE voiceip_outgoing_tariff_" + mid + " SET date2=DATE_SUB( ?, INTERVAL 1 DAY ) WHERE id=?";
                                ps = this.con.prepareStatement(query);
                                ps.setDate(1, TimeUtils.convertDateToSqlDate((Date)date));
                                ps.setInt(2, rs.getInt(3));
                                ps.executeUpdate();
                            }
                            needInsert = true;
                            updatedPrices.add(line);
                        }
                    } else {
                        needInsert = true;
                        createdPrices.add(line);
                    }
                    rs.close();
                    ps.close();
                    if (needInsert) {
                        query = "INSERT INTO voiceip_outgoing_tariff_" + mid + " (tariff, dest, prefix, date1, cost) VALUES(?, ? ,?, ?, ?)";
                        ps = this.con.prepareStatement(query);
                        ps.setInt(1, tpid);
                        ps.setInt(2, destCode);
                        ps.setInt(3, prefix);
                        ps.setDate(4, TimeUtils.convertDateToSqlDate((Date)date));
                        ps.setFloat(5, cost);
                        ps.executeUpdate();
                    }
                    ++count;
                }
                catch (Exception ex) {
                    wrongLines.add(line);
                    ex.printStackTrace();
                }
            }
            report = this.prepareReport(wrongLines, createdDest, updatedPrices, createdPrices, count, date);
        } else {
            report.append("\u0422\u0430\u0440\u0438\u0444\u044b \u043d\u0435 \u0431\u044b\u043b\u0438 \u0437\u0430\u043a\u0430\u0447\u0430\u043d\u044b, \u043e\u0448\u0438\u0431\u043a\u0430 \u0441\u0435\u0440\u0432\u0435\u0440\u0430!");
        }
        try {
            HttpServletResponse response = (HttpServletResponse)this.request.getAttribute("response");
            response.getOutputStream().write(report.toString().getBytes("UTF-8"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private StringBuffer prepareReport(Vector<String> wrongLines, Vector<String> createdDest, Vector<String> updatedPrices, Vector<String> createdPrices, int count, Date date) {
        StringBuffer report = new StringBuffer();
        report.append("\u0417\u0430\u043a\u0430\u0447\u043a\u0430 \u0442\u0430\u0440\u0438\u0444\u043e\u0432 IP \u0442\u0435\u043b\u0435\u0444\u043e\u043d\u0438\u0438.\n");
        report.append("\u0414\u0430\u0442\u0430 \u043d\u0430\u0447\u0430\u043b\u0430 \u0434\u0435\u0439\u0441\u0442\u0432\u0438\u044f \u0446\u0435\u043d: " + TimeUtils.formatDate((Date)date) + "\n");
        report.append("\u041a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u044b\u0445 \u0437\u0430\u043f\u0438\u0441\u0435\u0439: " + count + "\n");
        if (wrongLines.size() > 0) {
            report.append("\u0417\u0430\u043f\u0438\u0441\u0438 \u0441 \u043d\u0435\u0432\u0435\u0440\u043d\u044b\u043c \u0444\u043e\u0440\u043c\u0430\u0442\u043e\u043c ( " + wrongLines.size() + " ):\n");
            this.addVector(report, wrongLines);
        }
        if (createdDest.size() > 0) {
            report.append("\u0421\u043e\u0437\u0434\u0430\u043d\u044b \u043d\u0430\u043f\u0440\u0430\u0432\u043b\u0435\u043d\u0438\u044f ( " + createdDest.size() + " ):\n");
            this.addVector(report, createdDest);
        }
        if (updatedPrices.size() > 0) {
            report.append("\u0418\u0437\u043c\u0435\u043d\u0435\u043d\u044b \u0446\u0435\u043d\u044b ( " + updatedPrices.size() + " ):\n");
            this.addVector(report, updatedPrices);
        }
        if (createdPrices.size() > 0) {
            report.append("\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u044b \u043d\u043e\u0432\u044b\u0435 \u0446\u0435\u043d\u044b ( " + createdPrices.size() + " ):\n");
            this.addVector(report, createdPrices);
        }
        return report;
    }

    private void addVector(StringBuffer buf, Vector<String> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            buf.append("\t" + vector.get(i) + "\n");
        }
    }
}

